/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven;

import eu.lindenbaum.maven.TargetLayout;
import java.io.File;
import org.apache.maven.project.MavenProject;

public class DefaultTargetLayout
implements TargetLayout {
    private final MavenProject project;
    private final File base;

    public DefaultTargetLayout(MavenProject project) {
        this.project = project;
        this.base = new File(project.getBuild().getDirectory());
    }

    @Override
    public File base() {
        return this.base;
    }

    @Override
    public File lib() {
        return new File(this.base, "lib");
    }

    @Override
    public File projectArtifact() {
        String name = this.project.getArtifactId() + "-" + this.project.getVersion();
        return new File(this.base, name + ".tar.gz");
    }

    @Override
    public File dialyzerOk() {
        return new File(this.base, ".dialyzer.ok");
    }

    @Override
    public File backendLog() {
        return new File(this.base, "backend.log");
    }

    @Override
    public File project() {
        return new File(this.base, this.project.getArtifactId() + "-" + this.project.getVersion());
    }

    @Override
    public File appFile() {
        return new File(this.ebin(), this.project.getArtifactId() + ".app");
    }

    @Override
    public File appupFile() {
        return new File(this.ebin(), this.project.getArtifactId() + ".appup");
    }

    @Override
    public File ebin() {
        return new File(this.project(), "ebin");
    }

    @Override
    public File include() {
        return new File(this.project(), "include");
    }

    @Override
    public File priv() {
        return new File(this.project(), "priv");
    }

    @Override
    public File src() {
        return new File(this.project(), "src");
    }

    @Override
    public File test() {
        return new File(this.base, this.project.getArtifactId() + "-" + this.project.getVersion() + "-test");
    }

    @Override
    public File testEbin() {
        return new File(this.test(), "ebin");
    }

    @Override
    public File testInclude() {
        return new File(this.test(), "include");
    }

    @Override
    public File testPriv() {
        return new File(this.test(), "priv");
    }

    @Override
    public File overviewEdoc() {
        return new File(this.base, "overview.edoc");
    }

    @Override
    public File surefireReports() {
        return new File(this.base, "surefire-reports");
    }

    @Override
    public File coverageReports() {
        return new File(this.base, "coverage-reports");
    }

    @Override
    public File profilingReports() {
        return new File(this.base, "profiling-reports");
    }

    @Override
    public File relFile() {
        String name = this.project.getArtifactId() + "-" + this.project.getVersion();
        return new File(this.base, name + ".rel");
    }

    @Override
    public File relupFile() {
        return new File(this.base, "relup");
    }

    @Override
    public File sysConfigFile() {
        return new File(this.base, "sys.config");
    }
}

