/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.util;

import eu.lindenbaum.maven.util.CollectionUtils;
import eu.lindenbaum.maven.util.Predicate;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.maven.plugin.MojoExecutionException;

public final class NetworkUtils {
    public static String getIPv4Address() throws MojoExecutionException {
        Collection<InetAddress> addresses = NetworkUtils.filterInetAddresses(NetworkUtils.getInetAddresses(), true);
        Collection<InetAddress> sorted = NetworkUtils.sortInetAddresses(addresses);
        Iterator<InetAddress> i$ = sorted.iterator();
        if (i$.hasNext()) {
            InetAddress address = i$.next();
            return address.getHostAddress();
        }
        throw new MojoExecutionException("Couldn't resolve any IPv4 addresses.");
    }

    public static Collection<InetAddress> getInetAddresses() throws MojoExecutionException {
        ArrayList<InetAddress> addressList = new ArrayList<InetAddress>();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface i = interfaces.nextElement();
                if (!i.isUp()) continue;
                Enumeration<InetAddress> addresses = i.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    addressList.add(addresses.nextElement());
                }
            }
            return addressList;
        }
        catch (SocketException e) {
            throw new MojoExecutionException("Failed to retrieve network interfaces.", (Exception)e);
        }
    }

    public static Collection<InetAddress> filterInetAddresses(Collection<InetAddress> in, final boolean ipv4only) {
        return CollectionUtils.filter(new Predicate<InetAddress>(){

            @Override
            public boolean pred(InetAddress address) {
                return !address.isAnyLocalAddress() && !address.isMulticastAddress() && (ipv4only && address instanceof Inet4Address || !ipv4only && address instanceof Inet6Address);
            }
        }, in);
    }

    public static Collection<InetAddress> sortInetAddresses(Collection<InetAddress> in) {
        ArrayList<InetAddress> sorted = new ArrayList<InetAddress>(in);
        Collections.sort(sorted, new Comparator<InetAddress>(){

            @Override
            public int compare(InetAddress o1, InetAddress o2) {
                int isSiteLocal;
                int is192;
                boolean l1 = o1.isLoopbackAddress();
                boolean l2 = o2.isLoopbackAddress();
                boolean s1 = o1.isSiteLocalAddress();
                boolean s2 = o2.isSiteLocalAddress();
                boolean i1 = o1.getHostAddress().startsWith("192");
                boolean i2 = o2.getHostAddress().startsWith("192");
                int n = i1 ? (i2 ? 0 : -1) : (is192 = i2 ? 1 : 0);
                int n2 = s1 ? (s2 ? is192 : 1) : (isSiteLocal = s2 ? -1 : 0);
                return l1 ? (l2 ? 0 : 1) : (l2 ? -1 : isSiteLocal);
            }
        });
        return sorted;
    }
}

