/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.util;

import eu.lindenbaum.maven.util.Predicate;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.SelectorUtils;

public final class FileUtils {
    public static final FileFilter SOURCE_FILTER = FileUtils.getSuffixFilter(new String[]{".hrl", ".erl"});
    public static final FileFilter BEAM_FILTER = FileUtils.getSuffixFilter(new String[]{".beam"});
    public static final FileFilter APP_FILTER = FileUtils.getSuffixFilter(new String[]{".app", ".appup"});
    public static final FileFilter REL_FILTER = FileUtils.getSuffixFilter(new String[]{".rel"});
    public static final FileFilter SRC_FILTER = FileUtils.getSuffixFilter(new String[]{".src"});
    public static FileFilter NULL_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return true;
        }
    };
    public static Predicate<File> FILE_PRED = new Predicate<File>(){

        @Override
        public boolean pred(File file) {
            return file != null && file.exists();
        }
    };

    public static FileFilter getSuffixFilter(final String[] suffixes) {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isFile()) {
                    for (String pattern : suffixes) {
                        String name = file.getName();
                        if (!name.endsWith(pattern)) continue;
                        return true;
                    }
                    return false;
                }
                return true;
            }
        };
    }

    public static List<File> getFilesRecursive(File root, final String suffix) {
        final ArrayList<File> files = new ArrayList<File>();
        if (root.isDirectory()) {
            final String[] excludes = org.codehaus.plexus.util.FileUtils.getDefaultExcludes();
            files.addAll(Arrays.asList(root.listFiles(new FileFilter(){

                @Override
                public boolean accept(File child) {
                    if (child.isDirectory()) {
                        for (String exclude : excludes) {
                            if (!SelectorUtils.match((String)exclude, (String)child.getAbsolutePath())) continue;
                            return false;
                        }
                        files.addAll(FileUtils.getFilesRecursive(child, suffix));
                        return false;
                    }
                    return child.getName().endsWith(suffix);
                }
            })));
        }
        return files;
    }

    public static List<File> getFilesRecursive(List<File> directories, String suffix) {
        ArrayList<File> result = new ArrayList<File>();
        for (File dir : directories) {
            result.addAll(FileUtils.getFilesRecursive(dir, suffix));
        }
        return result;
    }

    public static File getFile(String pathPostfix, Collection<File> files) {
        for (File file : files) {
            if (!file.getAbsolutePath().endsWith(pathPostfix)) continue;
            return file;
        }
        return null;
    }

    public static int removeFilesRecursive(File root, String suffix) {
        List<File> files = FileUtils.getFilesRecursive(root, suffix);
        return FileUtils.removeFiles(files.toArray(new File[0]));
    }

    public static void removeDirectory(File directory) {
        try {
            org.codehaus.plexus.util.FileUtils.deleteDirectory((File)directory);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void removeEmptyDirectory(File directory) throws MojoExecutionException {
        String[] list;
        if (directory.isDirectory() && (list = directory.list()) != null && list.length == 0 && !directory.delete()) {
            throw new MojoExecutionException("Failed to delete empty directory " + directory + ".");
        }
    }

    public static int removeFiles(File ... files) {
        int removed = 0;
        for (File file : files) {
            if (!file.isFile() || !file.delete()) continue;
            ++removed;
        }
        return removed;
    }

    public static void removeFileNameSuffix(String suffix, File ... files) throws MojoExecutionException {
        for (File file : files) {
            if (!file.isFile()) continue;
            String newFileName = file.getName().replace(suffix, "");
            File dest = new File(file.getParentFile(), newFileName);
            try {
                org.codehaus.plexus.util.FileUtils.rename((File)file, (File)dest);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to rename " + file + ".");
            }
        }
    }

    public static List<File> getFilesAndDirectoriesRecursive(File root, final FileFilter filter) {
        final ArrayList<File> files = new ArrayList<File>();
        if (root.isDirectory()) {
            final String[] excludes = org.codehaus.plexus.util.FileUtils.getDefaultExcludes();
            files.addAll(Arrays.asList(root.listFiles(new FileFilter(){

                @Override
                public boolean accept(File child) {
                    boolean accept = filter.accept(child);
                    for (String exclude : excludes) {
                        if (!SelectorUtils.match((String)exclude, (String)child.getAbsolutePath())) continue;
                        accept = false;
                        break;
                    }
                    if (accept && child.isDirectory()) {
                        files.addAll(FileUtils.getFilesAndDirectoriesRecursive(child, filter));
                    }
                    return accept;
                }
            })));
        }
        return files;
    }

    public static List<File> getDirectoriesRecursive(File root, String suffix) {
        HashSet<File> result = new HashSet<File>();
        if (root != null && root.exists()) {
            for (File beam : FileUtils.getFilesRecursive(root, suffix)) {
                File parentFile = beam.getParentFile();
                if (parentFile == null) continue;
                result.add(parentFile);
            }
        }
        return new ArrayList<File>(result);
    }

    public static List<File> getDirectories(File root, Collection<String> excludes) {
        final HashSet<String> excludeStrings = new HashSet<String>(Arrays.asList(org.codehaus.plexus.util.FileUtils.getDefaultExcludes()));
        excludeStrings.addAll(excludes);
        if (root != null && root.isDirectory()) {
            return new ArrayList<File>(Arrays.asList(root.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() && !excludeStrings.contains(file.getName());
                }
            })));
        }
        return new ArrayList<File>();
    }

    public static Collection<File> copyDirectory(File from, File to, FileFilter filter) throws MojoExecutionException {
        ArrayList<File> copied = new ArrayList<File>();
        if (from.exists() && from.isDirectory()) {
            List<File> toCopy = FileUtils.getFilesAndDirectoriesRecursive(from, filter);
            for (File src : toCopy) {
                File dest = new File(to, src.getAbsolutePath().replace(from.getAbsolutePath(), ""));
                if (src.isDirectory()) {
                    FileUtils.ensureDirectories(dest);
                    continue;
                }
                FileUtils.copyFile(src, dest);
                copied.add(src);
            }
            for (File src : toCopy) {
                FileUtils.removeEmptyDirectory(new File(to, src.getAbsolutePath().replace(from.getAbsolutePath(), "")));
            }
        }
        return copied;
    }

    public static Collection<File> copyDirectory(File from, File to, FileFilter filter, Map<String, String> replacements) throws MojoExecutionException {
        ArrayList<File> copied = new ArrayList<File>();
        if (from.exists() && from.isDirectory()) {
            List<File> toCopy = FileUtils.getFilesAndDirectoriesRecursive(from, filter);
            for (File src : toCopy) {
                File dest = new File(to, src.getAbsolutePath().replace(from.getAbsolutePath(), ""));
                if (src.isDirectory()) {
                    FileUtils.ensureDirectories(dest);
                    continue;
                }
                FileUtils.copyFile(src, dest, replacements);
                copied.add(src);
            }
            for (File src : toCopy) {
                FileUtils.removeEmptyDirectory(new File(to, src.getAbsolutePath().replace(from.getAbsolutePath(), "")));
            }
        }
        return copied;
    }

    public static void copyFile(File from, File to, Map<String, String> replacements) throws MojoExecutionException {
        try {
            String content = org.codehaus.plexus.util.FileUtils.fileRead((File)from, (String)"UTF-8");
            for (Map.Entry<String, String> replacement : replacements.entrySet()) {
                String value = replacement.getValue() == null ? "" : replacement.getValue();
                content = content.replace(replacement.getKey(), value);
            }
            File parent = to.getParentFile();
            if (parent != null) {
                FileUtils.ensureDirectories(parent);
            }
            FileUtils.writeFile(to, content, from.canExecute());
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    public static void copyFiles(File destination, File ... files) throws MojoExecutionException {
        FileUtils.ensureDirectories(destination);
        for (File file : files) {
            FileUtils.copyFile(file, new File(destination, file.getName()));
        }
    }

    public static void writeFile(File destination, String data) throws MojoExecutionException {
        FileUtils.writeFile(destination, data, false);
    }

    public static void writeFile(File destination, String data, boolean executable) throws MojoExecutionException {
        try {
            org.codehaus.plexus.util.FileUtils.fileWrite((String)destination.getAbsolutePath(), (String)"UTF-8", (String)data);
            if (executable) {
                destination.setExecutable(true, false);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write " + destination + ": " + e.getMessage());
        }
    }

    public static void ensureDirectories(File ... dirs) throws MojoExecutionException {
        for (File dir : dirs) {
            if (dir.isDirectory()) continue;
            if (dir.isFile()) {
                throw new MojoExecutionException("Failed to create directory " + dir + " (is a file).");
            }
            if (dir.mkdirs()) continue;
            throw new MojoExecutionException("Failed to create directory " + dir + ".");
        }
    }

    public static void touch(File file) throws MojoExecutionException {
        if (file.isFile()) {
            if (!file.setLastModified(System.currentTimeMillis())) {
                throw new MojoExecutionException("Failed to update modification time on " + file + ".");
            }
        } else {
            try {
                if (!file.createNewFile()) {
                    throw new MojoExecutionException("Failed to create " + file + ".");
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to create " + file + ".", (Exception)e);
            }
        }
    }

    public static void extractFileFromClassPath(Class<?> clazz, String path, String name, File dest) throws MojoExecutionException {
        if (dest.isDirectory()) {
            throw new MojoExecutionException("Destination must be a file.");
        }
        FileUtils.ensureDirectories(dest.getParentFile());
        FileUtils.writeFile(dest, FileUtils.readFileFromClassPath(clazz, path, name));
    }

    public static String readFileFromClassPath(Class<?> clazz, String path, String name) throws MojoExecutionException {
        String resource = path + "/" + name;
        InputStream resourceStream = clazz.getResourceAsStream(resource);
        if (resourceStream != null) {
            StringBuilder data = new StringBuilder(4096);
            BufferedInputStream input = new BufferedInputStream(resourceStream);
            byte[] b = new byte[4096];
            try {
                int numRead;
                while ((numRead = input.read(b, 0, b.length)) != -1) {
                    data.append(new String(b, 0, numRead));
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to read from resource " + resource + ".", (Exception)e);
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
            return data.toString();
        }
        throw new MojoExecutionException("Could not find resource " + resource + ".");
    }

    private static void copyFile(File src, File dest) throws MojoExecutionException {
        try {
            org.codehaus.plexus.util.FileUtils.copyFile((File)src, (File)dest);
            if (src.canExecute()) {
                dest.setExecutable(true, false);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to copy " + src + ".", (Exception)e);
        }
    }
}

