/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.util;

import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangInt;
import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangLong;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangRangeException;
import com.ericsson.otp.erlang.OtpErlangString;
import com.ericsson.otp.erlang.OtpErlangUInt;
import eu.lindenbaum.maven.erlang.CheckAppResult;
import eu.lindenbaum.maven.util.Predicate;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import org.apache.maven.artifact.Artifact;

public final class ErlUtils {
    public static <T> String toList(T[] array, Predicate<T> p, String prefix, String postfix) {
        if (array != null) {
            return ErlUtils.toList(Arrays.asList(array), p, prefix, postfix);
        }
        return "[]";
    }

    public static <T> String toList(Collection<T> list, Predicate<T> p, String prefix, String postfix) {
        StringBuilder result = new StringBuilder("[");
        int i = 0;
        for (T elem : list) {
            if (p != null && !p.pred(elem)) continue;
            if (i != 0) {
                result.append(", ");
            }
            result.append(prefix);
            result.append(elem.toString());
            result.append(postfix);
            ++i;
        }
        result.append("]");
        return result.toString();
    }

    public static String toFilenameList(Collection<File> list, String prefix, String postfix) {
        StringBuilder result = new StringBuilder("[");
        int i = 0;
        for (File file : list) {
            if (file == null || !file.exists()) continue;
            if (i != 0) {
                result.append(", ");
            }
            result.append(prefix);
            result.append(file.getAbsolutePath());
            result.append(postfix);
            ++i;
        }
        result.append("]");
        return result.toString();
    }

    public static String toModuleList(Collection<File> list, String prefix, String postfix) {
        StringBuilder result = new StringBuilder("[");
        int i = 0;
        for (File file : list) {
            if (file == null || !file.exists()) continue;
            if (i != 0) {
                result.append(", ");
            }
            result.append(prefix);
            String module = file.getName().replace(".beam", "");
            result.append(module.replace(".erl", ""));
            result.append(postfix);
            ++i;
        }
        result.append("]");
        return result.toString();
    }

    public static String toString(OtpErlangObject object) {
        return ErlUtils.toString(object, true);
    }

    public static String toString(OtpErlangObject object, boolean trim) {
        if (object instanceof OtpErlangString) {
            String stringValue = ((OtpErlangString)object).stringValue();
            return trim ? stringValue.trim() : stringValue;
        }
        if (object instanceof OtpErlangAtom) {
            String atomValue = ((OtpErlangAtom)object).atomValue();
            return trim ? atomValue.trim() : atomValue;
        }
        if (object instanceof OtpErlangList && ((OtpErlangList)object).arity() == 0) {
            return "";
        }
        return trim ? object.toString().trim() : object.toString();
    }

    public static int toInt(OtpErlangObject object) {
        try {
            if (object instanceof OtpErlangInt) {
                return ((OtpErlangInt)object).intValue();
            }
            if (object instanceof OtpErlangUInt) {
                return ((OtpErlangUInt)object).intValue();
            }
            if (object instanceof OtpErlangLong) {
                return ((OtpErlangLong)object).intValue();
            }
        }
        catch (OtpErlangRangeException otpErlangRangeException) {
            // empty catch block
        }
        return 0;
    }

    public static String toApplicationTuples(Artifact ... artifacts) {
        StringBuilder applications = new StringBuilder();
        int i = 0;
        for (Artifact artifact : artifacts) {
            if (i++ != 0) {
                applications.append(",\n  ");
            }
            applications.append("{'");
            applications.append(artifact.getArtifactId());
            applications.append("', \"");
            applications.append(artifact.getBaseVersion());
            applications.append("\"}");
        }
        return applications.toString();
    }

    public static String toApplicationTuples(CheckAppResult ... applicationInfos) {
        StringBuilder applications = new StringBuilder();
        int i = 0;
        for (CheckAppResult applicationInfo : applicationInfos) {
            if (i++ != 0) {
                applications.append(",\n  ");
            }
            applications.append("{'");
            applications.append(applicationInfo.getName());
            applications.append("', \"");
            applications.append(applicationInfo.getVersion());
            applications.append("\"}");
        }
        return applications.toString();
    }

    public static String toArtifactIdListing(Collection<Artifact> artifacts) {
        StringBuilder applications = new StringBuilder();
        int i = 0;
        for (Artifact artifact : artifacts) {
            if (i++ != 0) {
                applications.append(", ");
            }
            applications.append(artifact.getArtifactId());
        }
        return applications.toString();
    }
}

