/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.report;

import eu.lindenbaum.maven.ErlangReport;
import eu.lindenbaum.maven.Properties;
import eu.lindenbaum.maven.erlang.EDocScript;
import eu.lindenbaum.maven.erlang.MavenSelf;
import eu.lindenbaum.maven.util.FileUtils;
import eu.lindenbaum.maven.util.MavenUtils;
import java.io.File;
import java.util.Locale;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class EDocReport
extends ErlangReport {
    public String getOutputName() {
        return "edoc/index";
    }

    public String getName(Locale locale) {
        return "edoc";
    }

    public String getDescription(Locale locale) {
        return "Source code documentation of the project.";
    }

    public boolean isExternalReport() {
        return true;
    }

    @Override
    protected void execute(Log log, Locale l, Properties p) throws MojoExecutionException {
        log.info((CharSequence)MavenUtils.SEPARATOR);
        log.info((CharSequence)" E D O C");
        log.info((CharSequence)MavenUtils.SEPARATOR);
        if (!this.canGenerateReport()) {
            log.info((CharSequence)"Nothing to do.");
            return;
        }
        String application = p.project().getArtifactId();
        File outdir = new File(this.getReportOutputDirectory(), "edoc");
        File overview = p.targetLayout().overviewEdoc();
        FileUtils.ensureDirectories(outdir);
        EDocScript script = new EDocScript(application, p.sourceLayout().src(), outdir, overview);
        Boolean success = MavenSelf.get(p.cookie()).exec(p.node(), script);
        if (!success.booleanValue()) {
            throw new MojoExecutionException("failed to generate documentation");
        }
        log.info((CharSequence)"Successfully generated documentation.");
    }
}

