/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.mojo.rel;

import eu.lindenbaum.maven.ErlangMojo;
import eu.lindenbaum.maven.Properties;
import eu.lindenbaum.maven.erlang.CheckAppResult;
import eu.lindenbaum.maven.erlang.CheckAppScript;
import eu.lindenbaum.maven.erlang.GenericScriptResult;
import eu.lindenbaum.maven.erlang.MakeScriptScript;
import eu.lindenbaum.maven.erlang.MavenSelf;
import eu.lindenbaum.maven.erlang.RuntimeInfo;
import eu.lindenbaum.maven.erlang.RuntimeInfoScript;
import eu.lindenbaum.maven.util.ErlUtils;
import eu.lindenbaum.maven.util.FileUtils;
import eu.lindenbaum.maven.util.MavenUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public final class ResourceGenerator
extends ErlangMojo {
    private String scriptOptions;

    @Override
    protected void execute(Log log, Properties p) throws MojoExecutionException, MojoFailureException {
        RuntimeInfoScript infoScript = new RuntimeInfoScript();
        RuntimeInfo runtimeInfo = MavenSelf.get(p.cookie()).exec(p.node(), infoScript);
        String releaseName = p.project().getArtifactId();
        String releaseVersion = p.project().getVersion();
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("${ARTIFACT}", "\"" + releaseName + "\"");
        replacements.put("${VERSION}", "\"" + releaseVersion + "\"");
        replacements.put("${ERTS}", "{erts, \"" + runtimeInfo.getVersion() + "\"}");
        Set<Artifact> artifacts = MavenUtils.getErlangReleaseArtifacts(p.project());
        Set<String> artifactIds = MavenUtils.getArtifactIds(artifacts);
        artifactIds.addAll(Arrays.asList("kernel", "stdlib", "sasl"));
        File base = p.targetLayout().base();
        List<File> codePaths = p.codePaths(false);
        codePaths.addAll(runtimeInfo.getPaths());
        codePaths.removeAll(Arrays.asList(base));
        Collections.reverse(codePaths);
        log.debug((CharSequence)("Application lookup path is: " + codePaths));
        Map<String, CheckAppResult> appInfos = ResourceGenerator.getAppInfos(p, codePaths);
        Set<CheckAppResult> autoDependencies = ResourceGenerator.getDependencies(artifactIds, appInfos);
        log.debug((CharSequence)("Found dependencies: " + autoDependencies));
        String applicationTuples = ErlUtils.toApplicationTuples(autoDependencies.toArray(new CheckAppResult[0]));
        replacements.put("${APPLICATIONS}", applicationTuples);
        replacements.put("${AUTODEPS}", "[" + applicationTuples + "]");
        replacements.putAll(ResourceGenerator.getApplicationMappings(appInfos));
        log.debug((CharSequence)("Created mappings: " + replacements));
        File relFile = p.targetLayout().relFile();
        ResourceGenerator.checkReleaseFile(log, p.sourceLayout().relFile());
        FileUtils.copyFile(p.sourceLayout().relFile(), relFile, replacements);
        log.debug((CharSequence)("Copied release file to " + relFile + " ."));
        File relupFile = p.targetLayout().relupFile();
        ResourceGenerator.checkReleaseUpgradeFile(log, p.sourceLayout().relupFile());
        FileUtils.copyFile(p.sourceLayout().relupFile(), relupFile, replacements);
        log.debug((CharSequence)("Copied release upgrade file to " + relupFile + " ."));
        File sysConfigFile = p.targetLayout().sysConfigFile();
        ResourceGenerator.checkSystemConfig(log, p.sourceLayout().sysConfigFile());
        FileUtils.copyFile(p.sourceLayout().sysConfigFile(), sysConfigFile, replacements);
        log.debug((CharSequence)("Copied system configuration file to " + sysConfigFile + " ."));
        MakeScriptScript script = new MakeScriptScript(relFile, base, this.scriptOptions);
        GenericScriptResult makeScriptResult = MavenSelf.get(p.cookie()).exec(p.node(), script);
        makeScriptResult.logOutput(log);
        if (!makeScriptResult.success()) {
            throw new MojoFailureException("Could not create boot scripts.");
        }
    }

    private static Map<String, String> getApplicationMappings(Map<String, CheckAppResult> appInfos) {
        HashMap<String, String> mappings = new HashMap<String, String>();
        for (Map.Entry<String, CheckAppResult> entry : appInfos.entrySet()) {
            CheckAppResult appResult = entry.getValue();
            String key = "${" + appResult.getName().toUpperCase() + "}";
            mappings.put(key, "{'" + appResult.getName() + "',\"" + appResult.getVersion() + "\"}");
        }
        return mappings;
    }

    private static Map<String, CheckAppResult> getAppInfos(Properties p, List<File> paths) throws MojoExecutionException {
        HashMap<String, CheckAppResult> applications = new HashMap<String, CheckAppResult>();
        for (File path : paths) {
            for (File appFile : FileUtils.getFilesRecursive(path, ".app")) {
                CheckAppScript script = new CheckAppScript(appFile);
                CheckAppResult result = MavenSelf.get(p.cookie()).exec(p.node(), script);
                applications.put(result.getName(), result);
            }
        }
        return applications;
    }

    private static CheckAppResult resolve(String application, Map<String, CheckAppResult> appInfos) {
        CheckAppResult result = appInfos.get(application);
        if (result == null) {
            throw new IllegalStateException("Can't resolve application '" + application + "'.");
        }
        return result;
    }

    private static Set<CheckAppResult> getDependencies(Collection<String> artifactIds, Map<String, CheckAppResult> appInfos) {
        HashSet<String> done = new HashSet<String>();
        LinkedList<String> todo = new LinkedList<String>(artifactIds);
        HashSet<CheckAppResult> dependencies = new HashSet<CheckAppResult>();
        while (!todo.isEmpty()) {
            String dependency = todo.removeFirst();
            if (done.contains(dependency)) continue;
            done.add(dependency);
            CheckAppResult appResult = ResourceGenerator.resolve(dependency, appInfos);
            todo.addAll(appResult.getApplications());
            dependencies.add(appResult);
        }
        return dependencies;
    }

    private static void checkSystemConfig(Log log, File sysConfig) throws MojoFailureException {
        if (!sysConfig.isFile()) {
            log.error((CharSequence)"Errors:");
            log.error((CharSequence)" * system configuration file not found, use 'mvn erlang:setup' to create");
            log.error((CharSequence)"   a default system configuration file");
            throw new MojoFailureException(sysConfig.toString() + " does not exist.");
        }
    }

    private static void checkReleaseUpgradeFile(Log log, File relup) throws MojoFailureException {
        if (!relup.isFile()) {
            log.error((CharSequence)"Errors:");
            log.error((CharSequence)" * release upgrade file not found, use 'mvn erlang:relup' or");
            log.error((CharSequence)"   'mvn erlang:setup' to create a template relup file");
            throw new MojoFailureException(relup.toString() + " does not exist.");
        }
    }

    private static void checkReleaseFile(Log log, File rel) throws MojoFailureException {
        if (!rel.isFile()) {
            log.error((CharSequence)"Errors:");
            log.error((CharSequence)" * release file not found, use 'mvn erlang:setup' to create a default");
            log.error((CharSequence)"   release file");
            throw new MojoFailureException(rel.toString() + " does not exist.");
        }
    }
}

