/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.mojo.rel;

import eu.lindenbaum.maven.ErlangMojo;
import eu.lindenbaum.maven.Properties;
import eu.lindenbaum.maven.erlang.GenericScriptResult;
import eu.lindenbaum.maven.erlang.MakeTarScript;
import eu.lindenbaum.maven.erlang.MavenSelf;
import eu.lindenbaum.maven.util.MavenUtils;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public final class Packager
extends ErlangMojo {
    private String tarOptions;
    private boolean includeErts;

    @Override
    protected void execute(Log log, Properties p) throws MojoExecutionException, MojoFailureException {
        String options;
        log.info((CharSequence)MavenUtils.SEPARATOR);
        log.info((CharSequence)" P A C K A G E R");
        log.info((CharSequence)MavenUtils.SEPARATOR);
        String string = options = this.tarOptions != null ? this.tarOptions : "";
        if (this.includeErts) {
            String erts = "{erts,code:root_dir()}";
            options = options.isEmpty() ? erts : erts + "," + options;
        }
        File relFile = p.targetLayout().relFile();
        MakeTarScript script = new MakeTarScript(relFile, p.targetLayout().base(), options);
        GenericScriptResult result = MavenSelf.get(p.cookie()).exec(p.node(), script);
        result.logOutput(log);
        if (!result.success()) {
            throw new MojoFailureException("Could not create release package.");
        }
        File releaseTarGz = p.targetLayout().projectArtifact();
        if (!releaseTarGz.isFile()) {
            throw new MojoFailureException("Could not find packaged release " + releaseTarGz.getPath());
        }
        p.project().getArtifact().setFile(releaseTarGz);
        log.info((CharSequence)"Successfully created release package:");
        log.info((CharSequence)releaseTarGz.toString());
    }
}

