/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.mojo.app;

import eu.lindenbaum.maven.ErlangMojo;
import eu.lindenbaum.maven.Properties;
import eu.lindenbaum.maven.erlang.MavenSelf;
import eu.lindenbaum.maven.erlang.TestResult;
import eu.lindenbaum.maven.erlang.TestScript;
import eu.lindenbaum.maven.util.FileUtils;
import eu.lindenbaum.maven.util.MavenUtils;
import eu.lindenbaum.maven.util.MojoUtils;
import java.io.File;
import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public final class TestRunner
extends ErlangMojo {
    private boolean skipTests;
    private String test;

    @Override
    protected void execute(Log log, Properties p) throws MojoExecutionException, MojoFailureException {
        log.info((CharSequence)MavenUtils.SEPARATOR);
        log.info((CharSequence)" T E S T - R U N N E R");
        log.info((CharSequence)MavenUtils.SEPARATOR);
        if (this.skipTests) {
            log.info((CharSequence)"Tests are skipped.");
            return;
        }
        ArrayList<File> tests = new ArrayList<File>();
        if (this.test == null || this.test.isEmpty()) {
            tests.addAll(MojoUtils.getEunitTestSet(p.modules(true, false), p.testSupportArtifacts()));
        } else {
            String[] testNames;
            for (String testName : testNames = this.test.split(",")) {
                File test = new File(p.targetLayout().testEbin(), testName.trim() + ".beam");
                if (!test.isFile()) continue;
                tests.add(test);
            }
        }
        if (tests.isEmpty()) {
            log.info((CharSequence)"No tests to run.");
            return;
        }
        File surefireReports = p.targetLayout().surefireReports();
        FileUtils.ensureDirectories(surefireReports);
        log.debug((CharSequence)String.format("Executing %s test(s):", tests.size()));
        MavenUtils.logCollection(log, MavenUtils.LogLevel.DEBUG, tests, " * ");
        String suiteName = p.project().getArtifactId();
        TestScript script = new TestScript(tests, surefireReports, suiteName);
        TestResult result = MavenSelf.get(p.cookie()).exec(p.testNode(), script);
        result.logOutput(log);
        int passed = result.passed();
        int failed = result.failed();
        int skipped = result.skipped();
        int cancelled = result.cancelled();
        if ((passed | failed | skipped | cancelled) == 0) {
            log.warn((CharSequence)"  There were no tests to run.");
        } else if ((failed | skipped | cancelled) == 0 && passed == 1) {
            log.info((CharSequence)"  Test passed.");
        } else if ((failed | skipped | cancelled) == 0 && passed > 1) {
            log.info((CharSequence)("  All " + passed + " tests passed."));
        } else {
            log.error((CharSequence)MavenUtils.FAT_SEPARATOR);
            log.error((CharSequence)String.format("  Failed: %s.  Skipped: %s.  Passed: %s.  Cancelled: %s.", failed, skipped, passed, cancelled));
            throw new MojoFailureException("There were test failures.");
        }
    }
}

