/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.mojo.app;

import eu.lindenbaum.maven.ErlangMojo;
import eu.lindenbaum.maven.Properties;
import eu.lindenbaum.maven.util.FileUtils;
import eu.lindenbaum.maven.util.MavenUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public final class TestResourceGenerator
extends ErlangMojo {
    private boolean skipTests;

    @Override
    protected void execute(Log log, Properties p) throws MojoExecutionException {
        if (this.skipTests) {
            return;
        }
        ArrayList<File> current = new ArrayList<File>();
        current.addAll(TestResourceGenerator.copyIncludes(p));
        current.addAll(TestResourceGenerator.copyResources(p));
        current.addAll(TestResourceGenerator.copyNonErlangDependencies(log, p));
        if (current.size() > 0) {
            log.debug((CharSequence)"Copied test resources:");
            MavenUtils.logCollection(log, MavenUtils.LogLevel.DEBUG, current, " * ");
        } else {
            FileUtils.removeEmptyDirectory(p.targetLayout().test());
        }
    }

    private static Collection<File> copyIncludes(Properties p) throws MojoExecutionException {
        File include = p.sourceLayout().include();
        File testInclude = p.sourceLayout().testInclude();
        File targetInclude = p.targetLayout().testInclude();
        FileUtils.removeDirectory(targetInclude);
        ArrayList<File> copied = new ArrayList<File>();
        copied.addAll(FileUtils.copyDirectory(include, targetInclude, FileUtils.SOURCE_FILTER));
        copied.addAll(FileUtils.copyDirectory(testInclude, targetInclude, FileUtils.SOURCE_FILTER));
        return copied;
    }

    private static Collection<File> copyResources(Properties p) throws MojoExecutionException {
        File priv = p.sourceLayout().priv();
        File testPriv = p.sourceLayout().testPriv();
        File targetPriv = p.targetLayout().testPriv();
        FileUtils.removeDirectory(targetPriv);
        ArrayList<File> copied = new ArrayList<File>();
        copied.addAll(FileUtils.copyDirectory(priv, targetPriv, FileUtils.NULL_FILTER));
        copied.addAll(FileUtils.copyDirectory(testPriv, targetPriv, FileUtils.NULL_FILTER));
        return copied;
    }

    private static Collection<File> copyNonErlangDependencies(Log log, Properties p) {
        File targetPriv = p.targetLayout().testPriv();
        ArrayList<File> copied = new ArrayList<File>();
        for (Artifact artifact : MavenUtils.getForeignDependencies(p.project())) {
            File source = artifact.getFile();
            File destination = new File(targetPriv, source.getName());
            try {
                org.codehaus.plexus.util.FileUtils.copyFile((File)source, (File)destination);
                copied.add(source);
            }
            catch (IOException e) {
                log.error((CharSequence)("Failed to copy artifact " + source.getPath() + " to " + targetPriv + "."), (Throwable)e);
            }
        }
        return copied;
    }
}

