/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.mojo.app;

import eu.lindenbaum.maven.ErlangMojo;
import eu.lindenbaum.maven.Properties;
import eu.lindenbaum.maven.erlang.MavenSelf;
import eu.lindenbaum.maven.erlang.ProfilingResult;
import eu.lindenbaum.maven.erlang.ProfilingScript;
import eu.lindenbaum.maven.util.FileUtils;
import eu.lindenbaum.maven.util.MavenUtils;
import eu.lindenbaum.maven.util.MojoUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public final class Profiler
extends ErlangMojo {
    private String test;
    private int timeout;
    private boolean silent;
    private boolean details;

    @Override
    protected void execute(Log log, Properties p) throws MojoExecutionException, MojoFailureException {
        log.info((CharSequence)MavenUtils.SEPARATOR);
        log.info((CharSequence)" P R O F I L E R");
        log.info((CharSequence)MavenUtils.SEPARATOR);
        if (this.timeout <= 0) {
            throw new IllegalArgumentException("timeout must be a positive integer");
        }
        ArrayList<File> tests = new ArrayList<File>();
        if (this.test == null || this.test.isEmpty()) {
            tests.addAll(MojoUtils.getEunitTestSet(p.modules(true, false), p.testSupportArtifacts()));
        } else {
            File test = new File(p.targetLayout().testEbin(), this.test + ".beam");
            if (test.isFile()) {
                tests.add(test);
            }
        }
        if (tests.isEmpty()) {
            log.info((CharSequence)"No tests to profile.");
            return;
        }
        File profilingReportsDir = p.targetLayout().profilingReports();
        String profilingReportName = p.project().getArtifactId();
        FileUtils.ensureDirectories(profilingReportsDir);
        ProfilingScript script = new ProfilingScript(tests, profilingReportsDir, profilingReportName, this.timeout);
        log.info((CharSequence)"Running profiling tests...");
        ProfilingResult result = MavenSelf.get(p.cookie()).exec(p.testNode(), script);
        if (!result.testsPassed()) {
            result.logOutput(log);
            throw new MojoFailureException("There were test failures.");
        }
        if (this.silent) {
            log.info((CharSequence)"Successfully generated profiling.");
            return;
        }
        List<File> reports = FileUtils.getFilesRecursive(profilingReportsDir, ".txt");
        if (reports.isEmpty()) {
            throw new MojoExecutionException("No profiling report files found at: " + profilingReportsDir);
        }
        ProfilingResult.Report report = new ProfilingResult.Report(reports.get(0), p);
        this.printProfiling(report, log);
        log.info((CharSequence)"Successfully generated profiling.");
    }

    private void printProfiling(ProfilingResult.Report report, Log log) {
        int maxItems = this.details ? report.getRows().size() : 10;
        Iterator<ProfilingResult.Report.Row> rows = report.getRows().iterator();
        log.info((CharSequence)(MavenUtils.SEPARATOR + "--------------------"));
        log.info((CharSequence)"FUNCTIONS                                                             CALLS   TIME  uS/CALLS");
        log.info((CharSequence)(MavenUtils.FAT_SEPARATOR + "===================="));
        for (int i = maxItems; i > 0 && rows.hasNext(); --i) {
            ProfilingResult.Report.Row row = rows.next();
            log.info((CharSequence)String.format("%1$-68s %2$6d %3$6d %4$9.2f", row.name, row.calls, row.time, Float.valueOf(row.microSecondsPerCall)));
        }
        log.info((CharSequence)(MavenUtils.SEPARATOR + "--------------------"));
    }
}

