/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.mojo.app;

import eu.lindenbaum.maven.ErlangMojo;
import eu.lindenbaum.maven.Properties;
import eu.lindenbaum.maven.archiver.TarGzArchiver;
import eu.lindenbaum.maven.erlang.CheckAppResult;
import eu.lindenbaum.maven.erlang.CheckAppScript;
import eu.lindenbaum.maven.erlang.CheckAppUpScript;
import eu.lindenbaum.maven.erlang.GetAttributesScript;
import eu.lindenbaum.maven.erlang.MavenSelf;
import eu.lindenbaum.maven.util.ErlUtils;
import eu.lindenbaum.maven.util.FileUtils;
import eu.lindenbaum.maven.util.MavenUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public final class Packager
extends ErlangMojo {
    @Override
    protected void execute(Log log, Properties p) throws MojoExecutionException, MojoFailureException {
        File appFile;
        log.info((CharSequence)MavenUtils.SEPARATOR);
        log.info((CharSequence)" P A C K A G E R");
        log.info((CharSequence)MavenUtils.SEPARATOR);
        String projectVersion = p.project().getVersion();
        List<File> modules = p.modules(false, false);
        Set<Artifact> dependencies = MavenUtils.getErlangDependenciesToPackage(p.project());
        GetAttributesScript registeredScript = new GetAttributesScript(modules, "registered");
        String registeredNames = MavenSelf.get(p.cookie()).exec(p.node(), registeredScript);
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("${ARTIFACT}", "'" + p.project().getArtifactId() + "'");
        replacements.put("${DESCRIPTION}", "\"" + p.project().getDescription() + "\"");
        replacements.put("${ID}", "\"" + p.project().getId() + "\"");
        replacements.put("${VERSION}", "\"" + projectVersion + "\"");
        replacements.put("${MODULES}", ErlUtils.toModuleList(modules, "'", "'"));
        replacements.put("${REGISTERED}", registeredNames);
        replacements.put("${APPLICATIONS}", ErlUtils.toArtifactIdListing(dependencies));
        File ebin = p.sourceLayout().ebin();
        File targetEbin = p.targetLayout().ebin();
        FileUtils.ensureDirectories(ebin);
        Collection<File> copied = FileUtils.copyDirectory(ebin, targetEbin, FileUtils.APP_FILTER, replacements);
        if (copied.size() > 0) {
            log.debug((CharSequence)"Copied application resource files:");
            MavenUtils.logCollection(log, MavenUtils.LogLevel.DEBUG, copied, " * ");
        }
        if (!(appFile = p.targetLayout().appFile()).exists()) {
            log.error((CharSequence)"Errors:");
            log.error((CharSequence)" * no application resource file found, use 'mvn erlang:setup' to create");
            log.error((CharSequence)"   a default library application .app file");
            throw new MojoFailureException(p.sourceLayout().appFile() + " does not exist.");
        }
        CheckAppScript appScript = new CheckAppScript(appFile);
        CheckAppResult appResult = MavenSelf.get(p.cookie()).exec(p.node(), appScript);
        if (!appResult.success()) {
            log.error((CharSequence)"Errors:");
            log.error((CharSequence)" * failed to consult application resource file");
            MavenUtils.logContent(log, MavenUtils.LogLevel.ERROR, appFile, "   ");
            throw new MojoFailureException("Failed to consult " + appFile + ".");
        }
        Packager.checkApplicationName(log, appFile, p.project().getArtifactId(), appResult.getName());
        Packager.checkApplicationVersion(log, appFile, projectVersion, appResult.getVersion());
        Packager.checkModules(log, modules, appResult.getModules());
        Packager.checkApplications(log, dependencies, appResult.getApplications());
        Packager.checkStartModule(log, p, appResult);
        File appUpFile = p.targetLayout().appupFile();
        if (!appUpFile.exists()) {
            log.warn((CharSequence)"Warnings:");
            log.warn((CharSequence)" * no application upgrade file found, use 'mvn erlang:appup' or");
            log.warn((CharSequence)"   'mvn erlang:setup' to create a template .appup file, you must edit");
            log.warn((CharSequence)"   your .appup file according to http://www.erlang.org/doc/man/appup.html");
        } else {
            CheckAppUpScript appUpScript = new CheckAppUpScript(appUpFile, projectVersion);
            String error = MavenSelf.get(p.cookie()).exec(p.node(), appUpScript);
            if (error != null) {
                log.error((CharSequence)"Errors:");
                log.error((CharSequence)" * failed to verify application upgrade file, you must edit your .appup ");
                log.error((CharSequence)"   file according to http://www.erlang.org/doc/man/appup.html");
                MavenUtils.logMultiLineString(log, MavenUtils.LogLevel.ERROR, error, "   ");
                MavenUtils.logContent(log, MavenUtils.LogLevel.ERROR, appUpFile, "   ");
                throw new MojoFailureException("Failed to verify " + appUpFile + ".");
            }
        }
        File toFile = p.targetLayout().projectArtifact();
        try {
            TarGzArchiver archiver = new TarGzArchiver(p.node(), p.cookie(), toFile);
            archiver.addFile(p.targetLayout().project());
            archiver.createArchive();
            p.project().getArtifact().setFile(toFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        log.info((CharSequence)"Successfully packaged application:");
        log.info((CharSequence)toFile.toString());
    }

    private static void checkApplicationName(Log log, File appFile, String expected, String actual) throws MojoFailureException {
        if (!expected.equals(actual)) {
            log.error((CharSequence)"Errors:");
            log.error((CharSequence)(" * application name mismatch, project name is '" + expected + "'"));
            log.error((CharSequence)("   while .app application name is '" + actual + "'"));
            MavenUtils.logContent(log, MavenUtils.LogLevel.ERROR, appFile, "   ");
            throw new MojoFailureException("Name mismatch '" + expected + "' != '" + actual + "'.");
        }
    }

    private static void checkApplicationVersion(Log log, File appFile, String expected, String actual) throws MojoFailureException {
        if (!expected.equals(actual)) {
            log.error((CharSequence)"Errors:");
            log.error((CharSequence)(" * application version mismatch, project version is '" + expected + "'"));
            log.error((CharSequence)("   while .app application version is '" + actual + "'"));
            MavenUtils.logContent(log, MavenUtils.LogLevel.ERROR, appFile, "   ");
            throw new MojoFailureException("Version mismatch '" + expected + "' != '" + actual + "'.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void checkStartModule(Log log, Properties p, CheckAppResult r) throws MojoExecutionException, MojoFailureException {
        String startModule = r.getStartModule();
        if ("omitted".equals(startModule)) return;
        File beamFile = new File(p.targetLayout().ebin(), startModule + ".beam");
        if (beamFile.isFile()) {
            List<File> list = Arrays.asList(beamFile);
            GetAttributesScript behaviourScript = new GetAttributesScript(list, "behaviour", "behavior");
            String behaviours = MavenSelf.get(p.cookie()).exec(p.node(), behaviourScript);
            if (behaviours.contains("application")) {
                if (r.getApplications().contains("sasl")) return;
                log.error((CharSequence)"Errors:");
                log.error((CharSequence)" * application dependency to 'sasl' is missing in .app file");
                throw new MojoFailureException("Dependency to 'sasl' is missing.");
            }
            log.error((CharSequence)"Errors:");
            log.error((CharSequence)(" * configured start module '" + startModule + "' does not implement"));
            log.error((CharSequence)"   the application behaviour");
            throw new MojoFailureException("Configured start module does not implement the application behaviour.");
        }
        log.error((CharSequence)"Errors:");
        log.error((CharSequence)(" * configured start module '" + startModule + "' does not exist"));
        throw new MojoFailureException("Configured start module does not exist.");
    }

    private static void checkModules(Log log, Collection<File> expected, List<String> actual) throws MojoFailureException {
        HashSet<String> m = new HashSet<String>();
        for (File module : expected) {
            m.add(module.getName().replace(".beam", "").replace(".erl", ""));
        }
        if (!m.containsAll(actual) || !actual.containsAll(m)) {
            log.error((CharSequence)"Errors:");
            HashSet undeclared = new HashSet(m);
            undeclared.removeAll(actual);
            if (undeclared.size() > 0) {
                log.error((CharSequence)" * found undeclared modules (beam file present but not listed in .app file)");
                MavenUtils.logCollection(log, MavenUtils.LogLevel.ERROR, undeclared, "    - ");
            }
            HashSet<String> unbacked = new HashSet<String>(actual);
            unbacked.removeAll(m);
            if (unbacked.size() > 0) {
                log.error((CharSequence)" * found unbacked modules (listed in .app file but no beam file present)");
                MavenUtils.logCollection(log, MavenUtils.LogLevel.ERROR, unbacked, "    - ");
            }
            throw new MojoFailureException("Module mismatch found, see previous output for details.");
        }
    }

    private static void checkApplications(Log log, Collection<Artifact> expected, List<String> actual) throws MojoFailureException {
        boolean missingDependencies = false;
        ArrayList<String> errorLines = new ArrayList<String>();
        for (Artifact artifact : expected) {
            String artifactId = artifact.getArtifactId();
            if (actual.contains(artifactId)) continue;
            errorLines.add(" * application dependency to '" + artifactId + "' is missing");
            errorLines.add("   in .app file");
            missingDependencies = true;
        }
        if (!actual.containsAll(Arrays.asList("kernel", "stdlib"))) {
            errorLines.add(" * vital application dependency to either 'kernel' or 'stdlib' is");
            errorLines.add("   missing in .app file");
            missingDependencies = true;
        }
        if (missingDependencies) {
            log.error((CharSequence)"Errors:");
            MavenUtils.logCollection(log, MavenUtils.LogLevel.ERROR, errorLines, "");
            throw new MojoFailureException("Missing application dependencies, see previous output for details.");
        }
    }
}

