/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.mojo.app;

import eu.lindenbaum.maven.ErlangMojo;
import eu.lindenbaum.maven.Properties;
import eu.lindenbaum.maven.erlang.CoverageReportResult;
import eu.lindenbaum.maven.erlang.CoverageReportScript;
import eu.lindenbaum.maven.erlang.MavenSelf;
import eu.lindenbaum.maven.util.FileUtils;
import eu.lindenbaum.maven.util.MavenUtils;
import eu.lindenbaum.maven.util.MojoUtils;
import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class Coverage
extends ErlangMojo {
    private boolean silent;
    private boolean details;

    @Override
    protected void execute(Log log, Properties p) throws MojoExecutionException {
        log.info((CharSequence)MavenUtils.SEPARATOR);
        log.info((CharSequence)" C O V E R A G E");
        log.info((CharSequence)MavenUtils.SEPARATOR);
        List<File> tests = MojoUtils.getEunitTestSet(p.modules(true, false), p.testSupportArtifacts());
        if (tests.isEmpty()) {
            log.info((CharSequence)"Nothing to do.");
            return;
        }
        File src = p.sourceLayout().src();
        List<File> sources = FileUtils.getFilesRecursive(src, ".erl");
        File testEbin = p.targetLayout().testEbin();
        File coverageReportDir = p.targetLayout().coverageReports();
        FileUtils.ensureDirectories(coverageReportDir);
        String coverageReportName = p.project().getArtifactId();
        CoverageReportScript script = new CoverageReportScript(testEbin, tests, sources, coverageReportDir, coverageReportName);
        log.info((CharSequence)"Running coverage tests...");
        CoverageReportResult result = MavenSelf.get(p.cookie()).exec(p.testNode(), script);
        if (result.failed()) {
            result.logOutput(this.getLog());
            throw new MojoExecutionException("failed to generate coverage report");
        }
        if (this.silent) {
            log.info((CharSequence)"Successfully generated coverage.");
            return;
        }
        List<File> reports = FileUtils.getFilesRecursive(coverageReportDir, ".txt");
        if (reports.isEmpty()) {
            throw new MojoExecutionException("No coverage report files found at: " + coverageReportDir);
        }
        CoverageReportResult.Report report = new CoverageReportResult.Report(reports.get(0));
        if (this.details) {
            this.printModulesSummary(this.getLog(), report);
        }
        this.printReportSummary(this.getLog(), report);
        log.info((CharSequence)"Successfully generated coverage.");
    }

    private void printModulesSummary(Log log, CoverageReportResult.Report report) {
        log.info((CharSequence)"MODULES");
        log.info((CharSequence)MavenUtils.FAT_SEPARATOR);
        for (CoverageReportResult.Report.Module module : report.getModules()) {
            String name = module.getName() + ".erl";
            int padding = 69 - name.length();
            String covered = module.getCoverage() == 100 ? "COVERED" : "NOT COVERED!";
            log.info((CharSequence)String.format("> %1$s %2$" + padding + "s", name, covered));
            log.info((CharSequence)MavenUtils.SEPARATOR);
            log.info((CharSequence)String.format("Coverage: %1$23d%% | Lines: %2$28d", module.getCoverage(), module.getNumberOfLines()));
            log.info((CharSequence)String.format("Functions: %1$23d | Covered lines: %2$20d", module.getNumberOfFunctions(), module.getNumberOfCoveredLines()));
            log.info((CharSequence)String.format("Clauses: %1$25d | Not covered lines: %2$16d", module.getNumberOfClauses(), module.getNumberOfNotCoveredLines()));
            log.info((CharSequence)MavenUtils.SEPARATOR);
        }
        log.info((CharSequence)"");
    }

    private void printReportSummary(Log log, CoverageReportResult.Report report) {
        log.info((CharSequence)"SUMMARY");
        log.info((CharSequence)MavenUtils.FAT_SEPARATOR);
        log.info((CharSequence)String.format("Total coverage:%1$56d%%", report.getCoverage()));
        log.info((CharSequence)MavenUtils.SEPARATOR);
        log.info((CharSequence)String.format("Modules:%1$26d | Lines:%2$29d", report.getNumberOfModules(), report.getNumberOfLines()));
        log.info((CharSequence)String.format("Functions:%1$24d | Covered lines:%2$21d", report.getNumberOfFunctions(), report.getNumberOfCoveredLines()));
        log.info((CharSequence)String.format("Clauses:%1$26d | Not covered lines:%2$17d", report.getNumberOfClauses(), report.getNumberOfNotCoveredLines()));
        log.info((CharSequence)MavenUtils.SEPARATOR);
    }
}

