/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.mojo.app;

import eu.lindenbaum.maven.ErlangMojo;
import eu.lindenbaum.maven.Properties;
import eu.lindenbaum.maven.erlang.BeamCompilerScript;
import eu.lindenbaum.maven.erlang.CompilerResult;
import eu.lindenbaum.maven.erlang.MavenSelf;
import eu.lindenbaum.maven.util.FileUtils;
import eu.lindenbaum.maven.util.MavenUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public final class Compiler
extends ErlangMojo {
    private String compilerOptions;
    private String[] compileFirst;

    @Override
    protected void execute(Log log, Properties p) throws MojoExecutionException, MojoFailureException {
        log.info((CharSequence)MavenUtils.SEPARATOR);
        log.info((CharSequence)" C O M P I L E R");
        log.info((CharSequence)MavenUtils.SEPARATOR);
        File ebin = p.targetLayout().ebin();
        FileUtils.ensureDirectories(ebin);
        List<File> files = FileUtils.getFilesRecursive(p.sourceLayout().src(), ".erl");
        ArrayList<File> firstFiles = new ArrayList<File>();
        if (this.compileFirst != null) {
            for (String compileFirstFile : this.compileFirst) {
                File file = FileUtils.getFile(compileFirstFile, files);
                firstFiles.add(file);
                files.remove(file);
            }
        }
        if (!files.isEmpty() || !firstFiles.isEmpty()) {
            ArrayList<String> options = new ArrayList<String>();
            if (this.compilerOptions != null && !this.compilerOptions.isEmpty()) {
                log.info((CharSequence)("Using additional compiler options: " + this.compilerOptions));
                options.add(this.compilerOptions);
            }
            List<File> includes = p.includePaths(false);
            BeamCompilerScript script = new BeamCompilerScript(files, firstFiles, ebin, includes, options);
            CompilerResult result = MavenSelf.get(p.cookie()).exec(p.node(), script);
            List<File> compiled = result.getCompiled();
            List<File> failed = result.getFailed();
            List<String> errors = result.getErrors();
            List<String> warnings = result.getWarnings();
            if (compiled.size() > 0) {
                log.info((CharSequence)"Compiled:");
                MavenUtils.logCollection(log, MavenUtils.LogLevel.INFO, compiled, " * ");
            }
            if (errors.size() > 0) {
                log.error((CharSequence)"Errors:");
                MavenUtils.logCollection(log, MavenUtils.LogLevel.ERROR, errors, "");
            }
            if (warnings.size() > 0) {
                log.warn((CharSequence)"Warnings:");
                MavenUtils.logCollection(log, MavenUtils.LogLevel.WARN, warnings, "");
            }
            if (failed.size() > 0) {
                throw new MojoFailureException("Failed to compile " + failed + ".");
            }
            log.info((CharSequence)"Successfully compiled the project sources.");
        } else {
            log.info((CharSequence)"No source files to compile.");
        }
    }
}

