/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.mojo;

import eu.lindenbaum.maven.ErlangMojo;
import eu.lindenbaum.maven.Properties;
import eu.lindenbaum.maven.erlang.DialyzerScript;
import eu.lindenbaum.maven.erlang.MavenSelf;
import eu.lindenbaum.maven.util.FileUtils;
import eu.lindenbaum.maven.util.MavenUtils;
import eu.lindenbaum.maven.util.MojoUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public final class Dialyzer
extends ErlangMojo {
    private boolean skipDialyzer;
    private boolean dialyzerWithDependencies;
    private boolean dialyzerWarningsAreErrors;
    private String dialyzerOptions;

    @Override
    protected void execute(Log log, Properties p) throws MojoExecutionException, MojoFailureException {
        log.info((CharSequence)MavenUtils.SEPARATOR);
        log.info((CharSequence)" D I A L Y Z E R");
        log.info((CharSequence)MavenUtils.SEPARATOR);
        if (this.skipDialyzer) {
            log.warn((CharSequence)"Dialyzer is configured to be skipped.");
            return;
        }
        File lastBuildIndicator = p.targetLayout().dialyzerOk();
        ArrayList<File> directories = new ArrayList<File>();
        Dialyzer.maybeAddDirectory(p.sourceLayout().src(), directories);
        Dialyzer.maybeAddDirectory(p.sourceLayout().include(), directories);
        if (this.dialyzerWithDependencies) {
            Dialyzer.maybeAddDirectory(p.targetLayout().lib(), directories);
        }
        if (MojoUtils.newerFilesThan(lastBuildIndicator, directories)) {
            FileUtils.removeFiles(lastBuildIndicator);
            List<File> filesToDialyze = FileUtils.getFilesRecursive(directories, ".erl");
            if (filesToDialyze.isEmpty()) {
                log.info((CharSequence)"Nothing to to.");
                return;
            }
            DialyzerScript script = new DialyzerScript(directories, p.includePaths(false), this.dialyzerOptions);
            String[] output = MavenSelf.get(p.cookie()).exec(p.node(), script);
            Collection<String> warnings = MojoUtils.parseDialyzerOutput(output, filesToDialyze);
            if (warnings.size() > 0) {
                log.warn((CharSequence)"Warnings:");
                MavenUtils.logCollection(log, MavenUtils.LogLevel.WARN, warnings, "");
                if (this.dialyzerWarningsAreErrors) {
                    throw new MojoFailureException("Dialyzer reported warnings.");
                }
            } else {
                log.info((CharSequence)"Dialyzer run successful.");
                FileUtils.touch(lastBuildIndicator);
            }
        } else {
            log.info((CharSequence)"Last dialyzer run is still up to date.");
        }
    }

    private static void maybeAddDirectory(File toAdd, List<File> toAddTo) {
        if (toAdd != null && toAdd.isDirectory()) {
            toAddTo.add(toAdd);
        }
    }
}

