/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.mojo;

import eu.lindenbaum.maven.ErlangMojo;
import eu.lindenbaum.maven.PackagingType;
import eu.lindenbaum.maven.Properties;
import eu.lindenbaum.maven.archiver.TarGzUnarchiver;
import eu.lindenbaum.maven.util.CollectionUtils;
import eu.lindenbaum.maven.util.FileUtils;
import eu.lindenbaum.maven.util.MavenUtils;
import eu.lindenbaum.maven.util.Predicate;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public final class DependencyExtractor
extends ErlangMojo {
    @Override
    protected void execute(Log log, Properties p) throws MojoExecutionException {
        File lib = p.targetLayout().lib();
        FileUtils.ensureDirectories(lib);
        TarGzUnarchiver unarchiver = new TarGzUnarchiver(p.node(), p.cookie(), lib);
        Collection<Artifact> artifacts = MavenUtils.getErlangArtifacts(p.project());
        if (p.packagingType() == PackagingType.ERLANG_REL) {
            artifacts = DependencyExtractor.filterTestScopeDependencies(artifacts);
        }
        if (artifacts.size() > 0) {
            log.info((CharSequence)"Processed project dependencies:");
            for (Artifact artifact : artifacts) {
                DependencyExtractor.extractArtifact(log, artifact, unarchiver);
            }
        }
        DependencyExtractor.cleanupArtifacts(log, lib, artifacts);
    }

    private static void extractArtifact(Log log, Artifact artifact, TarGzUnarchiver unarchiver) throws MojoExecutionException {
        File artifactFile = artifact.getFile();
        String artifactdirectory = MavenUtils.getArtifactDirectory(artifact);
        File cachedDependency = new File(unarchiver.getDestination(), artifactdirectory);
        if (!cachedDependency.isDirectory() || artifactFile.lastModified() > cachedDependency.lastModified()) {
            if (cachedDependency.isDirectory()) {
                FileUtils.removeDirectory(cachedDependency);
            }
            try {
                log.info((CharSequence)(" * " + artifactdirectory + " (extracted)"));
                unarchiver.extract(artifact.getFile());
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        } else {
            log.info((CharSequence)(" * " + artifact.getArtifactId() + "-" + artifact.getVersion() + " (skipped)"));
        }
    }

    private static void cleanupArtifacts(Log log, File targetLib, Collection<Artifact> artifacts) {
        ArrayList<String> excludes = new ArrayList<String>();
        for (Artifact artifact : artifacts) {
            excludes.add(MavenUtils.getArtifactDirectory(artifact));
        }
        List<File> obsoleteDependencies = FileUtils.getDirectories(targetLib, excludes);
        if (obsoleteDependencies.size() > 0) {
            log.debug((CharSequence)"Removed obsolete dependencies:");
            for (File obsoleteDependency : obsoleteDependencies) {
                log.debug((CharSequence)(" * " + obsoleteDependency.getName()));
                FileUtils.removeDirectory(obsoleteDependency);
            }
        }
    }

    private static Collection<Artifact> filterTestScopeDependencies(Collection<Artifact> artifacts) {
        return CollectionUtils.filter(new Predicate<Artifact>(){

            @Override
            public boolean pred(Artifact artifact) {
                return !"test".equals(artifact.getScope());
            }
        }, artifacts);
    }
}

