/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.erlang;

import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangTuple;
import eu.lindenbaum.maven.erlang.AbstractScript;
import eu.lindenbaum.maven.erlang.GenericScriptResult;
import eu.lindenbaum.maven.util.ErlUtils;
import eu.lindenbaum.maven.util.MavenUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class UploadScript
extends AbstractScript<GenericScriptResult> {
    private final String remoteNode;
    private final List<File> beamFiles;
    private final List<File> appFiles;
    private final List<File> resourceFiles;

    public UploadScript(String remoteNode, List<File> beamFiles, List<File> appFiles, List<File> resourceFiles) throws MojoExecutionException {
        this.remoteNode = remoteNode;
        this.beamFiles = beamFiles;
        this.appFiles = appFiles;
        this.resourceFiles = resourceFiles;
    }

    @Override
    public String get() {
        String beamFileList = ErlUtils.toFilenameList(this.beamFiles, "\"", "\"");
        String appFileList = ErlUtils.toFilenameList(this.appFiles, "\"", "\"");
        String resourceList = ErlUtils.toFilenameList(this.resourceFiles, "\"", "\"");
        return String.format(this.script, this.remoteNode, beamFileList, appFileList, resourceList);
    }

    @Override
    public GenericScriptResult handle(OtpErlangObject result) {
        OtpErlangTuple resultTuple = (OtpErlangTuple)result;
        OtpErlangList succeeded = (OtpErlangList)resultTuple.elementAt(0);
        OtpErlangList failed = (OtpErlangList)resultTuple.elementAt(1);
        final boolean success = failed.arity() == 0;
        final String node = this.remoteNode;
        final ArrayList<File> successFullyUploaded = new ArrayList<File>();
        Iterator succeededIterator = succeeded.iterator();
        while (succeededIterator.hasNext()) {
            successFullyUploaded.add(new File(ErlUtils.toString((OtpErlangObject)succeededIterator.next())));
        }
        final ArrayList<File> failedToUpload = new ArrayList<File>();
        Iterator failedIterator = failed.iterator();
        while (failedIterator.hasNext()) {
            failedToUpload.add(new File(ErlUtils.toString((OtpErlangObject)failedIterator.next())));
        }
        return new GenericScriptResult(){

            @Override
            public boolean success() {
                return success;
            }

            @Override
            public void logOutput(Log log) {
                if (!successFullyUploaded.isEmpty()) {
                    log.info((CharSequence)("Files uploaded successfully to " + node + ":"));
                    MavenUtils.logCollection(log, MavenUtils.LogLevel.INFO, successFullyUploaded, " * ");
                    log.info((CharSequence)"");
                }
                if (!failedToUpload.isEmpty()) {
                    log.error((CharSequence)("Files that could not be uploaded to " + node + ":"));
                    MavenUtils.logCollection(log, MavenUtils.LogLevel.ERROR, failedToUpload, " * ");
                }
            }
        };
    }
}

