/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.erlang;

import eu.lindenbaum.maven.Properties;
import eu.lindenbaum.maven.util.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public interface ProfilingResult {
    public void logOutput(Log var1);

    public boolean testsPassed();

    public static class Report {
        private volatile Pattern modulesPattern;
        private volatile List<Row> rows = new ArrayList<Row>();

        public Report(File reportFile, Properties p) throws MojoExecutionException {
            this.makeModulesPattern(p);
            this.parseProfilingReportFile(reportFile);
            Collections.sort(this.rows, new Comparator<Row>(){

                @Override
                public int compare(Row that, Row other) {
                    return Double.compare(that.microSecondsPerCall, other.microSecondsPerCall);
                }
            });
            Collections.reverse(this.rows);
        }

        void makeModulesPattern(Properties p) {
            File src = p.sourceLayout().src();
            List<File> modules = FileUtils.getFilesRecursive(src, ".erl");
            StringBuilder patternString = new StringBuilder();
            boolean afterFirst = false;
            patternString.append("^(");
            for (File file : modules) {
                if (afterFirst) {
                    patternString.append("|");
                }
                String moduleName = file.getName().replace(".erl", "");
                patternString.append(moduleName);
                afterFirst = true;
            }
            patternString.append("):.*$");
            this.modulesPattern = Pattern.compile(patternString.toString());
        }

        void parseProfilingReportFile(File report) throws MojoExecutionException {
            BufferedReader reader = null;
            FileReader file = null;
            try {
                String line;
                file = new FileReader(report);
                reader = new BufferedReader(file);
                while ((line = reader.readLine()) != null) {
                    Matcher matcher = this.modulesPattern.matcher(line);
                    if (!matcher.matches()) continue;
                    this.parseProfilingReportLine(line);
                }
            }
            catch (FileNotFoundException e) {
                throw new MojoExecutionException("Unable to parse profiling file.", (Exception)e);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to read profiling file.", (Exception)e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {}
                }
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (IOException e) {}
                }
            }
        }

        void parseProfilingReportLine(String line) {
            StringTokenizer tokenizer = new StringTokenizer(line);
            String moduleFunctionArity = tokenizer.nextToken();
            int calls = Integer.parseInt(tokenizer.nextToken());
            tokenizer.nextToken();
            int time = Integer.parseInt(tokenizer.nextToken());
            tokenizer.nextToken();
            float microSecondsPerCall = Float.parseFloat(tokenizer.nextToken().replace("]", ""));
            this.rows.add(new Row(moduleFunctionArity, calls, time, microSecondsPerCall));
        }

        public int getNumberOfRows() {
            return this.rows.size();
        }

        public Collection<Row> getRows() {
            return this.rows;
        }

        public static class Row {
            public final String name;
            public final int calls;
            public final int time;
            public final float microSecondsPerCall;

            public Row(String name, int calls, int time, float microsecondsPerCall) {
                this.name = name;
                this.calls = calls;
                this.time = time;
                this.microSecondsPerCall = microsecondsPerCall;
            }
        }
    }
}

