/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.erlang;

import com.ericsson.otp.erlang.OtpAuthException;
import com.ericsson.otp.erlang.OtpConnection;
import com.ericsson.otp.erlang.OtpErlangExit;
import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangString;
import com.ericsson.otp.erlang.OtpErlangTuple;
import com.ericsson.otp.erlang.OtpPeer;
import com.ericsson.otp.erlang.OtpSelf;
import eu.lindenbaum.maven.erlang.Script;
import eu.lindenbaum.maven.util.ErlUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;

public final class MavenSelf {
    private static final int MAX_RETRIES = 10;
    private static final String execScript = Script.NL + "code:add_pathsa(%s)," + Script.NL + "%s";
    private static final Map<String, MavenSelf> instances = new HashMap<String, MavenSelf>();
    private final OtpSelf self;
    private final Map<String, OtpConnection> connections;

    private MavenSelf(OtpSelf self) {
        this.self = self;
        this.connections = new HashMap<String, OtpConnection>();
    }

    public static MavenSelf get(String cookie) throws MojoExecutionException {
        String c = cookie != null ? cookie : "";
        MavenSelf self = instances.get(c);
        if (self == null) {
            try {
                String name = "maven-erlang-plugin-frontend-" + System.nanoTime();
                OtpSelf otpSelf = c.isEmpty() ? new OtpSelf(name) : new OtpSelf(name, c);
                self = new MavenSelf(otpSelf);
                instances.put(c, self);
            }
            catch (IOException e) {
                throw new MojoExecutionException("failed to create self node for cookie '" + c + "'", (Exception)e);
            }
        }
        return self;
    }

    public OtpConnection connect(String peer) throws MojoExecutionException {
        OtpConnection connection = this.connections.get(peer);
        if (connection == null) {
            String msg = null;
            try {
                for (int i = 0; i < 10; ++i) {
                    try {
                        connection = this.self.connect(new OtpPeer(peer));
                        this.connections.put(peer, connection);
                        break;
                    }
                    catch (IOException e) {
                        msg = e.getMessage();
                        Thread.sleep(500L);
                        continue;
                    }
                }
            }
            catch (OtpAuthException e) {
                msg = e.getMessage();
                throw new MojoExecutionException("failed to connect to " + peer + ": " + msg);
            }
            catch (InterruptedException e) {
                msg = e.getMessage();
                throw new MojoExecutionException("failed to connect to " + peer + ": " + msg);
            }
            if (connection == null) {
                msg = " after 10 retries: " + msg;
                throw new MojoExecutionException("failed to connect to " + peer + msg);
            }
        }
        return connection;
    }

    public <T> T exec(String peer, Script<T> script) throws MojoExecutionException {
        return script.handle(this.eval(peer, script.get()));
    }

    public <T> T exec(String peer, Script<T> script, List<File> codePaths) throws MojoExecutionException {
        String toExec = String.format(execScript, ErlUtils.toFilenameList(codePaths, "\"", "\""), script.get());
        return script.handle(this.eval(peer, toExec));
    }

    private void removeConnection(String peer) {
        this.connections.remove(peer);
    }

    private OtpErlangObject eval(String peer, String expression) throws MojoExecutionException {
        OtpConnection connection = this.connect(peer);
        try {
            connection.sendRPC("erl_eval", "new_bindings", new OtpErlangList());
            OtpErlangObject bindings = connection.receiveRPC();
            connection.sendRPC("erl_scan", "string", new OtpErlangList((OtpErlangObject)new OtpErlangString(expression)));
            OtpErlangTuple result = (OtpErlangTuple)connection.receiveRPC();
            OtpErlangObject indicator = result.elementAt(0);
            if ("ok".equals(indicator.toString())) {
                connection.sendRPC("erl_parse", "parse_exprs", new OtpErlangList(result.elementAt(1)));
                result = (OtpErlangTuple)connection.receiveRPC();
                indicator = result.elementAt(0);
                if ("ok".equals(indicator.toString())) {
                    OtpErlangList forms = (OtpErlangList)result.elementAt(1);
                    if (forms.arity() > 0) {
                        connection.sendRPC("erl_eval", "exprs", new OtpErlangObject[]{forms, bindings});
                        result = (OtpErlangTuple)connection.receiveRPC();
                        indicator = result.elementAt(0);
                        if ("value".equals(indicator.toString())) {
                            return result.elementAt(1);
                        }
                        OtpErlangObject errorInfo = result.elementAt(1);
                        String msg = "in script: " + expression + "failed to evaluate form: " + errorInfo.toString();
                        throw new MojoExecutionException(msg);
                    }
                    String msg = "in script: " + expression + "couldn't find forms to evaluate in expression";
                    throw new MojoExecutionException(msg);
                }
                OtpErlangObject errorInfo = result.elementAt(1);
                String msg = "in script: " + expression + "failed to parse tokens: " + errorInfo.toString();
                throw new MojoExecutionException(msg);
            }
            OtpErlangObject errorInfo = result.elementAt(1);
            String msg = "in script: " + expression + "failed to scan expression: " + errorInfo.toString();
            throw new MojoExecutionException(msg);
        }
        catch (IOException e) {
            this.removeConnection(peer);
            String msg = "in script: " + expression + "failure: " + e.getMessage();
            throw new MojoExecutionException(msg, (Exception)e);
        }
        catch (OtpErlangExit e) {
            this.removeConnection(peer);
            String msg = "in script: " + expression + "failure: " + e.getMessage();
            throw new MojoExecutionException(msg, (Exception)((Object)e));
        }
        catch (OtpAuthException e) {
            this.removeConnection(peer);
            String msg = "in script: " + expression + "failure: " + e.getMessage();
            throw new MojoExecutionException(msg, (Exception)((Object)e));
        }
    }
}

