/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.erlang;

import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangTuple;
import eu.lindenbaum.maven.erlang.AbstractScript;
import eu.lindenbaum.maven.erlang.CoverageReportResult;
import eu.lindenbaum.maven.util.ErlUtils;
import eu.lindenbaum.maven.util.MavenUtils;
import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class CoverageReportScript
extends AbstractScript<CoverageReportResult> {
    private final List<File> tests;
    private final File testDir;
    private final List<File> sources;
    private final File coverageReportDir;
    private final String coverageReportName;

    public CoverageReportScript(File testDir, List<File> tests, List<File> sources, File coverageReportDir, String coverageReportName) throws MojoExecutionException {
        this.testDir = testDir;
        this.tests = tests;
        this.sources = sources;
        this.coverageReportDir = coverageReportDir;
        this.coverageReportName = coverageReportName;
    }

    @Override
    public String get() {
        String testPath = this.testDir.getAbsolutePath();
        String testModuleList = ErlUtils.toModuleList(this.tests, "'", "'");
        String sourceModuleList = ErlUtils.toModuleList(this.sources, "'", "'");
        return String.format(this.script, testPath, testModuleList, sourceModuleList, this.coverageReportDir, this.coverageReportName);
    }

    @Override
    public CoverageReportResult handle(OtpErlangObject output) {
        OtpErlangTuple resultTuple = (OtpErlangTuple)output;
        final String result = ErlUtils.toString(resultTuple.elementAt(0));
        final OtpErlangList resultList = (OtpErlangList)resultTuple.elementAt(1);
        return new CoverageReportResult(){

            @Override
            public boolean failed() {
                return "error".equals(result);
            }

            @Override
            public void logOutput(Log log) {
                if (this.failed()) {
                    for (int i = 0; i < resultList.arity(); ++i) {
                        String message = ErlUtils.toString(resultList.elementAt(i));
                        MavenUtils.logMultiLineString(log, MavenUtils.LogLevel.ERROR, message);
                    }
                }
            }
        };
    }
}

