/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.erlang;

import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangTuple;
import eu.lindenbaum.maven.erlang.AbstractScript;
import eu.lindenbaum.maven.erlang.CheckRelResult;
import eu.lindenbaum.maven.util.ErlUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;

public class CheckRelScript
extends AbstractScript<CheckRelResult> {
    private final File relFile;

    public CheckRelScript(File relFile) throws MojoExecutionException {
        this.relFile = relFile;
    }

    @Override
    public String get() {
        return String.format(this.script, this.relFile.getAbsolutePath());
    }

    @Override
    public CheckRelResult handle(OtpErlangObject result) {
        OtpErlangTuple resultTuple = (OtpErlangTuple)result;
        final OtpErlangObject success = resultTuple.elementAt(0);
        final OtpErlangObject releaseName = resultTuple.elementAt(1);
        final OtpErlangObject releaseVersion = resultTuple.elementAt(2);
        final OtpErlangObject ertsVersion = resultTuple.elementAt(3);
        OtpErlangList applicationList = (OtpErlangList)resultTuple.elementAt(4);
        final HashMap<String, String> applications = new HashMap<String, String>();
        for (int i = 0; i < applicationList.arity(); ++i) {
            OtpErlangTuple appTuple = (OtpErlangTuple)applicationList.elementAt(i);
            String application = ErlUtils.toString(appTuple.elementAt(0));
            String version = ErlUtils.toString(appTuple.elementAt(1));
            applications.put(application, version);
        }
        return new CheckRelResult(){

            @Override
            public boolean success() {
                return "ok".equals(ErlUtils.toString(success));
            }

            @Override
            public String getName() {
                return ErlUtils.toString(releaseName);
            }

            @Override
            public String getReleaseVersion() {
                return ErlUtils.toString(releaseVersion);
            }

            @Override
            public String getErtsVersion() {
                return ErlUtils.toString(ertsVersion);
            }

            @Override
            public Map<String, String> getApplications() {
                return applications;
            }

            public String toString() {
                return this.getName() + "::" + this.getReleaseVersion();
            }
        };
    }
}

