/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.archiver;

import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangTuple;
import eu.lindenbaum.maven.erlang.MavenSelf;
import eu.lindenbaum.maven.erlang.Script;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;

public final class TarGzArchiver {
    private final String peer;
    private final String cookie;
    private final File archive;
    private final Map<File, String> files = new HashMap<File, String>();

    public TarGzArchiver(String peer, String cookie, File archive) {
        this.peer = peer;
        this.cookie = cookie;
        this.archive = archive;
    }

    public File getArchive() {
        return this.archive;
    }

    public void addFile(File file) throws IOException {
        this.addFile(file, file.getName());
    }

    public void addFile(File file, String archiveName) throws IOException {
        if (!file.exists()) {
            throw new IOException("cannot add non-existing file " + file);
        }
        this.files.put(file, archiveName);
    }

    public void createArchive() throws IOException {
        if (this.files.isEmpty()) {
            throw new IOException("no files to package");
        }
        TarGzArchiverScript script = new TarGzArchiverScript(this.archive, this.files);
        try {
            String error = MavenSelf.get(this.cookie).exec(this.peer, script);
            if (error != null) {
                throw new IOException("failed to create archive: " + error);
            }
        }
        catch (MojoExecutionException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private static final class TarGzArchiverScript
    implements Script<String> {
        private static final String script = "erl_tar:create(\"%s\", %s, [compressed]).";
        private final File archive;
        private final Map<File, String> files;

        TarGzArchiverScript(File archive, Map<File, String> files) {
            this.archive = archive;
            this.files = files;
        }

        @Override
        public String get() {
            String archivePath = this.archive.getAbsolutePath();
            return String.format(script, archivePath, TarGzArchiverScript.getFiles(this.files));
        }

        @Override
        public String handle(OtpErlangObject result) {
            if (!"ok".equals(result.toString())) {
                OtpErlangTuple errorInfo = (OtpErlangTuple)result;
                OtpErlangTuple nameReason = (OtpErlangTuple)errorInfo.elementAt(1);
                return nameReason.elementAt(1).toString();
            }
            return null;
        }

        private static String getFiles(Map<File, String> files) {
            StringBuilder fileList = new StringBuilder("[");
            for (Map.Entry<File, String> file : files.entrySet()) {
                fileList.append("{\"");
                fileList.append(file.getValue());
                fileList.append("\",\"");
                fileList.append(file.getKey().getAbsolutePath());
                fileList.append("\"},");
            }
            fileList.deleteCharAt(fileList.length() - 1);
            fileList.append("]");
            return fileList.toString();
        }
    }
}

