/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven;

import eu.lindenbaum.maven.DefaultTargetLayout;
import eu.lindenbaum.maven.ErlangOtpLayout;
import eu.lindenbaum.maven.ErlangRelLayout;
import eu.lindenbaum.maven.ErlangStdLayout;
import eu.lindenbaum.maven.MavenComponents;
import eu.lindenbaum.maven.PackagingType;
import eu.lindenbaum.maven.Properties;
import eu.lindenbaum.maven.SourceLayout;
import eu.lindenbaum.maven.TargetLayout;
import eu.lindenbaum.maven.util.CollectionUtils;
import eu.lindenbaum.maven.util.FileUtils;
import eu.lindenbaum.maven.util.MavenUtils;
import eu.lindenbaum.maven.util.NetworkUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

final class PropertiesImpl
implements Properties {
    private static final String DEFAULT_BACKEND;
    private static final String DEFAULT_TEST_BACKEND;
    private final MavenProject project;
    private final MavenComponents components;
    private final PackagingType packagingType;
    private final String erlCommand;
    private final String node;
    private final String testNode;
    private final String cookie;
    private final TargetLayout targetLayout;
    private final SourceLayout sourceLayout;

    PropertiesImpl(PackagingType type, MavenProject project, MavenComponents components, String erlCommand, String cookie) {
        this.project = project;
        this.components = components;
        this.packagingType = type;
        this.erlCommand = erlCommand;
        this.node = project.getArtifactId() + "-" + DEFAULT_BACKEND;
        this.testNode = project.getArtifactId() + "-" + DEFAULT_TEST_BACKEND;
        this.cookie = cookie;
        this.targetLayout = new DefaultTargetLayout(project);
        switch (type) {
            case ERLANG_STD: {
                this.sourceLayout = new ErlangStdLayout(project);
                break;
            }
            case ERLANG_OTP: {
                this.sourceLayout = new ErlangOtpLayout(project);
                break;
            }
            default: {
                this.sourceLayout = new ErlangRelLayout(project);
            }
        }
    }

    @Override
    public MavenProject project() {
        return this.project;
    }

    @Override
    public MavenComponents components() {
        return this.components;
    }

    @Override
    public PackagingType packagingType() {
        return this.packagingType;
    }

    @Override
    public String erlCommand() {
        return this.erlCommand;
    }

    @Override
    public String node() {
        return this.node;
    }

    @Override
    public String testNode() {
        return this.testNode;
    }

    @Override
    public String cookie() {
        return this.cookie;
    }

    @Override
    public SourceLayout sourceLayout() {
        return this.sourceLayout;
    }

    @Override
    public TargetLayout targetLayout() {
        return this.targetLayout;
    }

    @Override
    public List<File> codePaths(boolean withTestCodePaths) {
        List<File> paths = FileUtils.getDirectoriesRecursive(this.targetLayout.lib(), ".beam");
        switch (this.packagingType) {
            case ERLANG_STD: 
            case ERLANG_OTP: {
                paths.add(withTestCodePaths ? this.targetLayout.testEbin() : this.targetLayout.ebin());
                break;
            }
            default: {
                paths.add(this.targetLayout.base());
            }
        }
        return paths;
    }

    @Override
    public List<File> includePaths(boolean withTestIncludePaths) {
        List<File> deps = FileUtils.getDirectoriesRecursive(this.targetLayout.lib(), ".hrl");
        HashSet<File> paths = new HashSet<File>(deps);
        if (this.packagingType != PackagingType.ERLANG_REL) {
            if (withTestIncludePaths) {
                paths.addAll(this.sourceLayout.testSrcs());
                paths.add(this.sourceLayout.testInclude());
            }
            paths.add(this.sourceLayout.src());
            paths.add(this.sourceLayout.include());
        }
        return new ArrayList<File>(paths);
    }

    @Override
    public List<File> testSupportScripts() {
        ArrayList<File> files = new ArrayList<File>();
        File testEbin = this.targetLayout.testEbin();
        files.add(new File(testEbin, "surefire.erl"));
        files.add(new File(testEbin, "cover2.erl"));
        files.add(new File(testEbin, "ttycapture.erl"));
        return files;
    }

    @Override
    public List<File> testSupportArtifacts() {
        ArrayList<File> artifacts = new ArrayList<File>();
        for (File script : this.testSupportScripts()) {
            String erl = ".erl";
            String beam = ".beam";
            artifacts.add(new File(script.getAbsolutePath().replace(erl, beam)));
        }
        return artifacts;
    }

    @Override
    public List<File> modules(boolean withTests, boolean withDependencies) {
        File ebin = withTests ? this.targetLayout.testEbin() : this.targetLayout.ebin();
        List<File> modules = FileUtils.getFilesRecursive(ebin, ".beam");
        if (withDependencies) {
            modules.addAll(this.dependencyModules(withTests));
        }
        return modules;
    }

    @Override
    public List<File> dependencyModules(boolean withTestScopeDependencies) {
        List<File> dependencies = this.getDependencyDirectories(withTestScopeDependencies);
        return FileUtils.getFilesRecursive(dependencies, ".beam");
    }

    @Override
    public List<File> applicationFiles(boolean withDependencies) {
        ArrayList<File> applicationFiles = new ArrayList<File>();
        switch (this.packagingType) {
            case ERLANG_STD: 
            case ERLANG_OTP: {
                applicationFiles.add(this.targetLayout.appFile());
                break;
            }
        }
        if (withDependencies) {
            List<File> dependencies = this.getDependencyDirectories(false);
            applicationFiles.addAll(FileUtils.getFilesRecursive(dependencies, ".app"));
        }
        return applicationFiles;
    }

    @Override
    public List<File> resources(boolean withTests, boolean withDependencies) {
        final File priv = withTests ? this.targetLayout.testPriv() : this.targetLayout.priv();
        ArrayList<File> privDirectories = new ArrayList<File>(Arrays.asList(priv));
        if (withDependencies) {
            privDirectories.addAll(CollectionUtils.map(new CollectionUtils.MapFunction<File, File>(){

                @Override
                public File apply(File a) {
                    return new File(a, priv.getName());
                }
            }, this.getDependencyDirectories(withTests)));
        }
        return FileUtils.getFilesRecursive(privDirectories, "");
    }

    private List<File> getDependencyDirectories(final boolean withTestScopeDependencies) {
        final File lib = this.targetLayout.lib();
        return CollectionUtils.foldl(new CollectionUtils.FoldFunction<Artifact, List<File>>(){

            @Override
            public List<File> apply(Artifact artifact, List<File> acc) {
                if (withTestScopeDependencies || !"test".equals(artifact.getScope())) {
                    acc.add(new File(lib, MavenUtils.getArtifactDirectory(artifact)));
                }
                return acc;
            }
        }, new ArrayList(), MavenUtils.getErlangArtifacts(this.project));
    }

    static {
        String iPv4Address = "";
        try {
            iPv4Address = "@" + NetworkUtils.getIPv4Address();
        }
        catch (MojoExecutionException e) {
            System.out.println("[WARN] " + e.getMessage());
        }
        DEFAULT_BACKEND = "maven-erlang-plugin-backend" + iPv4Address;
        DEFAULT_TEST_BACKEND = "maven-erlang-plugin-test-backend" + iPv4Address;
    }
}

