/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven;

import eu.lindenbaum.maven.DefaultMavenComponents;
import eu.lindenbaum.maven.PackagingType;
import eu.lindenbaum.maven.Properties;
import eu.lindenbaum.maven.PropertiesImpl;
import eu.lindenbaum.maven.util.MojoUtils;
import java.io.File;
import java.util.List;
import java.util.Locale;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;

public abstract class ErlangReport
extends AbstractMavenReport {
    private MavenProject project;
    private Renderer renderer;
    private ArtifactRepository localRepository;
    private List<?> remoteRepositories;
    private ArtifactMetadataSource metadataSource;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver artifactResolver;
    private String cookie;
    private String erlCommand;

    protected final MavenProject getProject() {
        return this.project;
    }

    protected final Renderer getSiteRenderer() {
        return this.renderer;
    }

    protected String getOutputDirectory() {
        return new File(this.project.getBuild().getDirectory()).getAbsolutePath();
    }

    protected final void executeReport(Locale locale) throws MavenReportException {
        Properties properties = this.getProperties();
        File backendLog = properties.targetLayout().backendLog();
        try {
            this.execute(this.getLog(), locale, properties);
        }
        catch (MojoExecutionException e) {
            MojoUtils.emitBackendLogInfo(this.getLog(), backendLog);
            throw new MavenReportException(e.getMessage());
        }
        catch (MojoFailureException e) {
            MojoUtils.emitBackendLogInfo(this.getLog(), backendLog);
            throw new MavenReportException(e.getMessage());
        }
    }

    private String getErlCommand() {
        File cmd;
        if (this.erlCommand != null && (cmd = new File(this.erlCommand)).isFile() && cmd.canExecute()) {
            return cmd.getAbsolutePath();
        }
        return "erl";
    }

    protected Properties getProperties() {
        List<ArtifactRepository> remoteRepositories = this.remoteRepositories;
        DefaultMavenComponents components = new DefaultMavenComponents(this.localRepository, remoteRepositories, this.metadataSource, this.artifactFactory, this.artifactResolver);
        String cmd = this.getErlCommand();
        this.getLog().debug((CharSequence)("Using command: " + cmd));
        PackagingType type = PackagingType.fromString(this.project.getPackaging());
        return new PropertiesImpl(type, this.project, components, cmd, this.cookie);
    }

    protected abstract void execute(Log var1, Locale var2, Properties var3) throws MojoExecutionException, MojoFailureException, MavenReportException;

    public final boolean canGenerateReport() {
        PackagingType type = PackagingType.fromString(this.getProject().getPackaging());
        return type == PackagingType.ERLANG_OTP || type == PackagingType.ERLANG_STD;
    }
}

