/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven;

import eu.lindenbaum.maven.DefaultMavenComponents;
import eu.lindenbaum.maven.PackagingType;
import eu.lindenbaum.maven.Properties;
import eu.lindenbaum.maven.PropertiesImpl;
import eu.lindenbaum.maven.util.MojoUtils;
import java.io.File;
import java.util.List;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public abstract class ErlangMojo
extends AbstractMojo {
    private MavenProject project;
    private ArtifactRepository localRepository;
    private List<?> remoteRepositories;
    private ArtifactMetadataSource metadataSource;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver artifactResolver;
    private String cookie;
    private String erlCommand;

    public final void execute() throws MojoExecutionException, MojoFailureException {
        PackagingType type = PackagingType.fromString(this.project.getPackaging());
        if (type == PackagingType.UNSUPPORTED) {
            this.getLog().info((CharSequence)("Skipping invocation for packaging type: " + this.project.getPackaging()));
            return;
        }
        Properties properties = this.getProperties(type, this.getErlCommand());
        File backendLog = properties.targetLayout().backendLog();
        try {
            this.execute(this.getLog(), properties);
        }
        catch (MojoExecutionException e) {
            MojoUtils.emitBackendLogInfo(this.getLog(), backendLog);
            throw e;
        }
        catch (MojoFailureException e) {
            MojoUtils.emitBackendLogInfo(this.getLog(), backendLog);
            throw e;
        }
    }

    private String getErlCommand() {
        File cmd;
        if (this.erlCommand != null && (cmd = new File(this.erlCommand)).isFile() && cmd.canExecute()) {
            return cmd.getAbsolutePath();
        }
        return "erl";
    }

    private Properties getProperties(PackagingType type, String cmd) {
        List<ArtifactRepository> remoteRepositories = this.remoteRepositories;
        DefaultMavenComponents components = new DefaultMavenComponents(this.localRepository, remoteRepositories, this.metadataSource, this.artifactFactory, this.artifactResolver);
        this.getLog().debug((CharSequence)("Using command: " + cmd));
        return new PropertiesImpl(type, this.project, components, cmd, this.cookie);
    }

    protected abstract void execute(Log var1, Properties var2) throws MojoExecutionException, MojoFailureException;
}

