/*
 * Decompiled with CFR 0.152.
 */
package eu.limetri.client.mapviewer.fx;

import eu.limetri.client.mapviewer.fx.JFXMapPane;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Slider;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;

public class ZoomPanel
extends BorderPane {
    private static final int BUTTON_SIZE = 20;
    private static final ImageView imagePlus = new ImageView(new Image(JFXMapPane.class.getResource("plus.png").toString()));
    private static final ImageView imageMinus = new ImageView(new Image(JFXMapPane.class.getResource("minus.png").toString()));
    private Button zoomButtonPlus;
    private Button zoomButtonMinus;
    private Slider zoomSlider;
    private JFXMapPane mapPane;
    private SimpleIntegerProperty zoomProperty = new SimpleIntegerProperty();
    private PropertyChangeListener zoomPropertyChangeListener;

    public ZoomPanel(JFXMapPane mapPane) {
        this.mapPane = mapPane;
        this.init();
    }

    private void init() {
        this.zoomButtonMinus = new Button();
        this.zoomButtonPlus = new Button();
        this.zoomButtonMinus.setGraphic((Node)imageMinus);
        this.zoomButtonPlus.setGraphic((Node)imagePlus);
        this.zoomButtonMinus.setMaxSize(20.0, 20.0);
        this.zoomButtonMinus.setMinSize(20.0, 20.0);
        this.zoomButtonPlus.setMaxSize(20.0, 20.0);
        this.zoomButtonPlus.setMinSize(20.0, 20.0);
        this.zoomSlider = new Slider(1.0, 17.0, 0.0);
        this.zoomSlider.setOrientation(Orientation.VERTICAL);
        this.setCenter((Node)this.zoomSlider);
        this.setTop((Node)this.zoomButtonPlus);
        this.setBottom((Node)this.zoomButtonMinus);
        this.getStyleClass().add((Object)"zoom-controls-pane");
        this.zoomButtonPlus.getStyleClass().add((Object)"zoom-button");
        this.zoomButtonPlus.getStyleClass().add((Object)"plus");
        this.zoomButtonMinus.getStyleClass().add((Object)"zoom-button");
        this.zoomButtonMinus.getStyleClass().add((Object)"minus");
        this.setMaxWidth(20.0);
        this.setMaxHeight(150.0);
        this.zoomSlider.valueProperty().bindBidirectional((Property)this.zoomProperty);
        this.zoomButtonPlus.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (ZoomPanel.this.zoomProperty.get() < 17) {
                    ZoomPanel.this.zoomProperty.set(ZoomPanel.this.zoomProperty.get() + 1);
                }
            }
        });
        this.zoomButtonMinus.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (ZoomPanel.this.zoomProperty.get() > 1) {
                    ZoomPanel.this.zoomProperty.set(ZoomPanel.this.zoomProperty.get() - 1);
                }
            }
        });
        this.zoomProperty.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                ZoomPanel.this.setZoom(17 - ZoomPanel.this.zoomProperty.get() + 1);
            }
        });
        this.zoomPropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ZoomPanel.this.setZoomFromMap();
            }
        };
    }

    private void setZoomFromMap() {
        this.zoomProperty.set(17 - this.mapPane.getZoom() + 1);
    }

    protected void setZoom(int zoom) {
        this.mapPane.setZoom(zoom);
    }

    public void attach() {
        this.mapPane.addPropertyChangeListener("zoom", this.zoomPropertyChangeListener);
        this.setZoomFromMap();
    }

    public void detach() {
        this.mapPane.removePropertyChangeListener("zoom", this.zoomPropertyChangeListener);
    }
}

