/*
 * Decompiled with CFR 0.152.
 */
package eu.limetri.client.mapviewer.fx;

import eu.limetri.client.mapviewer.fx.Marker;
import eu.limetri.client.mapviewer.fx.api.MapMarker;
import java.awt.Point;
import javafx.scene.Group;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.RadialGradientBuilder;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Circle;
import javafx.scene.shape.CircleBuilder;

public class MapMarkerDot
implements MapMarker,
Marker {
    double lat;
    double lon;
    Color color;
    Circle sphere;
    int radius;

    public MapMarkerDot(double lat, double lon) {
        this(10, Color.YELLOW, lat, lon);
    }

    public MapMarkerDot(int radius, Color color, double lat, double lon) {
        this.color = color;
        this.lat = lat;
        this.lon = lon;
        this.radius = radius;
        this.sphere = ((CircleBuilder)CircleBuilder.create().centerX((double)radius).centerY((double)radius).radius((double)radius).cache(true)).build();
        RadialGradient rgrad = RadialGradientBuilder.create().centerX(this.sphere.getCenterX() - this.sphere.getRadius() / 3.0).centerY(this.sphere.getCenterY() - this.sphere.getRadius() / 3.0).radius(this.sphere.getRadius()).proportional(false).stops(new Stop[]{new Stop(0.0, color), new Stop(1.0, Color.BLACK)}).build();
        this.sphere.setFill((Paint)rgrad);
        DropShadow dropShadow = new DropShadow();
        dropShadow.setOffsetX(10.0);
        dropShadow.setOffsetY(10.0);
        dropShadow.setColor(Color.rgb((int)50, (int)50, (int)50, (double)0.7));
        this.sphere.setEffect((Effect)dropShadow);
    }

    @Override
    public double getLat() {
        return this.lat;
    }

    @Override
    public double getLon() {
        return this.lon;
    }

    @Override
    public void Render(Group g, Point position) {
        this.sphere.setTranslateX((double)(position.x - this.radius));
        this.sphere.setTranslateY((double)(position.y - this.radius));
        g.getChildren().add((Object)this.sphere);
    }

    public String toString() {
        return "MapMarker at " + this.lat + " " + this.lon;
    }
}

