/**
 * Copyright (C) 2008-2012 AgroSense Foundation.
 *
 * AgroSense is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * There are special exceptions to the terms and conditions of the GPLv3 as it is applied to
 * this software, see the FLOSS License Exception
 * <http://www.agrosense.eu/foss-exception.html>.
 *
 * AgroSense is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with AgroSense.  If not, see <http://www.gnu.org/licenses/>.
 */
package eu.limetri.client.mapviewer.fx.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;

import javafx.scene.image.Image;

import eu.limetri.client.mapviewer.data.cache.OfflineTileFactory;
import eu.limetri.client.mapviewer.data.cache.OfflineTileRunner;
import eu.limetri.client.mapviewer.data.cache.TileCacheInfo;
import eu.limetri.client.mapviewer.data.cache.TileRepository;

/**
 * JavaFX implementation of {@link OfflineTileRunner}
 * 
 * @author Frantisek Post
 */
public class OfflineTileRunnerFX extends OfflineTileRunner<Image> {

	/**
	 * Constructor
	 * 
	 * @param tileFactory
	 */
	public OfflineTileRunnerFX(OfflineTileFactory<Image> tileFactory) {
		super(tileFactory);
	}

	@Override
	protected Image readTileFromRepository(TileCacheInfo info) {
		return getTileRepository().getTile(info);
	}

	@Override
	public Image loadImage(URI uri) throws MalformedURLException, IOException {
		byte[] bimg = cacheInputStream(uri.toURL());
        return new Image(new ByteArrayInputStream(bimg));
	}

	@Override
	public TileRepository<Image> getTileRepository() {
		return TileRepositoryFX.getInstance();
	}

}
