/*
 * Decompiled with CFR 0.152.
 */
package eu.limetri.client.mapviewer.fx.impl;

import eu.limetri.client.mapviewer.data.cache.TileRepository;
import eu.limetri.client.mapviewer.data.cache.TileService;
import eu.limetri.client.mapviewer.data.cache.WritableTileService;
import eu.limetri.client.mapviewer.fx.impl.DefaultTileServiceFX;
import eu.limetri.client.mapviewer.fx.impl.TileServiceFX;
import eu.limetri.client.mapviewer.fx.impl.WritableTileServiceFX;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.scene.image.Image;
import org.openide.util.Lookup;

public class TileRepositoryFX
extends TileRepository<Image> {
    private static final TileRepositoryFX instance = new TileRepositoryFX();
    private static DefaultTileServiceFX service;

    private TileRepositoryFX() {
    }

    public static TileRepository<Image> getInstance() {
        return instance;
    }

    protected List<TileService> findImplementations() {
        Collection caches = Lookup.getDefault().lookupAll(TileServiceFX.class);
        ArrayList<TileService> list = new ArrayList<TileService>();
        list.add(this.getService());
        list.addAll(caches);
        return list;
    }

    protected WritableTileService<Image> findWritableImplementation() {
        WritableTileServiceFX customWritableTileService = (WritableTileServiceFX)Lookup.getDefault().lookup(WritableTileServiceFX.class);
        if (customWritableTileService != null) {
            return customWritableTileService;
        }
        return this.getService();
    }

    private DefaultTileServiceFX getService() {
        if (service == null) {
            service = new DefaultTileServiceFX();
        }
        return service;
    }
}

