/*
 * Decompiled with CFR 0.152.
 */
package eu.limetri.client.mapviewer.fx.impl;

import eu.limetri.client.mapviewer.data.AbstractTileFactory;
import eu.limetri.client.mapviewer.data.Tile;
import eu.limetri.client.mapviewer.data.TileCache;
import eu.limetri.client.mapviewer.data.TileFactoryInfo;
import eu.limetri.client.mapviewer.data.cache.OfflineTileFactory;
import eu.limetri.client.mapviewer.data.cache.spi.TileComparator;
import eu.limetri.client.mapviewer.fx.impl.OfflineTileFX;
import eu.limetri.client.mapviewer.fx.impl.OfflineTileRunnerFX;
import eu.limetri.client.mapviewer.fx.impl.TileCacheFX;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import javafx.scene.image.Image;

public class OfflineTileFactoryFX
extends OfflineTileFactory<Image> {
    private final BlockingQueue<Tile<Image>> tileQueue = new PriorityBlockingQueue<Tile<Image>>(5, (Comparator<Tile<Image>>)new TileComparator());
    private final Map<String, Tile<Image>> tileMap = new HashMap<String, Tile<Image>>();

    public OfflineTileFactoryFX(TileFactoryInfo tileFactoryInfo) {
        super(tileFactoryInfo);
    }

    protected Tile<Image> createOfflineTile(int tileX, int tileY, int zoom, String url) {
        return new OfflineTileFX(tileX, tileY, zoom, url, this);
    }

    protected Runnable createTileRunner() {
        return new OfflineTileRunnerFX(this);
    }

    public TileCache<Image> createTileCache() {
        return new TileCacheFX();
    }

    public Tile<Image> createTile(int x, int y, int zoom, String url, AbstractTileFactory<Image, Tile<Image>> tileFactory) {
        return new OfflineTileFX(x, y, zoom, url, (OfflineTileFactory<Image>)((OfflineTileFactory)tileFactory));
    }

    public BlockingQueue<Tile<Image>> getTileQueue() {
        return this.tileQueue;
    }

    protected Map<String, Tile<Image>> getTileMap() {
        return this.tileMap;
    }
}

