/*
 * Decompiled with CFR 0.152.
 */
package eu.limetri.client.mapviewer.fx.impl;

import eu.limetri.client.mapviewer.data.cache.TileCacheInfo;
import eu.limetri.client.mapviewer.data.cache.spi.AbstractTileService;
import eu.limetri.client.mapviewer.fx.impl.TileServiceFX;
import eu.limetri.client.mapviewer.fx.impl.WritableTileServiceFX;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.Image;
import javax.imageio.ImageIO;
import org.openide.filesystems.FileObject;

public class DefaultTileServiceFX
extends AbstractTileService<Image>
implements TileServiceFX,
WritableTileServiceFX {
    private static final Logger LOG = Logger.getLogger(DefaultTileServiceFX.class.getName());

    public Image readImage(TileCacheInfo tileCacheInfo) {
        Image image = null;
        FileObject tileFile = this.getTileFile(tileCacheInfo, false);
        if (tileFile != null) {
            try (InputStream stream = tileFile.getInputStream();){
                image = new Image(stream);
                this.readCallback(tileFile);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                LOG.log(Level.FINE, "Error reading tile image from file ", ex);
            }
        }
        return image;
    }

    public void writeImage(TileCacheInfo tileCacheInfo, Image image) {
        FileObject tileFile = this.getTileFile(tileCacheInfo, true);
        BufferedImage bufferedImage = SwingFXUtils.fromFXImage((Image)image, null);
        if (tileFile != null) {
            try (OutputStream stream = tileFile.getOutputStream();){
                ImageIO.write((RenderedImage)bufferedImage, "png", stream);
                this.writeCallback();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                LOG.log(Level.FINE, "Problem writing tile image to file", ex);
            }
        } else {
            LOG.fine("Failed to write image for tile");
        }
    }
}

