/*
 * Decompiled with CFR 0.152.
 */
package eu.limetri.client.mapviewer.fx;

import eu.limetri.client.mapviewer.data.TileFactoryInfo;
import eu.limetri.client.mapviewer.data.common.TileFactoryInfoSelectionEventHandler;
import java.net.URL;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;

public class MapTypeSelectionPanelFX
extends BorderPane {
    private Label label;
    private Button button;
    private TileFactoryInfo[] tileFactoryInfos;
    private TileFactoryInfo activeTileFactoryInfo;
    private TileFactoryInfoSelectionEventHandler eventHandler;
    private static final ImageView imageDown = new ImageView(new Image(MapTypeSelectionPanelFX.class.getResource("down14.png").toString()));

    public MapTypeSelectionPanelFX() {
        this.init();
    }

    private void init() {
        this.getStyleClass().add((Object)"MapTypeSelectionPanelFX");
        this.button = new Button();
        this.button.setGraphic((Node)imageDown);
        this.label = new Label();
        this.setLeft((Node)this.label);
        this.setRight((Node)this.button);
        BorderPane.setMargin((Node)this.label, (Insets)new Insets(2.0, 10.0, 0.0, 10.0));
        this.button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                MapTypeSelectionPanelFX.this.showPopup();
            }
        });
    }

    private void showPopup() {
        ContextMenu menu = new ContextMenu();
        for (final TileFactoryInfo tileFactoryInfo : this.tileFactoryInfos) {
            MenuItem menuItem = new MenuItem();
            menuItem.setText(tileFactoryInfo.getName());
            if (tileFactoryInfo.getIconUrl() != null) {
                menuItem.setGraphic((Node)this.createIcon(tileFactoryInfo.getIconUrl()));
            }
            menu.getItems().add((Object)menuItem);
            boolean active = tileFactoryInfo.equals((Object)this.activeTileFactoryInfo);
            if (active) continue;
            menuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    MapTypeSelectionPanelFX.this.selectTileInfo(tileFactoryInfo);
                    MapTypeSelectionPanelFX.this.setActiveTileFactoryInfo(tileFactoryInfo);
                }
            });
        }
        menu.show((Node)this, Side.TOP, 0.0, 0.0);
    }

    private ImageView createIcon(URL iconUrl) {
        return new ImageView(new Image(iconUrl.toString()));
    }

    protected void selectTileInfo(TileFactoryInfo info) {
        if (this.eventHandler != null) {
            this.eventHandler.itemSelected((Object)info);
        }
    }

    public void setOnSelectionChange(TileFactoryInfoSelectionEventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    public void setItems(TileFactoryInfo[] tileFactoryInfos) {
        this.tileFactoryInfos = tileFactoryInfos;
    }

    public void setActiveTileFactoryInfo(TileFactoryInfo activeTileFactoryInfo) {
        this.activeTileFactoryInfo = activeTileFactoryInfo;
        this.label.setText(activeTileFactoryInfo.getName());
    }
}

