/*
 * Decompiled with CFR 0.152.
 */
package eu.limetri.client.mapviewer.fx;

import eu.limetri.client.mapviewer.fx.Marker;
import eu.limetri.client.mapviewer.fx.api.MapMarker;
import java.awt.Point;
import javafx.scene.Group;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.Light;
import javafx.scene.effect.Lighting;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Color;

public class MapMarkerVehicle
implements MapMarker,
Marker {
    double lat;
    double lon;
    double hdg;
    ImageView ImgView;

    public MapMarkerVehicle(Image img, double lat, double lon, double hdg) {
        this.lat = lat;
        this.lon = lon;
        this.hdg = hdg;
        this.ImgView = new ImageView(img);
        Light.Distant light = new Light.Distant();
        light.setAzimuth(-135.0);
        Lighting lighting = new Lighting();
        lighting.setLight((Light)light);
        lighting.setSurfaceScale(5.0);
        DropShadow dropShadow = new DropShadow();
        dropShadow.setOffsetX(30.0);
        dropShadow.setOffsetY(30.0);
        dropShadow.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.7));
        dropShadow.setInput((Effect)lighting);
        this.ImgView.setEffect((Effect)dropShadow);
    }

    @Override
    public double getLat() {
        return this.lat;
    }

    public void setLat(double val) {
        this.lat = val;
    }

    @Override
    public double getLon() {
        return this.lon;
    }

    public void setLon(double val) {
        this.lon = val;
    }

    public double getHdg() {
        return this.hdg;
    }

    public void setHdg(double val) {
        this.hdg = val;
    }

    @Override
    public void Render(Group g, Point position) {
        int size_w = (int)this.ImgView.getImage().getWidth();
        int size_h = (int)this.ImgView.getImage().getHeight();
        this.ImgView.setTranslateX((double)(position.x - size_w / 2));
        this.ImgView.setTranslateY((double)(position.y - size_h / 2));
        this.ImgView.setRotate(this.hdg);
        g.getChildren().add((Object)this.ImgView);
    }

    public String toString() {
        return "Vehicle at " + this.lat + " " + this.lon;
    }
}

