/*
 * Decompiled with CFR 0.152.
 */
package eu.limetri.client.mapviewer.fx;

import com.vividsolutions.jts.geom.Coordinate;
import eu.limetri.client.mapviewer.fx.JFXMapPane;
import eu.limetri.client.mapviewer.fx.api.MapLine;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polyline;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;

public class MapLineTrail
implements MapLine {
    String Name;
    Color color;
    double dashOffset;
    double width;
    ObservableList<Coordinate> Coordinates;

    public MapLineTrail(String n, Color c, double width, double dashOffset, List<Coordinate> coords) {
        this.Name = n;
        this.color = c;
        this.dashOffset = dashOffset;
        this.width = width;
        this.Coordinates = FXCollections.observableList(coords);
    }

    @Override
    public void addCoordinate(Coordinate coordinate) {
        this.Coordinates.add((Object)coordinate);
    }

    public void Render(JFXMapPane viewer, Group g) {
        Polyline polyline = new Polyline();
        polyline.setStrokeType(StrokeType.CENTERED);
        polyline.setStrokeDashOffset(this.dashOffset);
        polyline.setStroke((Paint)this.color);
        polyline.setStrokeWidth(this.width);
        polyline.setStrokeLineCap(StrokeLineCap.ROUND);
        polyline.setStrokeLineJoin(StrokeLineJoin.ROUND);
        DropShadow dropShadow = new DropShadow();
        dropShadow.setOffsetX(10.0);
        dropShadow.setOffsetY(10.0);
        dropShadow.setColor(Color.rgb((int)50, (int)50, (int)50, (double)0.7));
        polyline.setEffect((Effect)dropShadow);
        g.getChildren().add((Object)polyline);
    }

    public String toString() {
        return "MapLine" + this.Name;
    }
}

