/*
 * Decompiled with CFR 0.152.
 */
package eu.limetri.client.mapviewer.fx;

import eu.limetri.client.mapviewer.data.AbstractMapViewer;
import eu.limetri.client.mapviewer.data.GeoPosition;
import eu.limetri.client.mapviewer.data.MapViewer;
import eu.limetri.client.mapviewer.data.Tile;
import eu.limetri.client.mapviewer.data.TileFactory;
import eu.limetri.client.mapviewer.data.TileFactoryInfo;
import eu.limetri.client.mapviewer.data.common.TileFactoryInfoSelectionEventHandler;
import eu.limetri.client.mapviewer.data.tilefactory.OSMTileFactoryInfo;
import eu.limetri.client.mapviewer.fx.MapTypeSelectionPanelFX;
import eu.limetri.client.mapviewer.fx.ZoomPanel;
import eu.limetri.client.mapviewer.fx.impl.OfflineTileFactoryFX;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.effect.BlendMode;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class JFXMapPane
extends StackPane
implements MapViewer<Image, Tile<Image>> {
    private static final int TILE_SIZE = 256;
    public static final String ZOOM = "zoom";
    private Canvas canvas = new Canvas();
    private AbstractMapViewer<Image, Tile<Image>> abstractMapViewer;
    private TileLoadListener tileLoadListener = new TileLoadListener();
    private Image loadingImage;
    private double prevX;
    private double prevY;
    private boolean zoomSelectActive = false;
    private double zoomX;
    private double zoomY;
    public static final int MIN_ZOOM = 1;
    public static final int MAX_ZOOM = 17;
    private WritableImage savedCanvas;
    private PropertyChangeSupport propertyChangeSupport;
    private boolean zoomEnabled = false;
    private boolean typeSelectionEnabled = false;
    private AnchorPane rightPane = new AnchorPane();
    private ZoomPanel zoomPanel;
    private MapTypeSelectionPanelFX typeSelectionPanel;

    public JFXMapPane() {
        this.canvas.setBlendMode(BlendMode.MULTIPLY);
        this.canvas.widthProperty().bind((ObservableValue)this.widthProperty());
        this.canvas.heightProperty().bind((ObservableValue)this.heightProperty());
        this.getChildren().add((Object)this.canvas);
        this.initMapViewer();
        this.loadingImage = new Image(((Object)((Object)this)).getClass().getResourceAsStream("loading.png"));
        this.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                JFXMapPane.this.prevX = event.getX();
                JFXMapPane.this.prevY = event.getY();
                JFXMapPane.this.savedCanvas = null;
            }
        });
        this.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (JFXMapPane.this.zoomSelectActive) {
                    JFXMapPane.this.zoomSelectActive = false;
                    JFXMapPane.this.abstractMapViewer.zoomToCoordinates(JFXMapPane.this.prevX, JFXMapPane.this.prevY, event.getX(), event.getY());
                }
            }
        });
        this.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.isControlDown()) {
                    JFXMapPane.this.zoomSelectActive = true;
                    JFXMapPane.this.zoomX = event.getX();
                    JFXMapPane.this.zoomY = event.getY();
                    JFXMapPane.this.paintZoomRectangle();
                } else {
                    JFXMapPane.this.zoomSelectActive = false;
                    double mouseX = event.getX();
                    double mouseY = event.getY();
                    double x = JFXMapPane.this.abstractMapViewer.getCenter().getX() - (mouseX - JFXMapPane.this.prevX);
                    double y = JFXMapPane.this.abstractMapViewer.getCenter().getY() - (mouseY - JFXMapPane.this.prevY);
                    int maxHeight = (int)(JFXMapPane.this.abstractMapViewer.getTileFactory().getMapSize(JFXMapPane.this.abstractMapViewer.getZoom()).getHeight() * (double)JFXMapPane.this.abstractMapViewer.getTileFactory().getTileSize(JFXMapPane.this.abstractMapViewer.getZoom()));
                    if (y > (double)maxHeight) {
                        y = maxHeight;
                    }
                    JFXMapPane.this.abstractMapViewer.setCenter((Point2D)new Point2D.Double(x, y));
                    JFXMapPane.this.paintTiles();
                    JFXMapPane.this.prevX = mouseX;
                    JFXMapPane.this.prevY = mouseY;
                }
            }
        });
        this.canvas.setOnScroll((EventHandler)new EventHandler<ScrollEvent>(){

            public void handle(ScrollEvent me) {
                if (me.getDeltaY() > 0.0) {
                    if (JFXMapPane.this.getZoom() > 1) {
                        JFXMapPane.this.zoomOut();
                    }
                } else if (JFXMapPane.this.getZoom() < 17) {
                    JFXMapPane.this.zoomIn();
                }
            }
        });
        ChangeListener<Number> changeListener = new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                JFXMapPane.this.refreshScene();
            }
        };
        this.widthProperty().addListener((ChangeListener)changeListener);
        this.heightProperty().addListener((ChangeListener)changeListener);
        this.propertyChangeSupport = new PropertyChangeSupport((Object)this);
        this.rightPane = new AnchorPane();
        this.getChildren().add((Object)this.rightPane);
        this.setZoomEnabled(true);
    }

    private void refreshScene() {
        this.paintTiles();
    }

    private void initMapViewer() {
        this.abstractMapViewer = new AbstractMapViewer<Image, Tile<Image>>(){

            protected void repaint() {
                JFXMapPane.this.paintTiles();
            }

            protected int getWidth() {
                return (int)JFXMapPane.this.getWidth();
            }

            protected Insets getInsets() {
                return new Insets(0, 0, 0, 0);
            }

            protected int getHeight() {
                return (int)JFXMapPane.this.getHeight();
            }

            protected void firePropertyChange(String name, Object oldValue, Object newValue) {
                JFXMapPane.this.firePropertyChange(name, oldValue, newValue);
            }
        };
        this.abstractMapViewer.setTileFactory((TileFactory)new OfflineTileFactoryFX((TileFactoryInfo)new OSMTileFactoryInfo()));
    }

    protected void paintTiles() {
        Point2D center = this.abstractMapViewer.getCenter();
        double viewerHeight = this.getHeight();
        int maxHeight = (int)(this.getTileFactory().getMapSize(this.getZoom()).getHeight() * (double)this.getTileFactory().getTileSize(this.getZoom()));
        double y = center.getY();
        if (y < viewerHeight / 2.0) {
            y = viewerHeight / 2.0;
        }
        if (y > (double)maxHeight - viewerHeight / 2.0) {
            y = (double)maxHeight - viewerHeight / 2.0;
        }
        if (y != center.getY()) {
            this.abstractMapViewer.setCenter((Point2D)new Point2D.Double(center.getX(), y));
        }
        int zoom = this.abstractMapViewer.getZoom();
        Rectangle viewportBounds = this.abstractMapViewer.getViewportBounds();
        this.drawMapTiles(zoom, viewportBounds);
    }

    private void drawMapTiles(int zoom, Rectangle viewportBounds) {
        int size = this.abstractMapViewer.getTileFactory().getTileSize(zoom);
        int numWide = viewportBounds.width / size + 2;
        int numHigh = viewportBounds.height / size + 2;
        TileFactoryInfo info = this.abstractMapViewer.getTileFactory().getInfo();
        int tpx = (int)Math.floor(viewportBounds.getX() / (double)info.getTileSize(0));
        int tpy = (int)Math.floor(viewportBounds.getY() / (double)info.getTileSize(0));
        GraphicsContext graphicsContext = this.canvas.getGraphicsContext2D();
        graphicsContext.setFill((Paint)Color.GRAY);
        graphicsContext.fillRect(0.0, 0.0, this.canvas.getWidth(), this.canvas.getHeight());
        for (int x = 0; x <= numWide; ++x) {
            for (int y = 0; y <= numHigh; ++y) {
                int itpx = x + tpx;
                int itpy = y + tpy;
                Tile tile = this.abstractMapViewer.getTileFactory().getTile(itpx, itpy, zoom);
                tile.addUniquePropertyChangeListener("loaded", (PropertyChangeListener)this.tileLoadListener);
                int ox = itpx * this.abstractMapViewer.getTileFactory().getTileSize(zoom) - viewportBounds.x;
                int oy = itpy * this.abstractMapViewer.getTileFactory().getTileSize(zoom) - viewportBounds.y;
                if (tile.isLoaded()) {
                    graphicsContext.drawImage((Image)tile.getImage(), (double)ox, (double)oy);
                    continue;
                }
                Tile superTile = this.abstractMapViewer.getTileFactory().getTile(itpx / 2, itpy / 2, zoom + 1);
                if (superTile.isLoaded()) {
                    int offX = itpx % 2 * size / 2;
                    int offY = itpy % 2 * size / 2;
                    graphicsContext.drawImage((Image)superTile.getImage(), (double)offX, (double)offY, (double)(size / 2), (double)(size / 2), (double)ox, (double)oy, (double)size, (double)size);
                    continue;
                }
                Image image = this.getLoadingImage();
                double h = image.getHeight();
                double w = image.getWidth();
                double lx = 128.0 - w / 2.0;
                double ly = 128.0 - h / 2.0;
                graphicsContext.setFill((Paint)Color.GRAY);
                graphicsContext.fillRect((double)ox, (double)oy, 256.0, 256.0);
                graphicsContext.drawImage(this.getLoadingImage(), (double)ox + lx, (double)oy + ly);
            }
        }
    }

    private void paintZoomRectangle() {
        if (this.zoomSelectActive) {
            GraphicsContext graphicsContext = this.canvas.getGraphicsContext2D();
            if (this.savedCanvas == null) {
                this.savedCanvas = this.canvas.snapshot(null, null);
            } else {
                graphicsContext.drawImage((Image)this.savedCanvas, 0.0, 0.0);
            }
            this.abstractMapViewer.fireRepaintCallbacks();
            graphicsContext.setLineWidth(3.0);
            graphicsContext.setStroke((Paint)Color.RED);
            graphicsContext.strokeRect(Math.min(this.prevX, this.zoomX), Math.min(this.prevY, this.zoomY), Math.abs(this.zoomX - this.prevX), Math.abs(this.zoomY - this.prevY));
        }
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void setZoom(int zoom) {
        this.abstractMapViewer.setZoom(zoom);
    }

    public void setAddressLocation(GeoPosition addressLocation) {
        this.abstractMapViewer.setAddressLocation(addressLocation);
    }

    public Image getLoadingImage() {
        return this.loadingImage;
    }

    public int getZoom() {
        return this.abstractMapViewer.getZoom();
    }

    public void zoomIn() {
        if (this.getZoom() < 17) {
            this.abstractMapViewer.setZoom(this.abstractMapViewer.getZoom() + 1);
        }
    }

    public void zoomOut() {
        if (this.getZoom() > 1) {
            this.abstractMapViewer.setZoom(this.abstractMapViewer.getZoom() - 1);
        }
    }

    public TileFactory<Image, Tile<Image>> getTileFactory() {
        return this.abstractMapViewer.getTileFactory();
    }

    public Rectangle2D getViewportBounds() {
        return this.abstractMapViewer.getViewportBounds();
    }

    public void setTileFactory(TileFactory<Image, Tile<Image>> factory) {
        this.abstractMapViewer.setTileFactory(factory);
        this.paintTiles();
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public void setZoomEnabled(boolean zoomEnabled) {
        if (this.zoomEnabled != zoomEnabled) {
            this.zoomEnabled = zoomEnabled;
            if (zoomEnabled) {
                this.enableZoom();
            } else {
                this.disableZoom();
            }
        }
    }

    public boolean isZoomEnabled() {
        return this.zoomEnabled;
    }

    private void enableZoom() {
        this.zoomPanel = new ZoomPanel(this);
        this.zoomPanel.attach();
        AnchorPane.setTopAnchor((Node)this.zoomPanel, (Double)30.0);
        AnchorPane.setRightAnchor((Node)this.zoomPanel, (Double)2.0);
        this.rightPane.getChildren().add((Object)this.zoomPanel);
    }

    private void disableZoom() {
        this.zoomPanel.detach();
        this.rightPane.getChildren().remove((Object)this.zoomPanel);
    }

    public void setTypeSelectionEnabled(boolean typeSelectionEnabled, TileFactoryInfo ... tileFactoryInfos) {
        if (this.typeSelectionEnabled != typeSelectionEnabled) {
            this.typeSelectionEnabled = typeSelectionEnabled;
            if (typeSelectionEnabled) {
                this.enableTypeSelection(tileFactoryInfos);
            } else {
                this.disableTypeSelection();
            }
        }
    }

    private void enableTypeSelection(TileFactoryInfo ... tileFactoryInfos) {
        this.typeSelectionPanel = new MapTypeSelectionPanelFX();
        this.typeSelectionPanel.setItems(tileFactoryInfos);
        this.typeSelectionPanel.setOnSelectionChange(new TileFactoryInfoSelectionEventHandler(){

            public void itemSelected(TileFactoryInfo tileFactoryInfo) {
                JFXMapPane.this.setTileFactory((TileFactory<Image, Tile<Image>>)new OfflineTileFactoryFX(tileFactoryInfo));
            }
        });
        this.typeSelectionPanel.setActiveTileFactoryInfo(this.getTileFactory().getInfo());
        AnchorPane.setTopAnchor((Node)this.typeSelectionPanel, (Double)2.0);
        AnchorPane.setRightAnchor((Node)this.typeSelectionPanel, (Double)2.0);
        this.rightPane.getChildren().add((Object)this.typeSelectionPanel);
    }

    private void disableTypeSelection() {
        this.rightPane.getChildren().remove((Object)this.typeSelectionPanel);
    }

    public boolean isTypeSelectionEnabled() {
        return this.typeSelectionEnabled;
    }

    private final class TileLoadListener
    implements PropertyChangeListener {
        private TileLoadListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Tile t;
            if ("loaded".equals(evt.getPropertyName()) && Boolean.TRUE.equals(evt.getNewValue()) && (t = (Tile)evt.getSource()).getZoom() == JFXMapPane.this.abstractMapViewer.getZoom()) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        JFXMapPane.this.paintTiles();
                    }
                });
            }
        }
    }
}

