/*
 * Decompiled with CFR 0.152.
 */
package eu.limetri.client.mapviewer.demo.fx;

import eu.limetri.client.mapviewer.data.GeoPosition;
import eu.limetri.client.mapviewer.data.TileFactoryInfo;
import eu.limetri.client.mapviewer.data.tilefactory.OSMTileFactoryInfo;
import eu.limetri.client.mapviewer.data.tilefactory.VirtualEarthTileFactoryInfo;
import eu.limetri.client.mapviewer.data.util.ConnectionChecker;
import eu.limetri.client.mapviewer.fx.JFXMapPane;
import java.net.URL;
import javafx.application.Application;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;

public class JFXMapPaneDemo
extends Application {
    public static void main(String[] args) {
        JFXMapPaneDemo.launch((String[])args);
    }

    public void start(Stage primaryStage) {
        ConnectionChecker.getInstance().start();
        primaryStage.setTitle("JFXMapPane Demo");
        StackPane root = new StackPane();
        JFXMapPane map = new JFXMapPane();
        GeoPosition greenwich = new GeoPosition(51.4788, 0.0106);
        map.setZoom(7);
        map.setAddressLocation(greenwich);
        OSMTileFactoryInfo osmInfo = new OSMTileFactoryInfo();
        osmInfo.setIconUrl(JFXMapPaneDemo.class.getClassLoader().getResource("osm.png"));
        VirtualEarthTileFactoryInfo vetfi1 = new VirtualEarthTileFactoryInfo(VirtualEarthTileFactoryInfo.MAP);
        VirtualEarthTileFactoryInfo vetfi2 = new VirtualEarthTileFactoryInfo(VirtualEarthTileFactoryInfo.SATELLITE);
        VirtualEarthTileFactoryInfo vetfi3 = new VirtualEarthTileFactoryInfo(VirtualEarthTileFactoryInfo.HYBRID);
        vetfi1.setIconUrl(JFXMapPaneDemo.class.getClassLoader().getResource("vem.png"));
        vetfi2.setIconUrl(JFXMapPaneDemo.class.getClassLoader().getResource("ves.png"));
        vetfi3.setIconUrl(JFXMapPaneDemo.class.getClassLoader().getResource("veh.png"));
        root.getChildren().add((Object)map);
        TileFactoryInfo[] infos = new TileFactoryInfo[]{osmInfo, vetfi1, vetfi2, vetfi3};
        map.setTypeSelectionEnabled(true, infos);
        Scene scene = new Scene((Parent)root, 800.0, 600.0);
        URL cssUrl = ((Object)((Object)this)).getClass().getClassLoader().getResource("JFXMapPaneDemo.css");
        if (cssUrl != null) {
            scene.getStylesheets().add((Object)cssUrl.toExternalForm());
        } else {
            System.err.println("WARNING:stylesheet not found!");
        }
        primaryStage.setScene(scene);
        primaryStage.show();
    }
}

