/*
 * Decompiled with CFR 0.152.
 */
package eu.lestard.redux_javafx_devtool;

import com.netopyr.reduxfx.middleware.Middleware;
import com.netopyr.reduxfx.updater.Update;
import eu.lestard.redux_javafx_devtool.Connector;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;

public class ReduxFXDevToolConnector<STATE>
implements Connector<STATE>,
Middleware<STATE> {
    private final Publisher<STATE> statePublisher;
    private final List<Consumer<STATE>> callbacks = new CopyOnWriteArrayList<Consumer<STATE>>();
    private BiConsumer<Object, STATE> actionPublisher;

    public ReduxFXDevToolConnector() {
        this.statePublisher = Flowable.create(emitter -> this.callbacks.add(arg_0 -> ((FlowableEmitter)emitter).onNext(arg_0)), (BackpressureStrategy)BackpressureStrategy.MISSING);
    }

    public void pushState(STATE newState) {
        this.callbacks.forEach(callback -> callback.accept(newState));
    }

    public void initActionPublisher(BiConsumer<Object, STATE> actionPublisher) {
        this.actionPublisher = actionPublisher;
    }

    public BiFunction<STATE, Object, Update<STATE>> apply(BiFunction<STATE, Object, Update<STATE>> next) {
        return (oldState, action) -> {
            Update newState = (Update)next.apply(oldState, action);
            this.actionPublisher.accept(action, newState.getState());
            return newState;
        };
    }

    public Publisher<STATE> getStatePublisher() {
        return this.statePublisher;
    }
}

