/*
 * Decompiled with CFR 0.152.
 */
package eu.lestard.advanced_bindings.api;

import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.FloatBinding;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.binding.LongBinding;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableFloatValue;
import javafx.beans.value.ObservableIntegerValue;
import javafx.beans.value.ObservableLongValue;

public class MathBindings {
    public static IntegerBinding abs(ObservableIntegerValue a) {
        return Bindings.createIntegerBinding(() -> Math.abs(a.get()), (Observable[])new Observable[]{a});
    }

    public static DoubleBinding abs(ObservableDoubleValue a) {
        return Bindings.createDoubleBinding(() -> Math.abs(a.get()), (Observable[])new Observable[]{a});
    }

    public static LongBinding abs(ObservableLongValue a) {
        return Bindings.createLongBinding(() -> Math.abs(a.get()), (Observable[])new Observable[]{a});
    }

    public static FloatBinding abs(ObservableFloatValue a) {
        return Bindings.createFloatBinding(() -> Float.valueOf(Math.abs(a.get())), (Observable[])new Observable[]{a});
    }

    public static IntegerBinding addExact(ObservableIntegerValue x, ObservableIntegerValue y) {
        return Bindings.createIntegerBinding(() -> Math.addExact(x.get(), y.get()), (Observable[])new Observable[]{x, y});
    }

    public static IntegerBinding addExact(int x, ObservableIntegerValue y) {
        return Bindings.createIntegerBinding(() -> Math.addExact(x, y.get()), (Observable[])new Observable[]{y});
    }

    public static IntegerBinding addExact(ObservableIntegerValue x, int y) {
        return Bindings.createIntegerBinding(() -> Math.addExact(x.get(), y), (Observable[])new Observable[]{x});
    }

    public static LongBinding addExact(ObservableLongValue x, ObservableLongValue y) {
        return Bindings.createLongBinding(() -> Math.addExact(x.get(), y.get()), (Observable[])new Observable[]{x, y});
    }

    public static LongBinding addExact(long x, ObservableLongValue y) {
        return Bindings.createLongBinding(() -> Math.addExact(x, y.get()), (Observable[])new Observable[]{y});
    }

    public static LongBinding addExact(ObservableLongValue x, long y) {
        return Bindings.createLongBinding(() -> Math.addExact(x.get(), y), (Observable[])new Observable[]{x});
    }

    public static DoubleBinding acos(ObservableDoubleValue a) {
        return Bindings.createDoubleBinding(() -> Math.acos(a.get()), (Observable[])new Observable[]{a});
    }

    public static DoubleBinding asin(ObservableDoubleValue a) {
        return Bindings.createDoubleBinding(() -> Math.asin(a.get()), (Observable[])new Observable[]{a});
    }

    public static DoubleBinding atan(ObservableDoubleValue a) {
        return Bindings.createDoubleBinding(() -> Math.atan(a.get()), (Observable[])new Observable[]{a});
    }

    public static DoubleBinding atan2(ObservableDoubleValue y, ObservableDoubleValue x) {
        return Bindings.createDoubleBinding(() -> Math.atan2(y.get(), x.get()), (Observable[])new Observable[]{y, x});
    }

    public static DoubleBinding atan2(double y, ObservableDoubleValue x) {
        return Bindings.createDoubleBinding(() -> Math.atan2(y, x.get()), (Observable[])new Observable[]{x});
    }

    public static DoubleBinding atan2(ObservableDoubleValue y, double x) {
        return Bindings.createDoubleBinding(() -> Math.atan2(y.get(), x), (Observable[])new Observable[]{y});
    }

    public static DoubleBinding cbrt(ObservableDoubleValue a) {
        return Bindings.createDoubleBinding(() -> Math.cbrt(a.get()), (Observable[])new Observable[]{a});
    }

    public static DoubleBinding ceil(ObservableDoubleValue a) {
        return Bindings.createDoubleBinding(() -> Math.ceil(a.get()), (Observable[])new Observable[]{a});
    }

    public static DoubleBinding copySign(ObservableDoubleValue magnitude, ObservableDoubleValue sign) {
        return Bindings.createDoubleBinding(() -> Math.copySign(magnitude.get(), sign.get()), (Observable[])new Observable[]{magnitude, sign});
    }

    public static DoubleBinding copySign(double magnitude, ObservableDoubleValue sign) {
        return Bindings.createDoubleBinding(() -> Math.copySign(magnitude, sign.get()), (Observable[])new Observable[]{sign});
    }

    public static DoubleBinding copySign(ObservableDoubleValue magnitude, double sign) {
        return Bindings.createDoubleBinding(() -> Math.copySign(magnitude.get(), sign), (Observable[])new Observable[]{magnitude});
    }

    public static FloatBinding copySign(ObservableFloatValue magnitude, ObservableFloatValue sign) {
        return Bindings.createFloatBinding(() -> Float.valueOf(Math.copySign(magnitude.get(), sign.get())), (Observable[])new Observable[]{magnitude, sign});
    }

    public static FloatBinding copySign(float magnitude, ObservableFloatValue sign) {
        return Bindings.createFloatBinding(() -> Float.valueOf(Math.copySign(magnitude, sign.get())), (Observable[])new Observable[]{sign});
    }

    public static FloatBinding copySign(ObservableFloatValue magnitude, float sign) {
        return Bindings.createFloatBinding(() -> Float.valueOf(Math.copySign(magnitude.get(), sign)), (Observable[])new Observable[]{magnitude});
    }

    public static DoubleBinding cos(ObservableDoubleValue a) {
        return Bindings.createDoubleBinding(() -> Math.cos(a.get()), (Observable[])new Observable[]{a});
    }

    public static DoubleBinding cosh(ObservableDoubleValue x) {
        return Bindings.createDoubleBinding(() -> Math.cosh(x.get()), (Observable[])new Observable[]{x});
    }

    public static IntegerBinding decrementExact(ObservableIntegerValue a) {
        return Bindings.createIntegerBinding(() -> Math.decrementExact(a.get()), (Observable[])new Observable[]{a});
    }

    public static LongBinding decrementExact(ObservableLongValue a) {
        return Bindings.createLongBinding(() -> Math.decrementExact(a.get()), (Observable[])new Observable[]{a});
    }

    public static DoubleBinding exp(ObservableDoubleValue a) {
        return Bindings.createDoubleBinding(() -> Math.exp(a.get()), (Observable[])new Observable[]{a});
    }

    public static DoubleBinding expm1(ObservableDoubleValue x) {
        return Bindings.createDoubleBinding(() -> Math.expm1(x.get()), (Observable[])new Observable[]{x});
    }

    public static DoubleBinding floor(ObservableDoubleValue a) {
        return Bindings.createDoubleBinding(() -> Math.floor(a.get()), (Observable[])new Observable[]{a});
    }

    public static IntegerBinding floorDiv(ObservableIntegerValue x, ObservableIntegerValue y) {
        return Bindings.createIntegerBinding(() -> Math.floorDiv(x.get(), y.get()), (Observable[])new Observable[]{x, y});
    }

    public static IntegerBinding floorDiv(int x, ObservableIntegerValue y) {
        return Bindings.createIntegerBinding(() -> Math.floorDiv(x, y.get()), (Observable[])new Observable[]{y});
    }

    public static IntegerBinding floorDiv(ObservableIntegerValue x, int y) {
        return Bindings.createIntegerBinding(() -> Math.floorDiv(x.get(), y), (Observable[])new Observable[]{x});
    }

    public static LongBinding floorDiv(ObservableLongValue x, ObservableLongValue y) {
        return Bindings.createLongBinding(() -> Math.floorDiv(x.get(), y.get()), (Observable[])new Observable[]{x, y});
    }

    public static LongBinding floorDiv(long x, ObservableLongValue y) {
        return Bindings.createLongBinding(() -> Math.floorDiv(x, y.get()), (Observable[])new Observable[]{y});
    }

    public static LongBinding floorDiv(ObservableLongValue x, long y) {
        return Bindings.createLongBinding(() -> Math.floorDiv(x.get(), y), (Observable[])new Observable[]{x});
    }

    public static IntegerBinding floorMod(ObservableIntegerValue x, ObservableIntegerValue y) {
        return Bindings.createIntegerBinding(() -> Math.floorMod(x.get(), y.get()), (Observable[])new Observable[]{x, y});
    }

    public static IntegerBinding floorMod(int x, ObservableIntegerValue y) {
        return Bindings.createIntegerBinding(() -> Math.floorMod(x, y.get()), (Observable[])new Observable[]{y});
    }

    public static IntegerBinding floorMod(ObservableIntegerValue x, int y) {
        return Bindings.createIntegerBinding(() -> Math.floorMod(x.get(), y), (Observable[])new Observable[]{x});
    }

    public static LongBinding floorMod(ObservableLongValue x, ObservableLongValue y) {
        return Bindings.createLongBinding(() -> Math.floorMod(x.get(), y.get()), (Observable[])new Observable[]{x, y});
    }

    public static LongBinding floorMod(long x, ObservableLongValue y) {
        return Bindings.createLongBinding(() -> Math.floorMod(x, y.get()), (Observable[])new Observable[]{y});
    }

    public static LongBinding floorMod(ObservableLongValue x, long y) {
        return Bindings.createLongBinding(() -> Math.floorMod(x.get(), y), (Observable[])new Observable[]{x});
    }

    public static IntegerBinding getExponent(ObservableDoubleValue d) {
        return Bindings.createIntegerBinding(() -> Math.getExponent(d.get()), (Observable[])new Observable[]{d});
    }

    public static IntegerBinding getExponent(ObservableFloatValue f) {
        return Bindings.createIntegerBinding(() -> Math.getExponent(f.get()), (Observable[])new Observable[]{f});
    }

    public static DoubleBinding hypot(ObservableDoubleValue x, ObservableDoubleValue y) {
        return Bindings.createDoubleBinding(() -> Math.hypot(x.get(), y.get()), (Observable[])new Observable[]{x, y});
    }

    public static DoubleBinding hypot(double x, ObservableDoubleValue y) {
        return Bindings.createDoubleBinding(() -> Math.hypot(x, y.get()), (Observable[])new Observable[]{y});
    }

    public static DoubleBinding hypot(ObservableDoubleValue x, double y) {
        return Bindings.createDoubleBinding(() -> Math.hypot(x.get(), y), (Observable[])new Observable[]{x});
    }

    public static DoubleBinding IEEEremainder(ObservableDoubleValue f1, ObservableDoubleValue f2) {
        return Bindings.createDoubleBinding(() -> Math.IEEEremainder(f1.get(), f2.get()), (Observable[])new Observable[]{f1, f2});
    }

    public static DoubleBinding IEEEremainder(double f1, ObservableDoubleValue f2) {
        return Bindings.createDoubleBinding(() -> Math.IEEEremainder(f1, f2.get()), (Observable[])new Observable[]{f2});
    }

    public static DoubleBinding IEEEremainder(ObservableDoubleValue f1, double f2) {
        return Bindings.createDoubleBinding(() -> Math.IEEEremainder(f1.get(), f2), (Observable[])new Observable[]{f1});
    }

    public static IntegerBinding incrementExact(ObservableIntegerValue a) {
        return Bindings.createIntegerBinding(() -> Math.incrementExact(a.get()), (Observable[])new Observable[]{a});
    }

    public static LongBinding incrementExact(ObservableLongValue a) {
        return Bindings.createLongBinding(() -> Math.incrementExact(a.get()), (Observable[])new Observable[]{a});
    }

    public static DoubleBinding log(ObservableDoubleValue a) {
        return Bindings.createDoubleBinding(() -> Math.log(a.get()), (Observable[])new Observable[]{a});
    }

    public static DoubleBinding log10(ObservableDoubleValue a) {
        return Bindings.createDoubleBinding(() -> Math.log10(a.get()), (Observable[])new Observable[]{a});
    }

    public static DoubleBinding log1p(ObservableDoubleValue x) {
        return Bindings.createDoubleBinding(() -> Math.log1p(x.get()), (Observable[])new Observable[]{x});
    }

    public static DoubleBinding max(ObservableDoubleValue a, ObservableDoubleValue b) {
        return Bindings.createDoubleBinding(() -> Math.max(a.get(), b.get()), (Observable[])new Observable[]{a, b});
    }

    public static DoubleBinding max(double a, ObservableDoubleValue b) {
        return Bindings.createDoubleBinding(() -> Math.max(a, b.get()), (Observable[])new Observable[]{b});
    }

    public static DoubleBinding max(ObservableDoubleValue a, double b) {
        return Bindings.createDoubleBinding(() -> Math.max(a.get(), b), (Observable[])new Observable[]{a});
    }

    public static FloatBinding max(ObservableFloatValue a, ObservableFloatValue b) {
        return Bindings.createFloatBinding(() -> Float.valueOf(Math.max(a.get(), b.get())), (Observable[])new Observable[]{a, b});
    }

    public static FloatBinding max(float a, ObservableFloatValue b) {
        return Bindings.createFloatBinding(() -> Float.valueOf(Math.max(a, b.get())), (Observable[])new Observable[]{b});
    }

    public static FloatBinding max(ObservableFloatValue a, float b) {
        return Bindings.createFloatBinding(() -> Float.valueOf(Math.max(a.get(), b)), (Observable[])new Observable[]{a});
    }

    public static IntegerBinding max(ObservableIntegerValue a, ObservableIntegerValue b) {
        return Bindings.createIntegerBinding(() -> Math.max(a.get(), b.get()), (Observable[])new Observable[]{a, b});
    }

    public static IntegerBinding max(int a, ObservableIntegerValue b) {
        return Bindings.createIntegerBinding(() -> Math.max(a, b.get()), (Observable[])new Observable[]{b});
    }

    public static IntegerBinding max(ObservableIntegerValue a, int b) {
        return Bindings.createIntegerBinding(() -> Math.max(a.get(), b), (Observable[])new Observable[]{a});
    }

    public static LongBinding max(ObservableLongValue a, ObservableLongValue b) {
        return Bindings.createLongBinding(() -> Math.max(a.get(), b.get()), (Observable[])new Observable[]{a, b});
    }

    public static LongBinding max(long a, ObservableLongValue b) {
        return Bindings.createLongBinding(() -> Math.max(a, b.get()), (Observable[])new Observable[]{b});
    }

    public static LongBinding max(ObservableLongValue a, long b) {
        return Bindings.createLongBinding(() -> Math.max(a.get(), b), (Observable[])new Observable[]{a});
    }

    public static DoubleBinding min(ObservableDoubleValue a, ObservableDoubleValue b) {
        return Bindings.createDoubleBinding(() -> Math.min(a.get(), b.get()), (Observable[])new Observable[]{a, b});
    }

    public static DoubleBinding min(double a, ObservableDoubleValue b) {
        return Bindings.createDoubleBinding(() -> Math.min(a, b.get()), (Observable[])new Observable[]{b});
    }

    public static DoubleBinding min(ObservableDoubleValue a, double b) {
        return Bindings.createDoubleBinding(() -> Math.min(a.get(), b), (Observable[])new Observable[]{a});
    }

    public static FloatBinding min(ObservableFloatValue a, ObservableFloatValue b) {
        return Bindings.createFloatBinding(() -> Float.valueOf(Math.min(a.get(), b.get())), (Observable[])new Observable[]{a, b});
    }

    public static FloatBinding min(float a, ObservableFloatValue b) {
        return Bindings.createFloatBinding(() -> Float.valueOf(Math.min(a, b.get())), (Observable[])new Observable[]{b});
    }

    public static FloatBinding min(ObservableFloatValue a, float b) {
        return Bindings.createFloatBinding(() -> Float.valueOf(Math.min(a.get(), b)), (Observable[])new Observable[]{a});
    }

    public static IntegerBinding min(ObservableIntegerValue a, ObservableIntegerValue b) {
        return Bindings.createIntegerBinding(() -> Math.min(a.get(), b.get()), (Observable[])new Observable[]{a, b});
    }

    public static IntegerBinding min(int a, ObservableIntegerValue b) {
        return Bindings.createIntegerBinding(() -> Math.min(a, b.get()), (Observable[])new Observable[]{b});
    }

    public static IntegerBinding min(ObservableIntegerValue a, int b) {
        return Bindings.createIntegerBinding(() -> Math.min(a.get(), b), (Observable[])new Observable[]{a});
    }

    public static LongBinding min(ObservableLongValue a, ObservableLongValue b) {
        return Bindings.createLongBinding(() -> Math.min(a.get(), b.get()), (Observable[])new Observable[]{a, b});
    }

    public static LongBinding min(long a, ObservableLongValue b) {
        return Bindings.createLongBinding(() -> Math.min(a, b.get()), (Observable[])new Observable[]{b});
    }

    public static LongBinding min(ObservableLongValue a, long b) {
        return Bindings.createLongBinding(() -> Math.min(a.get(), b), (Observable[])new Observable[]{a});
    }

    public static IntegerBinding multiplyExact(ObservableIntegerValue x, ObservableIntegerValue y) {
        return Bindings.createIntegerBinding(() -> Math.multiplyExact(x.get(), y.get()), (Observable[])new Observable[]{x, y});
    }

    public static IntegerBinding multiplyExact(int x, ObservableIntegerValue y) {
        return Bindings.createIntegerBinding(() -> Math.multiplyExact(x, y.get()), (Observable[])new Observable[]{y});
    }

    public static IntegerBinding multiplyExact(ObservableIntegerValue x, int y) {
        return Bindings.createIntegerBinding(() -> Math.multiplyExact(x.get(), y), (Observable[])new Observable[]{x});
    }

    public static LongBinding multiplyExact(ObservableLongValue x, ObservableLongValue y) {
        return Bindings.createLongBinding(() -> Math.multiplyExact(x.get(), y.get()), (Observable[])new Observable[]{x, y});
    }

    public static LongBinding multiplyExact(long x, ObservableLongValue y) {
        return Bindings.createLongBinding(() -> Math.multiplyExact(x, y.get()), (Observable[])new Observable[]{y});
    }

    public static LongBinding multiplyExact(ObservableLongValue x, long y) {
        return Bindings.createLongBinding(() -> Math.multiplyExact(x.get(), y), (Observable[])new Observable[]{x});
    }

    public static IntegerBinding negateExact(ObservableIntegerValue a) {
        return Bindings.createIntegerBinding(() -> Math.negateExact(a.get()), (Observable[])new Observable[]{a});
    }

    public static LongBinding negateExact(ObservableLongValue a) {
        return Bindings.createLongBinding(() -> Math.negateExact(a.get()), (Observable[])new Observable[]{a});
    }

    public static DoubleBinding nextAfter(ObservableDoubleValue start, ObservableDoubleValue direction) {
        return Bindings.createDoubleBinding(() -> Math.nextAfter(start.get(), direction.get()), (Observable[])new Observable[]{start, direction});
    }

    public static DoubleBinding nextAfter(double start, ObservableDoubleValue direction) {
        return Bindings.createDoubleBinding(() -> Math.nextAfter(start, direction.get()), (Observable[])new Observable[]{direction});
    }

    public static DoubleBinding nextAfter(ObservableDoubleValue start, double direction) {
        return Bindings.createDoubleBinding(() -> Math.nextAfter(start.get(), direction), (Observable[])new Observable[]{start});
    }

    public static FloatBinding nextAfter(ObservableFloatValue start, ObservableFloatValue direction) {
        return Bindings.createFloatBinding(() -> Float.valueOf(Math.nextAfter(start.get(), (double)direction.get())), (Observable[])new Observable[]{start, direction});
    }

    public static FloatBinding nextAfter(float start, ObservableFloatValue direction) {
        return Bindings.createFloatBinding(() -> Float.valueOf(Math.nextAfter(start, (double)direction.get())), (Observable[])new Observable[]{direction});
    }

    public static FloatBinding nextAfter(ObservableFloatValue start, float direction) {
        return Bindings.createFloatBinding(() -> Float.valueOf(Math.nextAfter(start.get(), (double)direction)), (Observable[])new Observable[]{start});
    }

    public static DoubleBinding nextDown(ObservableDoubleValue d) {
        return Bindings.createDoubleBinding(() -> Math.nextDown(d.get()), (Observable[])new Observable[]{d});
    }

    public static FloatBinding nextDown(ObservableFloatValue f) {
        return Bindings.createFloatBinding(() -> Float.valueOf(Math.nextDown(f.get())), (Observable[])new Observable[]{f});
    }

    public static DoubleBinding nextUp(ObservableDoubleValue d) {
        return Bindings.createDoubleBinding(() -> Math.nextUp(d.get()), (Observable[])new Observable[]{d});
    }

    public static FloatBinding nextUp(ObservableFloatValue f) {
        return Bindings.createFloatBinding(() -> Float.valueOf(Math.nextUp(f.get())), (Observable[])new Observable[]{f});
    }

    public static DoubleBinding pow(ObservableDoubleValue a, ObservableDoubleValue b) {
        return Bindings.createDoubleBinding(() -> Math.pow(a.get(), b.get()), (Observable[])new Observable[]{a, b});
    }

    public static DoubleBinding pow(double a, ObservableDoubleValue b) {
        return Bindings.createDoubleBinding(() -> Math.pow(a, b.get()), (Observable[])new Observable[]{b});
    }

    public static DoubleBinding pow(ObservableDoubleValue a, double b) {
        return Bindings.createDoubleBinding(() -> Math.pow(a.get(), b), (Observable[])new Observable[]{a});
    }

    public static DoubleBinding rint(ObservableDoubleValue a) {
        return Bindings.createDoubleBinding(() -> Math.rint(a.get()), (Observable[])new Observable[]{a});
    }

    public static LongBinding round(ObservableDoubleValue a) {
        return Bindings.createLongBinding(() -> Math.round(a.get()), (Observable[])new Observable[]{a});
    }

    public static IntegerBinding round(ObservableFloatValue a) {
        return Bindings.createIntegerBinding(() -> Math.round(a.get()), (Observable[])new Observable[]{a});
    }

    public static DoubleBinding scalb(ObservableDoubleValue d, ObservableIntegerValue scaleFactor) {
        return Bindings.createDoubleBinding(() -> Math.scalb(d.get(), scaleFactor.get()), (Observable[])new Observable[]{d, scaleFactor});
    }

    public static DoubleBinding scalb(double d, ObservableIntegerValue scaleFactor) {
        return Bindings.createDoubleBinding(() -> Math.scalb(d, scaleFactor.get()), (Observable[])new Observable[]{scaleFactor});
    }

    public static DoubleBinding scalb(ObservableDoubleValue d, int scaleFactor) {
        return Bindings.createDoubleBinding(() -> Math.scalb(d.get(), scaleFactor), (Observable[])new Observable[]{d});
    }

    public static FloatBinding scalb(ObservableFloatValue f, ObservableIntegerValue scaleFactor) {
        return Bindings.createFloatBinding(() -> Float.valueOf(Math.scalb(f.get(), scaleFactor.get())), (Observable[])new Observable[]{f, scaleFactor});
    }

    public static FloatBinding scalb(float f, ObservableIntegerValue scaleFactor) {
        return Bindings.createFloatBinding(() -> Float.valueOf(Math.scalb(f, scaleFactor.get())), (Observable[])new Observable[]{scaleFactor});
    }

    public static FloatBinding scalb(ObservableFloatValue f, int scaleFactor) {
        return Bindings.createFloatBinding(() -> Float.valueOf(Math.scalb(f.get(), scaleFactor)), (Observable[])new Observable[]{f});
    }

    public static DoubleBinding signum(ObservableDoubleValue d) {
        return Bindings.createDoubleBinding(() -> Math.signum(d.get()), (Observable[])new Observable[]{d});
    }

    public static FloatBinding signum(ObservableFloatValue f) {
        return Bindings.createFloatBinding(() -> Float.valueOf(Math.signum(f.get())), (Observable[])new Observable[]{f});
    }

    public static DoubleBinding sin(ObservableDoubleValue a) {
        return Bindings.createDoubleBinding(() -> Math.sin(a.get()), (Observable[])new Observable[]{a});
    }

    public static DoubleBinding sinh(ObservableDoubleValue x) {
        return Bindings.createDoubleBinding(() -> Math.sinh(x.get()), (Observable[])new Observable[]{x});
    }

    public static DoubleBinding sqrt(ObservableDoubleValue a) {
        return Bindings.createDoubleBinding(() -> Math.sqrt(a.get()), (Observable[])new Observable[]{a});
    }

    public static IntegerBinding subtractExact(ObservableIntegerValue x, ObservableIntegerValue y) {
        return Bindings.createIntegerBinding(() -> Math.subtractExact(x.get(), y.get()), (Observable[])new Observable[]{x, y});
    }

    public static IntegerBinding subtractExact(int x, ObservableIntegerValue y) {
        return Bindings.createIntegerBinding(() -> Math.subtractExact(x, y.get()), (Observable[])new Observable[]{y});
    }

    public static IntegerBinding subtractExact(ObservableIntegerValue x, int y) {
        return Bindings.createIntegerBinding(() -> Math.subtractExact(x.get(), y), (Observable[])new Observable[]{x});
    }

    public static LongBinding subtractExact(ObservableLongValue x, ObservableLongValue y) {
        return Bindings.createLongBinding(() -> Math.subtractExact(x.get(), y.get()), (Observable[])new Observable[]{x, y});
    }

    public static LongBinding subtractExact(long x, ObservableLongValue y) {
        return Bindings.createLongBinding(() -> Math.subtractExact(x, y.get()), (Observable[])new Observable[]{y});
    }

    public static LongBinding subtractExact(ObservableLongValue x, long y) {
        return Bindings.createLongBinding(() -> Math.subtractExact(x.get(), y), (Observable[])new Observable[]{x});
    }

    public static DoubleBinding tan(ObservableDoubleValue a) {
        return Bindings.createDoubleBinding(() -> Math.tan(a.get()), (Observable[])new Observable[]{a});
    }

    public static DoubleBinding tanh(ObservableDoubleValue x) {
        return Bindings.createDoubleBinding(() -> Math.tanh(x.get()), (Observable[])new Observable[]{x});
    }

    public static DoubleBinding toDegrees(ObservableDoubleValue angrad) {
        return Bindings.createDoubleBinding(() -> Math.toDegrees(angrad.get()), (Observable[])new Observable[]{angrad});
    }

    public static IntegerBinding toIntExact(ObservableLongValue value) {
        return Bindings.createIntegerBinding(() -> Math.toIntExact(value.get()), (Observable[])new Observable[]{value});
    }

    public static DoubleBinding toRadians(ObservableDoubleValue angdeg) {
        return Bindings.createDoubleBinding(() -> Math.toRadians(angdeg.get()), (Observable[])new Observable[]{angdeg});
    }

    public static DoubleBinding ulp(ObservableDoubleValue d) {
        return Bindings.createDoubleBinding(() -> Math.ulp(d.get()), (Observable[])new Observable[]{d});
    }

    public static FloatBinding ulp(ObservableFloatValue f) {
        return Bindings.createFloatBinding(() -> Float.valueOf(Math.ulp(f.get())), (Observable[])new Observable[]{f});
    }
}

