/*
 * Decompiled with CFR 0.152.
 */
package lspace.codec;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import lspace.NS;
import lspace.codec.ActiveContext;
import lspace.codec.ActiveProperty;
import lspace.codec.JsonInProgress;
import lspace.codec.JsonObjectInProgress;
import lspace.codec.exception.ToJsonException;
import lspace.librarian.datatype.BoolType;
import lspace.librarian.datatype.CalendarType;
import lspace.librarian.datatype.CollectionType;
import lspace.librarian.datatype.DataType;
import lspace.librarian.datatype.DateTimeType;
import lspace.librarian.datatype.DoubleType;
import lspace.librarian.datatype.DurationType;
import lspace.librarian.datatype.GeometricType;
import lspace.librarian.datatype.IntType;
import lspace.librarian.datatype.ListSetType;
import lspace.librarian.datatype.ListType;
import lspace.librarian.datatype.LiteralType;
import lspace.librarian.datatype.LocalDateType;
import lspace.librarian.datatype.LocalTimeType;
import lspace.librarian.datatype.LongType;
import lspace.librarian.datatype.MapType;
import lspace.librarian.datatype.NumericType;
import lspace.librarian.datatype.QuantityType;
import lspace.librarian.datatype.SetType;
import lspace.librarian.datatype.StructuredType;
import lspace.librarian.datatype.TextType;
import lspace.librarian.datatype.Tuple2Type;
import lspace.librarian.datatype.Tuple3Type;
import lspace.librarian.datatype.Tuple4Type;
import lspace.librarian.datatype.TupleType;
import lspace.librarian.datatype.VectorType;
import lspace.librarian.structure.ClassType;
import lspace.librarian.structure.ClassType$;
import lspace.librarian.structure.Edge;
import lspace.librarian.structure.IriResource;
import lspace.librarian.structure.Node;
import lspace.librarian.structure.Ontology;
import lspace.librarian.structure.Property;
import lspace.librarian.structure.PropertyDef;
import lspace.librarian.structure.PropertyDef$;
import lspace.librarian.structure.Value;
import lspace.types.vector.Geometry;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.ListSet;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import squants.time.Time;

@ScalaSignature(bytes="\u0006\u0001\u0011\rhaB\u001d;!\u0003\r\ta\u0010\u0005\u0006\u000f\u0002!\t\u0001S\u0003\u0005\u0019\u0002\u0001Q*\u0002\u0003`\u0001\u0001\u0001W\u0001B2\u0001\u0001\u0011,Aa\u001a\u0001\u0001Q\")1\u000e\u0001D\u0001Y\")q\u000e\u0001D\u0001a\")!\u000f\u0001D\u0002g\")a\u000f\u0001D\u0002o\"9\u00111\u0002\u0001\u0007\u0004\u00055\u0001bBA\r\u0001\u0019\r\u00111\u0004\u0005\b\u0003O\u0001a1AA\u0015\u0011\u001d\t)\u0004\u0001D\u0002\u0003oAq!a\u0011\u0001\r\u0007\t)\u0005C\u0004\u0002\\\u00011\u0019!!\u0018\t\u000f\u0005%\u0004Ab\u0001\u0002l!9\u0011q\u000e\u0001\u0007\u0004\u0005E\u0004bBAE\u0001\u0019\r\u00111\u0012\u0005\b\u0003/\u0003a1AAM\u0011\u001d\t\u0019\u000b\u0001D\u0002\u0003KCq!a,\u0001\r\u0007\t\t\fC\u0004\u00028\u00021\t!!/\u0007\r\u0005]\u0007!AAm\u0011%\tYn\u0006B\u0001B\u0003%!\u0010C\u0005\u0002^^\u0011\t\u0011)A\u0006[\"9\u0011q\\\f\u0005\u0002\u0005\u0005\bBCAv/!\u0015\r\u0011\"\u0001\u0002n\"I\u0011q\u001e\u0001\u0002\u0002\u0013\r\u0011\u0011\u001f\u0005\b\u0003s\u0004a\u0011AA~\u0011\u001d\u0011)\u0001\u0001D\u0001\u0005\u000fAqAa\r\u0001\t#\u0011)\u0004C\u0004\u0003P\u0001!IA!\u0015\t\u000f\t%\u0004A\"\u0001\u0003l!9!1\u0011\u0001\u0005\u0002\t\u0015\u0005b\u0002BT\u0001\u0011\u0005!\u0011\u0016\u0005\b\u0005\u0003\u0004A\u0011\u0001Bb\u0011\u001d\u0011Y\u000e\u0001C\u0001\u0005;DqA!>\u0001\t\u0003\u00119\u0010C\u0004\u0004\u0010\u0001!\ta!\u0005\t\u000f\r%\u0002\u0001\"\u0001\u0004,!911\t\u0001\u0005\u0002\r\u0015\u0003bBB/\u0001\u0011\u00051q\f\u0005\b\u0007o\u0002A\u0011AB=\u0011\u001d\u0019\t\n\u0001C\u0001\u0007'Cqaa+\u0001\t\u0003\u0019i\u000bC\u0004\u0004F\u0002!Iaa2\t\u000f\r]\b\u0001\"\u0001\u0004z\"9A\u0011\u0003\u0001\u0005\u0002\u0011M\u0001b\u0002C\u0016\u0001\u0011\u0005AQ\u0006\u0005\b\t\u000b\u0002A\u0011\u0001C$\u0011\u001d!y\u0006\u0001C\u0001\tCB\u0011\u0002b\u001e\u0001#\u0003%\t\u0001\"\u001f\t\u000f\u0011e\u0005\u0001\"\u0001\u0005\u001c\"9A1\u0016\u0001\u0005\u0002\u00115\u0006b\u0002C[\u0001\u0011\u0005Aq\u0017\u0005\b\t\u0017\u0004A\u0011\u0001Cg\u0005\u0019)enY8eK*\u00111\bP\u0001\u0006G>$Wm\u0019\u0006\u0002{\u00051An\u001d9bG\u0016\u001c\u0001!F\u0002A'v\u001b\"\u0001A!\u0011\u0005\t+U\"A\"\u000b\u0003\u0011\u000bQa]2bY\u0006L!AR\"\u0003\r\u0005s\u0017PU3g\u0003\u0019!\u0013N\\5uIQ\t\u0011\n\u0005\u0002C\u0015&\u00111j\u0011\u0002\u0005+:LGO\u0001\u0002B\u0007B!ajT)]\u001b\u0005Q\u0014B\u0001);\u00055\t5\r^5wK\u000e{g\u000e^3yiB\u0011!k\u0015\u0007\u0001\t\u0015!\u0006A1\u0001V\u0005\u0011Q5o\u001c8\u0012\u0005YK\u0006C\u0001\"X\u0013\tA6IA\u0004O_RD\u0017N\\4\u0011\u0005\tS\u0016BA.D\u0005\r\te.\u001f\t\u0003%v#QA\u0018\u0001C\u0002U\u0013!BS:p]>\u0013'.Z2u\u0005\t\t\u0005\u000b\u0005\u0003OCFc\u0016B\u00012;\u00059\t5\r^5wKB\u0013x\u000e]3sif\u0014AAS(J!B!a*Z)]\u0013\t1'H\u0001\u000bKg>twJ\u00196fGRLe\u000e\u0015:pOJ,7o\u001d\u0002\u0004\u0015&\u0003\u0006\u0003\u0002(j#rK!A\u001b\u001e\u0003\u001d)\u001bxN\\%o!J|wM]3tg\u0006\u0019r-\u001a;OK^\f5\r^5wK\u000e{g\u000e^3yiV\tQ\u000e\u0005\u0002o\u00055\t\u0001!\u0001\u000bhKRtUm^!di&4X\r\u0015:pa\u0016\u0014H/_\u000b\u0002cB\u0011anA\u0001\u0011UN|gn\u00142kK\u000e$Hk\u001c&t_:$\"!\u0015;\t\u000bUD\u0001\u0019\u0001/\u0002\t)\u001cxN\\\u0001\u000bi\u0016DH\u000fV8Kg>tGCA)y\u0011\u0015I\u0018\u00021\u0001{\u0003\u0011!X\r\u001f;\u0011\u0007m\f)AD\u0002}\u0003\u0003\u0001\"!`\"\u000e\u0003yT!a  \u0002\rq\u0012xn\u001c;?\u0013\r\t\u0019aQ\u0001\u0007!J,G-\u001a4\n\t\u0005\u001d\u0011\u0011\u0002\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\r1)\u0001\u0006c_>dGk\u001c&t_:$2!UA\b\u0011\u001d\t\tB\u0003a\u0001\u0003'\tqAY8pY\u0016\fg\u000eE\u0002C\u0003+I1!a\u0006D\u0005\u001d\u0011un\u001c7fC:\f\u0011\"\u001b8u)>T5o\u001c8\u0015\u0007E\u000bi\u0002C\u0004\u0002 -\u0001\r!!\t\u0002\u0007%tG\u000fE\u0002C\u0003GI1!!\nD\u0005\rIe\u000e^\u0001\rI>,(\r\\3U_*\u001bxN\u001c\u000b\u0004#\u0006-\u0002bBA\u0017\u0019\u0001\u0007\u0011qF\u0001\u0007I>,(\r\\3\u0011\u0007\t\u000b\t$C\u0002\u00024\r\u0013a\u0001R8vE2,\u0017A\u00037p]\u001e$vNS:p]R\u0019\u0011+!\u000f\t\u000f\u0005mR\u00021\u0001\u0002>\u0005!An\u001c8h!\r\u0011\u0015qH\u0005\u0004\u0003\u0003\u001a%\u0001\u0002'p]\u001e\f\u0011bZ3p)>T5o\u001c8\u0015\u0007E\u000b9\u0005C\u0004\u0002J9\u0001\r!a\u0013\u0002\u0007\u001d,w\u000e\u0005\u0003\u0002N\u0005]SBAA(\u0015\u0011\t\t&a\u0015\u0002\rY,7\r^8s\u0015\r\t)\u0006P\u0001\u0006if\u0004Xm]\u0005\u0005\u00033\nyE\u0001\u0005HK>lW\r\u001e:z\u0003%i\u0017\r\u001d+p\u0015N|g\u000eF\u0002R\u0003?Bq!!\u0019\u0010\u0001\u0004\t\u0019'A\u0002nCB\u0004Ra_A3uFKA!a\u001a\u0002\n\t\u0019Q*\u00199\u0002\u001f5\f\u0007\u000fV8Kg>twJ\u00196fGR$2\u0001XA7\u0011\u001d\t\t\u0007\u0005a\u0001\u0003G\n!\u0002\\5tiR{'j]8o)\r\t\u00161\u000f\u0005\b\u0003k\n\u0002\u0019AA<\u0003\u0011a\u0017n\u001d;\u0011\u000b\u0005e\u00141Q)\u000f\t\u0005m\u0014q\u0010\b\u0004{\u0006u\u0014\"\u0001#\n\u0007\u0005\u00055)A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0015\u0015q\u0011\u0002\u0005\u0019&\u001cHOC\u0002\u0002\u0002\u000e\u000bA\u0002^;qY\u0016\u0014Dk\u001c&t_:$2!UAG\u0011\u001d\tyI\u0005a\u0001\u0003#\u000ba\u0001^;qY\u0016\u001c\b#\u0002\"\u0002\u0014F\u000b\u0016bAAK\u0007\n1A+\u001e9mKJ\nA\u0002^;qY\u0016\u001cDk\u001c&t_:$2!UAN\u0011\u001d\tyi\u0005a\u0001\u0003;\u0003bAQAP#F\u000b\u0016bAAQ\u0007\n1A+\u001e9mKN\nA\u0002^;qY\u0016$Dk\u001c&t_:$2!UAT\u0011\u001d\ty\t\u0006a\u0001\u0003S\u0003rAQAV#F\u000b\u0016+C\u0002\u0002.\u000e\u0013a\u0001V;qY\u0016$\u0014\u0001\u0005;va2,'\u0007T5tiR{'j]8o)\r\t\u00161\u0017\u0005\b\u0003\u001f+\u0002\u0019AA[!\u0019\tI(a!\u0002\u0012\u0006)\u0011\r\u001d9msV!\u00111XAi)\rQ\u0018Q\u0018\u0005\b\u0003\u007f3\u0002\u0019AAa\u0003\u0011qw\u000eZ3\u0011\t\u0005\r\u0017QZ\u0007\u0003\u0003\u000bTA!a2\u0002J\u0006I1\u000f\u001e:vGR,(/\u001a\u0006\u0004\u0003\u0017d\u0014!\u00037jEJ\f'/[1o\u0013\u0011\ty-!2\u0003\t9{G-\u001a\u0003\b\u0003'4\"\u0019AAk\u0005\u0005!\u0016c\u0001,\u0002B\niq+\u001b;i\u0013JL7\u000b\u001e:j]\u001e\u001c\"aF!\u0002\u0007%\u0014\u0018.A\u0007bGRLg/Z\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u0005\r\u0018\u0011\u001e\u000b\u0005\u0003K\f9\u000f\u0005\u0002o/!1\u0011Q\u001c\u000eA\u00045Da!a7\u001b\u0001\u0004Q\u0018aB2p[B\f7\r^\u000b\u0002u\u0006iq+\u001b;i\u0013JL7\u000b\u001e:j]\u001e$B!a=\u0002xR!\u0011Q]A{\u0011\u0019\ti\u000e\ba\u0002[\"1\u00111\u001c\u000fA\u0002i\f\u0001B\u001a:p[:{G-\u001a\u000b\u0005\u0003{\u0014\u0019\u0001\u0006\u0003\u0002\u0000\n\u0005\u0001C\u00018\u0005\u0011\u0019\ti.\ba\u0002[\"9\u0011qX\u000fA\u0002\u0005\u0005\u0017!\u00034s_6,EmZ3t)\u0019\u0011IAa\u0004\u0003\u001aQ!!1\u0002B\u0007!\tqW\u0001\u0003\u0004\u0002^z\u0001\u001d!\u001c\u0005\b\u0005#q\u0002\u0019\u0001B\n\u0003\rYW-\u001f\t\u0005\u0003\u0007\u0014)\"\u0003\u0003\u0003\u0018\u0005\u0015'\u0001\u0003)s_B,'\u000f^=\t\u000f\tma\u00041\u0001\u0003\u001e\u0005)Q\rZ4fgB1\u0011\u0011PAB\u0005?\u0001dA!\t\u0003*\t=\u0002\u0003CAb\u0005G\u00119C!\f\n\t\t\u0015\u0012Q\u0019\u0002\u0005\u000b\u0012<W\rE\u0002S\u0005S!1Ba\u000b\u0003\u001a\u0005\u0005\t\u0011!B\u0001+\n\u0019q\fJ\u0019\u0011\u0007I\u0013y\u0003B\u0006\u00032\te\u0011\u0011!A\u0001\u0006\u0003)&aA0%e\u0005iQ\rZ4f\u0013:4Fk\u001c&t_:,BAa\u000e\u0003NQ!!\u0011\bB\u001f)\u0011\u0011YAa\u000f\t\r\u0005uw\u0004q\u0001n\u0011\u001d\u0011yd\ba\u0001\u0005\u0003\nA!\u001a3hKB\"!1\tB$!!\t\u0019Ma\t\u0003F\t-\u0003c\u0001*\u0003H\u0011Y!\u0011\nB\u001f\u0003\u0003\u0005\tQ!\u0001V\u0005\ryFe\r\t\u0004%\n5CABAj?\t\u0007Q+\u0001\bfI\u001e,w*\u001e;W)>T5o\u001c8\u0016\t\tM#q\r\u000b\u0005\u0005+\u0012I\u0006\u0006\u0003\u0003\f\t]\u0003BBAoA\u0001\u000fQ\u000eC\u0004\u0003@\u0001\u0002\rAa\u00171\t\tu#\u0011\r\t\t\u0003\u0007\u0014\u0019Ca\u0018\u0003fA\u0019!K!\u0019\u0005\u0017\t\r$\u0011LA\u0001\u0002\u0003\u0015\t!\u0016\u0002\u0004?\u0012\"\u0004c\u0001*\u0003h\u00111\u00111\u001b\u0011C\u0002U\u000b\u0001B\u001a:p[\u0016#w-\u001a\u000b\u0005\u0005[\u0012\t\b\u0006\u0003\u0002\u0000\n=\u0004BBAoC\u0001\u000fQ\u000eC\u0004\u0003@\u0005\u0002\rAa\u001d1\r\tU$\u0011\u0010B@!!\t\u0019Ma\t\u0003x\tu\u0004c\u0001*\u0003z\u0011Y!1\u0010B9\u0003\u0003\u0005\tQ!\u0001V\u0005\ryF%\u000e\t\u0004%\n}Da\u0003BA\u0005c\n\t\u0011!A\u0003\u0002U\u00131a\u0018\u00137\u0003!1'o\\7ECR\fGC\u0002BD\u0005\u0017\u0013y\t\u0006\u0003\u0003\f\t%\u0005BBAoE\u0001\u000fQ\u000e\u0003\u0004\u0003\u000e\n\u0002\r!W\u0001\u0006m\u0006dW/\u001a\u0005\b\u0005#\u0013\u0003\u0019\u0001BJ\u00031)\u0007\u0010]3di\u0016$G+\u001f9fa\u0011\u0011)Ja)\u0011\r\t]%Q\u0014BQ\u001b\t\u0011IJ\u0003\u0003\u0003\u001c\u0006%\u0017\u0001\u00033bi\u0006$\u0018\u0010]3\n\t\t}%\u0011\u0014\u0002\t\t\u0006$\u0018\rV=qKB\u0019!Ka)\u0005\u0017\t\u0015&qRA\u0001\u0002\u0003\u0015\t!\u0016\u0002\u0004?\u0012:\u0014a\u00034s_6d\u0015\u000e^3sC2$bAa+\u00030\nEF\u0003\u0002B\u0006\u0005[Ca!!8$\u0001\bi\u0007B\u0002BGG\u0001\u0007\u0011\fC\u0004\u0003\u0012\u000e\u0002\rAa-1\t\tU&Q\u0018\t\u0007\u0005/\u00139La/\n\t\te&\u0011\u0014\u0002\f\u0019&$XM]1m)f\u0004X\rE\u0002S\u0005{#1Ba0\u00032\u0006\u0005\t\u0011!B\u0001+\n\u0019q\f\n\u001d\u0002\u0019\u0019\u0014x.\\\"bY\u0016tG-\u0019:\u0015\r\t\u0015'\u0011\u001aBf)\u0011\u0011YAa2\t\r\u0005uG\u0005q\u0001n\u0011\u0019\u0011i\t\na\u00013\"9!\u0011\u0013\u0013A\u0002\t5\u0007\u0007\u0002Bh\u0005/\u0004bAa&\u0003R\nU\u0017\u0002\u0002Bj\u00053\u0013AbQ1mK:$\u0017M\u001d+za\u0016\u00042A\u0015Bl\t-\u0011INa3\u0002\u0002\u0003\u0005)\u0011A+\u0003\u0007}#\u0013(\u0001\u0007ge>lG)\u0019;f)&lW\r\u0006\u0004\u0003`\n\r(Q\u001d\u000b\u0005\u0005\u0017\u0011\t\u000f\u0003\u0004\u0002^\u0016\u0002\u001d!\u001c\u0005\u0007\u0005\u001b+\u0003\u0019A-\t\u000f\tEU\u00051\u0001\u0003hB\"!\u0011\u001eBy!\u0019\u00119Ja;\u0003p&!!Q\u001eBM\u00051!\u0015\r^3US6,G+\u001f9f!\r\u0011&\u0011\u001f\u0003\f\u0005g\u0014)/!A\u0001\u0002\u000b\u0005QK\u0001\u0003`IE\u0002\u0014\u0001\u00034s_6$\u0015\r^3\u0015\r\te(Q B\u0000)\u0011\u0011YAa?\t\r\u0005ug\u0005q\u0001n\u0011\u0019\u0011iI\na\u00013\"9!\u0011\u0013\u0014A\u0002\r\u0005\u0001\u0007BB\u0002\u0007\u0017\u0001bAa&\u0004\u0006\r%\u0011\u0002BB\u0004\u00053\u0013Q\u0002T8dC2$\u0015\r^3UsB,\u0007c\u0001*\u0004\f\u0011Y1Q\u0002B\u0000\u0003\u0003\u0005\tQ!\u0001V\u0005\u0011yF%M\u0019\u0002\u0011\u0019\u0014x.\u001c+j[\u0016$baa\u0005\u0004\u0018\reA\u0003\u0002B\u0006\u0007+Aa!!8(\u0001\bi\u0007B\u0002BGO\u0001\u0007\u0011\fC\u0004\u0003\u0012\u001e\u0002\raa\u00071\t\ru1Q\u0005\t\u0007\u0005/\u001byba\t\n\t\r\u0005\"\u0011\u0014\u0002\u000e\u0019>\u001c\u0017\r\u001c+j[\u0016$\u0016\u0010]3\u0011\u0007I\u001b)\u0003B\u0006\u0004(\re\u0011\u0011!A\u0001\u0006\u0003)&\u0001B0%cI\n1B\u001a:p[:+X.\u001a:jGR11QFB\u0019\u0007g!BAa\u0003\u00040!1\u0011Q\u001c\u0015A\u00045DaA!$)\u0001\u0004I\u0006b\u0002BIQ\u0001\u00071Q\u0007\u0019\u0005\u0007o\u0019y\u0004\u0005\u0004\u0003\u0018\u000ee2QH\u0005\u0005\u0007w\u0011IJA\u0006Ok6,'/[2UsB,\u0007c\u0001*\u0004@\u0011Y1\u0011IB\u001a\u0003\u0003\u0005\tQ!\u0001V\u0005\u0011yF%M\u001a\u0002\u000f\u0019\u0014x.\\%oiR11qIB&\u0007\u001b\"BAa\u0003\u0004J!1\u0011Q\\\u0015A\u00045DaA!$*\u0001\u0004I\u0006b\u0002BIS\u0001\u00071q\n\u0019\u0005\u0007#\u001aI\u0006\u0005\u0004\u0003\u0018\u000eM3qK\u0005\u0005\u0007+\u0012IJA\u0004J]R$\u0016\u0010]3\u0011\u0007I\u001bI\u0006B\u0006\u0004\\\r5\u0013\u0011!A\u0001\u0006\u0003)&\u0001B0%cQ\n!B\u001a:p[\u0012{WO\u00197f)\u0019\u0019\tg!\u001a\u0004hQ!!1BB2\u0011\u0019\tiN\u000ba\u0002[\"1!Q\u0012\u0016A\u0002eCqA!%+\u0001\u0004\u0019I\u0007\r\u0003\u0004l\rM\u0004C\u0002BL\u0007[\u001a\t(\u0003\u0003\u0004p\te%A\u0003#pk\ndW\rV=qKB\u0019!ka\u001d\u0005\u0017\rU4qMA\u0001\u0002\u0003\u0015\t!\u0016\u0002\u0005?\u0012\nT'\u0001\u0005ge>lGj\u001c8h)\u0019\u0019Yha \u0004\u0002R!!1BB?\u0011\u0019\tin\u000ba\u0002[\"1!QR\u0016A\u0002eCqA!%,\u0001\u0004\u0019\u0019\t\r\u0003\u0004\u0006\u000e5\u0005C\u0002BL\u0007\u000f\u001bY)\u0003\u0003\u0004\n\ne%\u0001\u0003'p]\u001e$\u0016\u0010]3\u0011\u0007I\u001bi\tB\u0006\u0004\u0010\u000e\u0005\u0015\u0011!A\u0001\u0006\u0003)&\u0001B0%cY\n\u0001B\u001a:p[R+\u0007\u0010\u001e\u000b\u0007\u0007+\u001bIja'\u0015\t\t-1q\u0013\u0005\u0007\u0003;d\u00039A7\t\r\t5E\u00061\u0001Z\u0011\u001d\u0011\t\n\fa\u0001\u0007;\u0003Daa(\u0004(B1!qSBQ\u0007KKAaa)\u0003\u001a\nAA+\u001a=u)f\u0004X\rE\u0002S\u0007O#1b!+\u0004\u001c\u0006\u0005\t\u0011!B\u0001+\n!q\fJ\u00198\u000391'o\\7TiJ,8\r^;sK\u0012$baa,\u00044\u000eUF\u0003\u0002B\u0006\u0007cCa!!8.\u0001\bi\u0007B\u0002BG[\u0001\u0007\u0011\fC\u0004\u0003\u00126\u0002\raa.1\t\re6\u0011\u0019\t\u0007\u0005/\u001bYla0\n\t\ru&\u0011\u0014\u0002\u000f'R\u0014Xo\u0019;ve\u0016$G+\u001f9f!\r\u00116\u0011\u0019\u0003\f\u0007\u0007\u001c),!A\u0001\u0002\u000b\u0005QK\u0001\u0003`IEB\u0014a\u0002;p\u0003J\u0014\u0018-\u001f\u000b\u0007\u0007\u0013\u001cima8\u0015\t\t-11\u001a\u0005\u0007\u0003;t\u00039A7\t\u000f\r=g\u00061\u0001\u0004R\u0006\ta\u000f\r\u0003\u0004T\u000em\u0007CBA=\u0007+\u001cI.\u0003\u0003\u0004X\u0006\u001d%aA*fcB\u0019!ka7\u0005\u0017\ru7QZA\u0001\u0002\u0003\u0015\t!\u0016\u0002\u0005?\u0012\n\u0014\bC\u0004\u0004b:\u0002\raa9\u0002\u000b1\f'-\u001a7\u0011\u000b\t\u001b)o!;\n\u0007\r\u001d8I\u0001\u0004PaRLwN\u001c\u0019\u0005\u0007W\u001c\u0019\u0010\u0005\u0004\u0002D\u000e58\u0011_\u0005\u0005\u0007_\f)MA\u0005DY\u0006\u001c8\u000fV=qKB\u0019!ka=\u0005\u0017\rU8q\\A\u0001\u0002\u0003\u0015\t!\u0016\u0002\u0005?\u0012\u0012\u0004'\u0001\bge>l7i\u001c7mK\u000e$\u0018n\u001c8\u0015\r\rm8q C\u0001)\u0011\u0011Ya!@\t\r\u0005uw\u0006q\u0001n\u0011\u0019\u0011ii\fa\u00013\"9!\u0011S\u0018A\u0002\u0011\r\u0001\u0007\u0002C\u0003\t\u001b\u0001bAa&\u0005\b\u0011-\u0011\u0002\u0002C\u0005\u00053\u0013abQ8mY\u0016\u001cG/[8o)f\u0004X\rE\u0002S\t\u001b!1\u0002b\u0004\u0005\u0002\u0005\u0005\t\u0011!B\u0001+\n!q\f\n\u001a2\u000351'o\\7HK>lW\r\u001e:jGR1AQ\u0003C\r\t7!BAa\u0003\u0005\u0018!1\u0011Q\u001c\u0019A\u00045DaA!$1\u0001\u0004I\u0006b\u0002BIa\u0001\u0007AQ\u0004\u0019\u0005\t?!9\u0003\u0005\u0004\u0003\u0018\u0012\u0005BQE\u0005\u0005\tG\u0011IJA\u0007HK>lW\r\u001e:jGRK\b/\u001a\t\u0004%\u0012\u001dBa\u0003C\u0015\t7\t\t\u0011!A\u0003\u0002U\u0013Aa\u0018\u00133e\u0005aaM]8n#V\fg\u000e^5usR1Aq\u0006C\u001a\tk!BAa\u0003\u00052!1\u0011Q\\\u0019A\u00045DaA!$2\u0001\u0004I\u0006b\u0002BIc\u0001\u0007Aq\u0007\u0019\u0005\ts!\t\u0005\u0005\u0004\u0003\u0018\u0012mBqH\u0005\u0005\t{\u0011IJ\u0001\u0007Rk\u0006tG/\u001b;z)f\u0004X\rE\u0002S\t\u0003\"1\u0002b\u0011\u00056\u0005\u0005\t\u0011!B\u0001+\n!q\f\n\u001a4\u0003%1'o\\7UkBdW\r\u0006\u0004\u0005J\u00115Cq\n\u000b\u0005\u0005\u0017!Y\u0005\u0003\u0004\u0002^J\u0002\u001d!\u001c\u0005\u0007\u0005\u001b\u0013\u0004\u0019A-\t\u000f\tE%\u00071\u0001\u0005RA\"A1\u000bC.!\u0019\u00119\n\"\u0016\u0005Z%!Aq\u000bBM\u0005%!V\u000f\u001d7f)f\u0004X\rE\u0002S\t7\"1\u0002\"\u0018\u0005P\u0005\u0005\t\u0011!B\u0001+\n!q\f\n\u001a5\u0003\u001d1'o\\7B]f$b\u0001b\u0019\u0005h\u0011%D\u0003\u0002B\u0006\tKBa!!84\u0001\bi\u0007B\u0002BGg\u0001\u0007\u0011\fC\u0005\u0003\u0012N\u0002\n\u00111\u0001\u0005lA)!i!:\u0005nA\"Aq\u000eC:!\u0019\t\u0019m!<\u0005rA\u0019!\u000bb\u001d\u0005\u0017\u0011UD\u0011NA\u0001\u0002\u0003\u0015\t!\u0016\u0002\u0005?\u0012\u0012T'A\tge>l\u0017I\\=%I\u00164\u0017-\u001e7uII*\"\u0001b\u001f+\t\u0011uDq\u0011\t\u0006\u0005\u000e\u0015Hq\u0010\u0019\u0005\t\u0003#)\t\u0005\u0004\u0002D\u000e5H1\u0011\t\u0004%\u0012\u0015EA\u0003C;i\u0005\u0005\t\u0011!B\u0001+.\u0012A\u0011\u0012\t\u0005\t\u0017#)*\u0004\u0002\u0005\u000e*!Aq\u0012CI\u0003%)hn\u00195fG.,GMC\u0002\u0005\u0014\u000e\u000b!\"\u00198o_R\fG/[8o\u0013\u0011!9\n\"$\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0007ge>lwJ\u001c;pY><\u0017\u0010\u0006\u0003\u0005\u001e\u0012\u0005F\u0003BA\u0000\t?Ca!!86\u0001\bi\u0007b\u0002CRk\u0001\u0007AQU\u0001\t_:$x\u000e\\8hsB!\u00111\u0019CT\u0013\u0011!I+!2\u0003\u0011=sGo\u001c7pOf\fAB\u001a:p[B\u0013x\u000e]3sif$B\u0001b,\u00054R!\u0011q CY\u0011\u0019\tiN\u000ea\u0002[\"9!\u0011\u0003\u001cA\u0002\tM\u0011\u0001\u00044s_6$\u0015\r^1UsB,G\u0003\u0002C]\t{#B!a@\u0005<\"1\u0011Q\\\u001cA\u00045Dq\u0001b08\u0001\u0004!\t-\u0001\u0005eCR\fG+\u001f9fa\u0011!\u0019\rb2\u0011\r\t]%Q\u0014Cc!\r\u0011Fq\u0019\u0003\f\t\u0013$i,!A\u0001\u0002\u000b\u0005QK\u0001\u0003`II2\u0014\u0001D2u\u0019&\u001cH\u000fV8Kg>tG\u0003\u0002Ch\t'$BAa\u0003\u0005R\"1\u0011Q\u001c\u001dA\u00045Dq\u0001\"69\u0001\u0004!9.A\u0001m!\u0019\tI(a!\u0005ZB\"A1\u001cCp!\u0019\t\u0019m!<\u0005^B\u0019!\u000bb8\u0005\u0017\u0011\u0005H1[A\u0001\u0002\u0003\u0015\t!\u0016\u0002\u0005?\u0012\u0012t\u0007")
public interface Encode<Json, JsonObject> {
    public ActiveContext<Json, JsonObject> getNewActiveContext();

    public ActiveProperty<Json, JsonObject> getNewActiveProperty();

    public Json jsonObjectToJson(JsonObject var1);

    public Json textToJson(String var1);

    public Json boolToJson(boolean var1);

    public Json intToJson(int var1);

    public Json doubleToJson(double var1);

    public Json longToJson(long var1);

    public Json geoToJson(Geometry var1);

    public Json mapToJson(Map<String, Json> var1);

    public JsonObject mapToJsonObject(Map<String, Json> var1);

    public Json listToJson(List<Json> var1);

    public Json tuple2ToJson(Tuple2<Json, Json> var1);

    public Json tuple3ToJson(Tuple3<Json, Json, Json> var1);

    public Json tuple4ToJson(Tuple4<Json, Json, Json, Json> var1);

    public Json tuple2ListToJson(List<Tuple2<Json, Json>> var1);

    public <T extends Node> String apply(Node var1);

    public static /* synthetic */ WithIriString WithIriString$(Encode $this, String iri, ActiveContext activeContext) {
        return $this.WithIriString(iri, activeContext);
    }

    default public WithIriString WithIriString(String iri, ActiveContext<Json, JsonObject> activeContext) {
        return new WithIriString(this, iri, activeContext);
    }

    public JsonObjectInProgress<Json, JsonObject> fromNode(Node var1, ActiveContext<Json, JsonObject> var2);

    public JsonInProgress<Json, JsonObject> fromEdges(Property var1, List<Edge<?, ?>> var2, ActiveContext<Json, JsonObject> var3);

    public static /* synthetic */ JsonInProgress edgeInVToJson$(Encode $this, Edge edge, ActiveContext activeContext) {
        return $this.edgeInVToJson(edge, activeContext);
    }

    default public <T> JsonInProgress<Json, JsonObject> edgeInVToJson(Edge<?, T> edge, ActiveContext<Json, JsonObject> activeContext) {
        return this.fromAny(edge.inV(), activeContext.properties().get((Object)edge.key()).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.$attype().headOption()).orElse((Function0 & Serializable & scala.Serializable)() -> edge.key().range().headOption()), activeContext);
    }

    private <T> JsonInProgress<Json, JsonObject> edgeOutVToJson(Edge<?, T> edge, ActiveContext<Json, JsonObject> activeContext) {
        return this.fromAny(edge.outV(), (Option<ClassType<?>>)None$.MODULE$, activeContext);
    }

    public JsonObjectInProgress<Json, JsonObject> fromEdge(Edge<?, ?> var1, ActiveContext<Json, JsonObject> var2);

    public static /* synthetic */ JsonInProgress fromData$(Encode $this, Object value, DataType expectedType, ActiveContext activeContext) {
        return $this.fromData(value, expectedType, activeContext);
    }

    default public JsonInProgress<Json, JsonObject> fromData(Object value, DataType<?> expectedType, ActiveContext<Json, JsonObject> activeContext) {
        JsonInProgress<Json, JsonObject> jsonInProgress;
        DataType<?> dataType = expectedType;
        if (dataType instanceof LiteralType) {
            LiteralType literalType = (LiteralType)dataType;
            jsonInProgress = this.fromLiteral(value, literalType, activeContext);
        } else if (dataType instanceof StructuredType) {
            StructuredType structuredType = (StructuredType)dataType;
            jsonInProgress = this.fromStructured(value, structuredType, activeContext);
        } else {
            throw new MatchError(dataType);
        }
        return jsonInProgress;
    }

    public static /* synthetic */ JsonInProgress fromLiteral$(Encode $this, Object value, LiteralType expectedType, ActiveContext activeContext) {
        return $this.fromLiteral(value, expectedType, activeContext);
    }

    default public JsonInProgress<Json, JsonObject> fromLiteral(Object value, LiteralType<?> expectedType, ActiveContext<Json, JsonObject> activeContext) {
        JsonInProgress<Json, JsonObject> jsonInProgress;
        LiteralType<?> literalType = expectedType;
        if (literalType instanceof BoolType) {
            Object object = value;
            if (!(object instanceof Boolean)) {
                throw new ToJsonException(new StringBuilder(23).append("boolean expected ").append(value.getClass()).append(" found").toString());
            }
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            JsonInProgress<Json, JsonObject> jsonInProgress2 = new JsonInProgress<Json, JsonObject>(this.boolToJson(bl), activeContext);
            jsonInProgress = jsonInProgress2;
        } else if (literalType instanceof CalendarType) {
            CalendarType calendarType = (CalendarType)literalType;
            jsonInProgress = this.fromCalendar(value, calendarType, activeContext);
        } else if (literalType instanceof NumericType) {
            NumericType numericType = (NumericType)literalType;
            jsonInProgress = this.fromNumeric(value, numericType, activeContext);
        } else if (literalType instanceof TextType) {
            TextType textType = (TextType)literalType;
            jsonInProgress = this.fromText(value, textType, activeContext);
        } else {
            throw new MatchError(literalType);
        }
        return jsonInProgress;
    }

    public static /* synthetic */ JsonInProgress fromCalendar$(Encode $this, Object value, CalendarType expectedType, ActiveContext activeContext) {
        return $this.fromCalendar(value, expectedType, activeContext);
    }

    default public JsonInProgress<Json, JsonObject> fromCalendar(Object value, CalendarType<?> expectedType, ActiveContext<Json, JsonObject> activeContext) {
        JsonInProgress<Json, JsonObject> jsonInProgress;
        CalendarType<?> calendarType = expectedType;
        if (calendarType instanceof DateTimeType) {
            DateTimeType dateTimeType = (DateTimeType)calendarType;
            jsonInProgress = this.fromDateTime(value, dateTimeType, activeContext);
        } else if (calendarType instanceof LocalDateType) {
            LocalDateType localDateType = (LocalDateType)calendarType;
            jsonInProgress = this.fromDate(value, localDateType, activeContext);
        } else if (calendarType instanceof LocalTimeType) {
            LocalTimeType localTimeType = (LocalTimeType)calendarType;
            jsonInProgress = this.fromTime(value, localTimeType, activeContext);
        } else {
            throw new MatchError(calendarType);
        }
        return jsonInProgress;
    }

    public static /* synthetic */ JsonInProgress fromDateTime$(Encode $this, Object value, DateTimeType expectedType, ActiveContext activeContext) {
        return $this.fromDateTime(value, expectedType, activeContext);
    }

    default public JsonInProgress<Json, JsonObject> fromDateTime(Object value, DateTimeType<?> expectedType, ActiveContext<Json, JsonObject> activeContext) {
        Object object = value;
        if (!(object instanceof Instant)) {
            throw new ToJsonException(new StringBuilder(24).append("datetime expected ").append(value.getClass()).append(" found").toString());
        }
        Instant instant = (Instant)object;
        JsonInProgress<Json, JsonObject> jsonInProgress = new JsonInProgress<Json, JsonObject>(this.textToJson(instant.toString()), activeContext);
        return jsonInProgress;
    }

    public static /* synthetic */ JsonInProgress fromDate$(Encode $this, Object value, LocalDateType expectedType, ActiveContext activeContext) {
        return $this.fromDate(value, expectedType, activeContext);
    }

    default public JsonInProgress<Json, JsonObject> fromDate(Object value, LocalDateType<?> expectedType, ActiveContext<Json, JsonObject> activeContext) {
        Object object = value;
        if (!(object instanceof LocalDate)) {
            throw new ToJsonException(new StringBuilder(20).append("date expected ").append(value.getClass()).append(" found").toString());
        }
        LocalDate localDate = (LocalDate)object;
        JsonInProgress<Json, JsonObject> jsonInProgress = new JsonInProgress<Json, JsonObject>(this.textToJson(localDate.toString()), activeContext);
        return jsonInProgress;
    }

    public static /* synthetic */ JsonInProgress fromTime$(Encode $this, Object value, LocalTimeType expectedType, ActiveContext activeContext) {
        return $this.fromTime(value, expectedType, activeContext);
    }

    default public JsonInProgress<Json, JsonObject> fromTime(Object value, LocalTimeType<?> expectedType, ActiveContext<Json, JsonObject> activeContext) {
        Object object = value;
        if (!(object instanceof LocalTime)) {
            throw new ToJsonException(new StringBuilder(20).append("time expected ").append(value.getClass()).append(" found").toString());
        }
        LocalTime localTime = (LocalTime)object;
        JsonInProgress<Json, JsonObject> jsonInProgress = new JsonInProgress<Json, JsonObject>(this.textToJson(localTime.toString()), activeContext);
        return jsonInProgress;
    }

    public static /* synthetic */ JsonInProgress fromNumeric$(Encode $this, Object value, NumericType expectedType, ActiveContext activeContext) {
        return $this.fromNumeric(value, expectedType, activeContext);
    }

    default public JsonInProgress<Json, JsonObject> fromNumeric(Object value, NumericType<?> expectedType, ActiveContext<Json, JsonObject> activeContext) {
        JsonInProgress<Json, JsonObject> jsonInProgress;
        NumericType<?> numericType = expectedType;
        if (numericType instanceof IntType) {
            IntType intType = (IntType)numericType;
            jsonInProgress = this.fromInt(value, intType, activeContext);
        } else if (numericType instanceof DoubleType) {
            DoubleType doubleType = (DoubleType)numericType;
            jsonInProgress = this.fromDouble(value, doubleType, activeContext);
        } else if (numericType instanceof LongType) {
            LongType longType = (LongType)numericType;
            jsonInProgress = this.fromLong(value, longType, activeContext);
        } else {
            throw new MatchError(numericType);
        }
        return jsonInProgress;
    }

    public static /* synthetic */ JsonInProgress fromInt$(Encode $this, Object value, IntType expectedType, ActiveContext activeContext) {
        return $this.fromInt(value, expectedType, activeContext);
    }

    default public JsonInProgress<Json, JsonObject> fromInt(Object value, IntType<?> expectedType, ActiveContext<Json, JsonObject> activeContext) {
        Object object = value;
        if (!(object instanceof Integer)) {
            throw new ToJsonException(new StringBuilder(19).append("int expected ").append(value.getClass()).append(" found").toString());
        }
        int n = BoxesRunTime.unboxToInt((Object)object);
        JsonInProgress<Json, JsonObject> jsonInProgress = new JsonInProgress<Json, JsonObject>(this.intToJson(n), activeContext);
        return jsonInProgress;
    }

    public static /* synthetic */ JsonInProgress fromDouble$(Encode $this, Object value, DoubleType expectedType, ActiveContext activeContext) {
        return $this.fromDouble(value, expectedType, activeContext);
    }

    default public JsonInProgress<Json, JsonObject> fromDouble(Object value, DoubleType<?> expectedType, ActiveContext<Json, JsonObject> activeContext) {
        Object object = value;
        if (!(object instanceof Double)) {
            throw new ToJsonException(new StringBuilder(22).append("double expected ").append(value.getClass()).append(" found").toString());
        }
        double d = BoxesRunTime.unboxToDouble((Object)object);
        JsonInProgress<Json, JsonObject> jsonInProgress = new JsonInProgress<Json, JsonObject>(this.doubleToJson(d), activeContext);
        return jsonInProgress;
    }

    public static /* synthetic */ JsonInProgress fromLong$(Encode $this, Object value, LongType expectedType, ActiveContext activeContext) {
        return $this.fromLong(value, expectedType, activeContext);
    }

    default public JsonInProgress<Json, JsonObject> fromLong(Object value, LongType<?> expectedType, ActiveContext<Json, JsonObject> activeContext) {
        Object object = value;
        if (!(object instanceof Long)) {
            throw new ToJsonException(new StringBuilder(20).append("long expected ").append(value.getClass()).append(" found").toString());
        }
        long l = BoxesRunTime.unboxToLong((Object)object);
        JsonInProgress<Json, JsonObject> jsonInProgress = new JsonInProgress<Json, JsonObject>(this.longToJson(l), activeContext);
        return jsonInProgress;
    }

    public static /* synthetic */ JsonInProgress fromText$(Encode $this, Object value, TextType expectedType, ActiveContext activeContext) {
        return $this.fromText(value, expectedType, activeContext);
    }

    default public JsonInProgress<Json, JsonObject> fromText(Object value, TextType<?> expectedType, ActiveContext<Json, JsonObject> activeContext) {
        Object object = value;
        if (!(object instanceof String)) {
            throw new ToJsonException(new StringBuilder(22).append("string expected ").append(value.getClass()).append(" found").toString());
        }
        String string = (String)object;
        JsonInProgress<Json, JsonObject> jsonInProgress = new JsonInProgress<Json, JsonObject>(this.textToJson(string), activeContext);
        return jsonInProgress;
    }

    public static /* synthetic */ JsonInProgress fromStructured$(Encode $this, Object value, StructuredType expectedType, ActiveContext activeContext) {
        return $this.fromStructured(value, expectedType, activeContext);
    }

    default public JsonInProgress<Json, JsonObject> fromStructured(Object value, StructuredType<?> expectedType, ActiveContext<Json, JsonObject> activeContext) {
        JsonInProgress<Json, JsonObject> jsonInProgress;
        StructuredType<?> structuredType = expectedType;
        if (structuredType instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)structuredType;
            jsonInProgress = this.fromCollection(value, collectionType, activeContext);
        } else if (structuredType instanceof GeometricType) {
            GeometricType geometricType = (GeometricType)structuredType;
            jsonInProgress = this.fromGeometric(value, geometricType, activeContext);
        } else if (structuredType instanceof QuantityType) {
            QuantityType quantityType = (QuantityType)structuredType;
            jsonInProgress = this.fromQuantity(value, quantityType, activeContext);
        } else if (structuredType instanceof TupleType) {
            TupleType tupleType = (TupleType)structuredType;
            jsonInProgress = this.fromTuple(value, tupleType, activeContext);
        } else {
            throw new MatchError(structuredType);
        }
        return jsonInProgress;
    }

    private JsonInProgress<Json, JsonObject> toArray(Seq<?> v, Option<ClassType<?>> label, ActiveContext<Json, JsonObject> activeContext) {
        Tuple2 tuple2 = (Tuple2)v.foldLeft((Object)new Tuple2((Object)Nil$.MODULE$, activeContext), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Object v;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    v = tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            List r = (List)tuple2._1();
            ActiveContext activeContext = (ActiveContext)tuple2._2();
            JsonInProgress jip = this.fromAny(v, label, activeContext);
            Tuple2 tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(r.$colon$plus(jip.json(), List$.MODULE$.canBuildFrom())), jip.activeContext());
            return tuple23;
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List jsons = (List)tuple2._1();
        ActiveContext ac = (ActiveContext)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)jsons, (Object)ac);
        Tuple2 tuple23 = tuple22;
        List jsons2 = (List)tuple23._1();
        ActiveContext ac2 = (ActiveContext)tuple23._2();
        return new JsonInProgress(this.listToJson(jsons2), ac2);
    }

    public static /* synthetic */ JsonInProgress fromCollection$(Encode $this, Object value, CollectionType expectedType, ActiveContext activeContext) {
        return $this.fromCollection(value, expectedType, activeContext);
    }

    default public JsonInProgress<Json, JsonObject> fromCollection(Object value, CollectionType<?> expectedType, ActiveContext<Json, JsonObject> activeContext) {
        JsonInProgress<Json, JsonObject> jsonInProgress;
        CollectionType<?> collectionType = expectedType;
        if (collectionType instanceof ListType) {
            ListType listType = (ListType)collectionType;
            Object object = value;
            if (!(object instanceof List)) {
                throw new ToJsonException(new StringBuilder(20).append("list expected ").append(value.getClass()).append(" found").toString());
            }
            List list = (List)object;
            JsonInProgress<Json, JsonObject> jsonInProgress2 = this.toArray((Seq<?>)list, (Option<ClassType<?>>)listType.valueRange().headOption(), activeContext);
            jsonInProgress = jsonInProgress2;
        } else if (collectionType instanceof MapType) {
            Tuple2 tuple2;
            MapType mapType = (MapType)collectionType;
            Object object = value;
            if (object instanceof Map) {
                Map map = (Map)object;
                Tuple2 tuple22 = (Tuple2)map.foldLeft((Object)new Tuple2((Object)Nil$.MODULE$, activeContext), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                    ActiveContext activeContext;
                    List r;
                    Tuple2 tuple2;
                    block3: {
                        Tuple2 tuple22;
                        block2: {
                            tuple22 = new Tuple2(x0$1, x1$1);
                            if (tuple22 == null) break block2;
                            Tuple2 tuple23 = (Tuple2)tuple22._1();
                            tuple2 = (Tuple2)tuple22._2();
                            if (tuple23 == null) break block2;
                            r = (List)tuple23._1();
                            activeContext = (ActiveContext)tuple23._2();
                            if (tuple2 != null) break block3;
                        }
                        throw new MatchError((Object)tuple22);
                    }
                    Object k = tuple2._1();
                    Object v = tuple2._2();
                    JsonInProgress jip = this.fromAny(k, mapType.keyRange().headOption(), activeContext);
                    JsonInProgress jip2 = this.fromAny(v, mapType.valueRange().headOption(), jip.activeContext());
                    Tuple2 tuple24 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(r.$colon$plus((Object)new Tuple2(jip.json(), jip2.json()), List$.MODULE$.canBuildFrom())), jip2.activeContext());
                    return tuple24;
                });
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                List tuples = (List)tuple22._1();
                ActiveContext ac = (ActiveContext)tuple22._2();
                tuple2 = new Tuple2((Object)tuples, (Object)ac);
            } else {
                throw new ToJsonException(new StringBuilder(19).append("map expected ").append(value.getClass()).append(" found").toString());
            }
            Tuple2 tuple23 = tuple2;
            List tuples = (List)tuple23._1();
            ActiveContext ac = (ActiveContext)tuple23._2();
            JsonInProgress jsonInProgress3 = new JsonInProgress(this.tuple2ListToJson(tuples), ac);
            jsonInProgress = jsonInProgress3;
        } else if (collectionType instanceof SetType) {
            SetType setType = (SetType)collectionType;
            Object object = value;
            if (!(object instanceof Set)) {
                throw new ToJsonException(new StringBuilder(20).append("list expected ").append(value.getClass()).append(" found").toString());
            }
            Set set = (Set)object;
            JsonInProgress<Json, JsonObject> jsonInProgress4 = this.toArray(set.toSeq(), setType.valueRange().headOption(), activeContext);
            jsonInProgress = jsonInProgress4;
        } else if (collectionType instanceof ListSetType) {
            ListSetType listSetType = (ListSetType)collectionType;
            Object object = value;
            if (!(object instanceof ListSet)) {
                throw new ToJsonException(new StringBuilder(20).append("list expected ").append(value.getClass()).append(" found").toString());
            }
            ListSet listSet = (ListSet)object;
            JsonInProgress<Json, JsonObject> jsonInProgress5 = this.toArray(listSet.toSeq(), listSetType.valueRange().headOption(), activeContext);
            jsonInProgress = jsonInProgress5;
        } else if (collectionType instanceof VectorType) {
            VectorType vectorType = (VectorType)collectionType;
            Object object = value;
            if (!(object instanceof Vector)) {
                throw new ToJsonException(new StringBuilder(20).append("list expected ").append(value.getClass()).append(" found").toString());
            }
            Vector vector = (Vector)object;
            JsonInProgress<Json, JsonObject> jsonInProgress6 = this.toArray((Seq<?>)vector, (Option<ClassType<?>>)vectorType.valueRange().headOption(), activeContext);
            jsonInProgress = jsonInProgress6;
        } else {
            throw new MatchError(collectionType);
        }
        return jsonInProgress;
    }

    public static /* synthetic */ JsonInProgress fromGeometric$(Encode $this, Object value, GeometricType expectedType, ActiveContext activeContext) {
        return $this.fromGeometric(value, expectedType, activeContext);
    }

    default public JsonInProgress<Json, JsonObject> fromGeometric(Object value, GeometricType<?> expectedType, ActiveContext<Json, JsonObject> activeContext) {
        Object object = value;
        if (!(object instanceof Geometry)) {
            throw new ToJsonException(new StringBuilder(19).append("int expected ").append(value.getClass()).append(" found").toString());
        }
        Geometry geometry = (Geometry)object;
        JsonInProgress<Json, JsonObject> jsonInProgress = new JsonInProgress<Json, JsonObject>(this.geoToJson(geometry), activeContext);
        return jsonInProgress;
    }

    public static /* synthetic */ JsonInProgress fromQuantity$(Encode $this, Object value, QuantityType expectedType, ActiveContext activeContext) {
        return $this.fromQuantity(value, expectedType, activeContext);
    }

    default public JsonInProgress<Json, JsonObject> fromQuantity(Object value, QuantityType<?> expectedType, ActiveContext<Json, JsonObject> activeContext) {
        JsonInProgress<Json, JsonObject> jsonInProgress;
        QuantityType<?> quantityType = expectedType;
        if (quantityType instanceof DurationType) {
            Object object = value;
            if (!(object instanceof Time)) {
                throw new ToJsonException(new StringBuilder(24).append("duration expected ").append(value.getClass()).append(" found").toString());
            }
            Time time = (Time)object;
            jsonInProgress = new JsonInProgress<Json, JsonObject>(this.mapToJson((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), this.doubleToJson(time.value())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"unit"), this.textToJson(time.unit().symbol()))}))), activeContext);
        } else {
            throw new MatchError(quantityType);
        }
        JsonInProgress<Json, JsonObject> jsonInProgress2 = jsonInProgress;
        return jsonInProgress2;
    }

    public static /* synthetic */ JsonInProgress fromTuple$(Encode $this, Object value, TupleType expectedType, ActiveContext activeContext) {
        return $this.fromTuple(value, expectedType, activeContext);
    }

    default public JsonInProgress<Json, JsonObject> fromTuple(Object value, TupleType<?> expectedType, ActiveContext<Json, JsonObject> activeContext) {
        JsonInProgress<Json, JsonObject> jsonInProgress;
        TupleType<?> tupleType = expectedType;
        if (tupleType instanceof Tuple2Type) {
            Tuple2Type tuple2Type = (Tuple2Type)tupleType;
            Object object = value;
            if (!(object instanceof Tuple2)) {
                throw new ToJsonException(new StringBuilder(22).append("tuple2 expected ").append(value.getClass()).append(" found").toString());
            }
            Tuple2 tuple2 = (Tuple2)object;
            Object v1 = tuple2._1();
            Object v2 = tuple2._2();
            JsonInProgress<Json, JsonObject> jip = this.fromAny(v1, tuple2Type._1stRange().headOption(), activeContext);
            JsonInProgress<Json, JsonObject> jip2 = this.fromAny(v2, tuple2Type._2ndRange().headOption(), jip.activeContext());
            JsonInProgress<Json, JsonObject> jsonInProgress2 = new JsonInProgress<Json, JsonObject>(this.tuple2ToJson(new Tuple2(jip.json(), jip2.json())), jip2.activeContext());
            jsonInProgress = jsonInProgress2;
        } else if (tupleType instanceof Tuple3Type) {
            Tuple3Type tuple3Type = (Tuple3Type)tupleType;
            Object object = value;
            if (!(object instanceof Tuple3)) {
                throw new ToJsonException(new StringBuilder(22).append("tuple3 expected ").append(value.getClass()).append(" found").toString());
            }
            Tuple3 tuple3 = (Tuple3)object;
            Object v1 = tuple3._1();
            Object v2 = tuple3._2();
            Object v3 = tuple3._3();
            JsonInProgress<Json, JsonObject> jip = this.fromAny(v1, tuple3Type._1stRange().headOption(), activeContext);
            JsonInProgress<Json, JsonObject> jip2 = this.fromAny(v2, tuple3Type._2ndRange().headOption(), jip.activeContext());
            JsonInProgress<Json, JsonObject> jip3 = this.fromAny(v3, tuple3Type._3rdRange().headOption(), jip2.activeContext());
            JsonInProgress<Json, JsonObject> jsonInProgress3 = new JsonInProgress<Json, JsonObject>(this.tuple3ToJson(new Tuple3(jip.json(), jip2.json(), jip3.json())), jip3.activeContext());
            jsonInProgress = jsonInProgress3;
        } else if (tupleType instanceof Tuple4Type) {
            Tuple4Type tuple4Type = (Tuple4Type)tupleType;
            Object object = value;
            if (!(object instanceof Tuple4)) {
                throw new ToJsonException(new StringBuilder(22).append("tuple4 expected ").append(value.getClass()).append(" found").toString());
            }
            Tuple4 tuple4 = (Tuple4)object;
            Object v1 = tuple4._1();
            Object v2 = tuple4._2();
            Object v3 = tuple4._3();
            Object v4 = tuple4._4();
            JsonInProgress<Json, JsonObject> jip = this.fromAny(v1, tuple4Type._1stRange().headOption(), activeContext);
            JsonInProgress<Json, JsonObject> jip2 = this.fromAny(v2, tuple4Type._2ndRange().headOption(), jip.activeContext());
            JsonInProgress<Json, JsonObject> jip3 = this.fromAny(v3, tuple4Type._3rdRange().headOption(), jip2.activeContext());
            JsonInProgress<Json, JsonObject> jip4 = this.fromAny(v4, tuple4Type._4rdRange().headOption(), jip3.activeContext());
            JsonInProgress<Json, JsonObject> jsonInProgress4 = new JsonInProgress<Json, JsonObject>(this.tuple4ToJson(new Tuple4(jip.json(), jip2.json(), jip3.json(), jip4.json())), jip4.activeContext());
            jsonInProgress = jsonInProgress4;
        } else {
            throw new MatchError(tupleType);
        }
        return jsonInProgress;
    }

    public static /* synthetic */ JsonInProgress fromAny$(Encode $this, Object value, Option expectedType, ActiveContext activeContext) {
        return $this.fromAny(value, expectedType, activeContext);
    }

    default public JsonInProgress<Json, JsonObject> fromAny(Object value, Option<ClassType<?>> expectedType, ActiveContext<Json, JsonObject> activeContext) {
        JsonInProgress<Json, JsonObject> jsonInProgress;
        Object object = value;
        if (object instanceof IriResource) {
            JsonInProgress<Json, JsonObject> jsonInProgress2;
            IriResource iriResource = (IriResource)object;
            IriResource iriResource2 = iriResource;
            if (iriResource2 instanceof Value) {
                JsonInProgress<Json, JsonObject> jsonInProgress3;
                Value value2 = (Value)iriResource2;
                if (expectedType.contains((Object)value2.label())) {
                    jsonInProgress3 = this.fromData(value2.value(), value2.label(), activeContext);
                } else {
                    JsonInProgress<Json, JsonObject> jip = this.fromData(value2.value(), value2.label(), activeContext);
                    jsonInProgress3 = new JsonInProgress<Json, JsonObject>(this.mapToJson((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)NS.types$.MODULE$.$atvalue()), jip.json()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)NS.types$.MODULE$.$attype()), this.textToJson(this.WithIriString(value2.label().iri(), activeContext).compact()))}))), jip.activeContext());
                }
                jsonInProgress2 = jsonInProgress3;
            } else if (iriResource2 instanceof Node) {
                JsonInProgress<Json, JsonObject> jsonInProgress4;
                Node node = (Node)iriResource2;
                if (new StringOps(Predef$.MODULE$.augmentString(node.iri())).nonEmpty()) {
                    jsonInProgress4 = new JsonInProgress<Json, JsonObject>(this.textToJson(node.iri()), activeContext);
                } else {
                    JsonObjectInProgress<Json, JsonObject> joip = this.fromNode(node, activeContext);
                    jsonInProgress4 = new JsonInProgress<Json, JsonObject>(this.jsonObjectToJson(joip.json()), joip.activeContext());
                }
                jsonInProgress2 = jsonInProgress4;
            } else if (iriResource2 instanceof Edge) {
                JsonInProgress<Json, JsonObject> jsonInProgress5;
                Edge edge = (Edge)iriResource2;
                if (new StringOps(Predef$.MODULE$.augmentString(edge.iri())).nonEmpty()) {
                    jsonInProgress5 = new JsonInProgress<Json, JsonObject>(this.textToJson(edge.iri()), activeContext);
                } else {
                    JsonObjectInProgress<Json, JsonObject> joip = this.fromEdge(edge, activeContext);
                    jsonInProgress5 = new JsonInProgress<Json, JsonObject>(this.jsonObjectToJson(joip.json()), joip.activeContext());
                }
                jsonInProgress2 = jsonInProgress5;
            } else if (iriResource2 != null) {
                IriResource iriResource3 = iriResource2;
                jsonInProgress2 = new JsonInProgress<Json, JsonObject>(this.textToJson(iriResource3.iri()), activeContext);
            } else {
                throw new MatchError((Object)iriResource2);
            }
            jsonInProgress = jsonInProgress2;
        } else {
            JsonInProgress<Json, JsonObject> jsonInProgress6;
            DataType label = ClassType$.MODULE$.valueToOntologyResource(value);
            if (expectedType.contains((Object)label)) {
                jsonInProgress6 = this.fromData(value, label, activeContext);
            } else {
                JsonInProgress<Json, JsonObject> jip = this.fromData(value, label, activeContext);
                jsonInProgress6 = new JsonInProgress<Json, JsonObject>(this.mapToJson((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)NS.types$.MODULE$.$atvalue()), jip.json()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)NS.types$.MODULE$.$attype()), this.textToJson(this.WithIriString(label.iri(), activeContext).compact()))}))), jip.activeContext());
            }
            jsonInProgress = jsonInProgress6;
        }
        return jsonInProgress;
    }

    public static /* synthetic */ Option fromAny$default$2$(Encode $this) {
        return $this.fromAny$default$2();
    }

    default public Option<ClassType<?>> fromAny$default$2() {
        return None$.MODULE$;
    }

    public static /* synthetic */ JsonObjectInProgress fromOntology$(Encode $this, Ontology ontology, ActiveContext activeContext) {
        return $this.fromOntology(ontology, activeContext);
    }

    default public JsonObjectInProgress<Json, JsonObject> fromOntology(Ontology ontology, ActiveContext<Json, JsonObject> activeContext) {
        Map map;
        Map map2 = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)NS.types$.MODULE$.$atid()), this.textToJson(this.WithIriString(ontology.iri(), activeContext).compact()))), new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)NS.types$.MODULE$.$attype()), this.textToJson(NS.types$.MODULE$.$atclass()))), ontology.base().map((Function1 & Serializable & scala.Serializable)uri -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)NS.types$.MODULE$.$atbase()), this.textToJson(this.WithIriString((String)uri, activeContext).compact()))), ontology.label().nonEmpty() ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)NS.types$.MODULE$.$atlabel()), this.mapToJson(ontology.label().mapValues((Function1 & Serializable & scala.Serializable)t -> this.textToJson((String)t))))) : None$.MODULE$, ontology.comment().nonEmpty() ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)NS.types$.MODULE$.$atcomment()), this.mapToJson(ontology.comment().mapValues((Function1 & Serializable & scala.Serializable)t -> this.textToJson((String)t))))) : None$.MODULE$, ontology.extendedClasses().nonEmpty() ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)NS.types$.MODULE$.$atextends()), this.listToJson((List)ontology.extendedClasses().map((Function1 & Serializable & scala.Serializable)o -> this.textToJson(this.WithIriString(o.iri(), activeContext).compact()), List$.MODULE$.canBuildFrom())))) : None$.MODULE$})).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).toMap(Predef$.MODULE$.$conforms());
        List list = ontology.properties().toList();
        Some some = List$.MODULE$.unapplySeq((Seq)list);
        if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(0) == 0) {
            map = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        } else {
            Some some2 = List$.MODULE$.unapplySeq((Seq)list);
            if (!some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0) {
                Property property = (Property)((LinearSeqOptimized)some2.get()).apply(0);
                map = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)NS.types$.MODULE$.$atproperties()), this.textToJson(this.WithIriString(property.iri(), activeContext).compact()))}));
            } else {
                map = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)NS.types$.MODULE$.$atproperties()), this.listToJson((List)list.map((Function1 & Serializable & scala.Serializable)key -> this.textToJson(this.WithIriString(key.iri(), activeContext).compact()), List$.MODULE$.canBuildFrom())))}));
            }
        }
        Map jsProperties = map2.$plus$plus((GenTraversableOnce)map);
        return new JsonObjectInProgress<Json, JsonObject>(this.mapToJsonObject(jsProperties), activeContext);
    }

    public static /* synthetic */ JsonObjectInProgress fromProperty$(Encode $this, Property key, ActiveContext activeContext) {
        return $this.fromProperty(key, activeContext);
    }

    default public JsonObjectInProgress<Json, JsonObject> fromProperty(Property key2, ActiveContext<Json, JsonObject> activeContext) {
        Map map;
        Map map2;
        Map map3 = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)NS.types$.MODULE$.$atid()), this.textToJson(this.WithIriString(key2.iri(), activeContext).compact()))), new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)NS.types$.MODULE$.$attype()), this.textToJson(NS.types$.MODULE$.$atproperty()))), key2.label().nonEmpty() ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)NS.types$.MODULE$.$atlabel()), this.mapToJson(key2.label().mapValues((Function1 & Serializable & scala.Serializable)t -> this.textToJson((String)t))))) : None$.MODULE$, key2.comment().nonEmpty() ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)NS.types$.MODULE$.$atcomment()), this.mapToJson(key2.comment().mapValues((Function1 & Serializable & scala.Serializable)t -> this.textToJson((String)t))))) : None$.MODULE$, key2.container().isDefined() ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)NS.types$.MODULE$.$atcontainer()), this.listToJson(List$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.textToJson((String)key2.container().get())}))))) : None$.MODULE$, key2.extendedClasses().nonEmpty() ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)NS.types$.MODULE$.$atextends()), this.listToJson((List)key2.extendedClasses().map((Function1 & Serializable & scala.Serializable)o -> this.textToJson(this.WithIriString(o.iri(), activeContext).compact()), List$.MODULE$.canBuildFrom())))) : None$.MODULE$})).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).toMap(Predef$.MODULE$.$conforms());
        List list = key2.range().toList();
        Some some = List$.MODULE$.unapplySeq((Seq)list);
        if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(0) == 0) {
            map2 = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        } else {
            Some some2 = List$.MODULE$.unapplySeq((Seq)list);
            if (!some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0) {
                ClassType dataType2 = (ClassType)((LinearSeqOptimized)some2.get()).apply(0);
                map2 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)NS.types$.MODULE$.$atrange()), this.textToJson(this.WithIriString(dataType2.iri(), activeContext).compact()))}));
            } else {
                map2 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)NS.types$.MODULE$.$atrange()), this.listToJson((List)list.map((Function1 & Serializable & scala.Serializable)dataType -> this.textToJson(this.WithIriString(dataType.iri(), activeContext).compact()), List$.MODULE$.canBuildFrom())))}));
            }
        }
        Map map4 = map3.$plus$plus((GenTraversableOnce)map2);
        List list2 = key2.properties().toList();
        Some some3 = List$.MODULE$.unapplySeq((Seq)list2);
        if (!some3.isEmpty() && some3.get() != null && ((LinearSeqOptimized)some3.get()).lengthCompare(0) == 0) {
            map = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        } else {
            Some some4 = List$.MODULE$.unapplySeq((Seq)list2);
            if (!some4.isEmpty() && some4.get() != null && ((LinearSeqOptimized)some4.get()).lengthCompare(1) == 0) {
                Property property = (Property)((LinearSeqOptimized)some4.get()).apply(0);
                map = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)NS.types$.MODULE$.$atproperty()), this.textToJson(this.WithIriString(property.iri(), activeContext).compact()))}));
            } else {
                map = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)NS.types$.MODULE$.$atproperty()), this.listToJson((List)list2.map((Function1 & Serializable & scala.Serializable)key -> this.textToJson(this.WithIriString(key.iri(), activeContext).compact()), List$.MODULE$.canBuildFrom())))}));
            }
        }
        Map jsProperties = map4.$plus$plus((GenTraversableOnce)map);
        return new JsonObjectInProgress<Json, JsonObject>(this.mapToJsonObject(jsProperties), activeContext);
    }

    public static /* synthetic */ JsonObjectInProgress fromDataType$(Encode $this, DataType dataType, ActiveContext activeContext) {
        return $this.fromDataType(dataType, activeContext);
    }

    default public JsonObjectInProgress<Json, JsonObject> fromDataType(DataType<?> dataType, ActiveContext<Json, JsonObject> activeContext) {
        Tuple2 tuple2;
        List list = dataType.properties().toList();
        Some some = List$.MODULE$.unapplySeq((Seq)list);
        Map map = !some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(0) == 0 ? (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$) : (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)NS.types$.MODULE$.$atproperties()), this.listToJson((List)list.map((Function1 & Serializable & scala.Serializable)key -> this.textToJson(key.iri()), List$.MODULE$.canBuildFrom())))}));
        Map jsProperties = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)NS.types$.MODULE$.$atid()), this.textToJson(dataType.iri()))), new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)NS.types$.MODULE$.$attype()), this.textToJson(NS.types$.MODULE$.$atdatatype()))), dataType.label().nonEmpty() ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)NS.types$.MODULE$.$atlabel()), this.mapToJson(dataType.label().mapValues((Function1 & Serializable & scala.Serializable)t -> this.textToJson((String)t))))) : None$.MODULE$, dataType.comment().nonEmpty() ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)NS.types$.MODULE$.$atcomment()), this.mapToJson(dataType.comment().mapValues((Function1 & Serializable & scala.Serializable)t -> this.textToJson((String)t))))) : None$.MODULE$, dataType.extendedClasses().nonEmpty() ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)NS.types$.MODULE$.$atextends()), this.listToJson((List)dataType.extendedClasses().map((Function1 & Serializable & scala.Serializable)o -> this.textToJson(o.iri()), List$.MODULE$.canBuildFrom())))) : None$.MODULE$})).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)map);
        DataType<?> dataType2 = dataType;
        if (dataType2 instanceof CollectionType) {
            Tuple2 tuple22;
            CollectionType collectionType = (CollectionType)dataType2;
            CollectionType collectionType2 = collectionType;
            if (collectionType2 instanceof ListType) {
                ListType listType = (ListType)collectionType2;
                JsonInProgress<Json, JsonObject> jip = this.ctListToJson(listType.valueRange(), activeContext);
                tuple22 = listType.valueRange().isEmpty() || jip.json().toString().isEmpty() ? Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)), jip.activeContext()) : Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PropertyDef$.MODULE$.pDefToProperty((PropertyDef)CollectionType.keys$.valueRange$.MODULE$).iri()), jip.json())}))), jip.activeContext());
            } else if (collectionType2 instanceof ListSetType) {
                ListSetType listSetType = (ListSetType)collectionType2;
                JsonInProgress<Json, JsonObject> jip = this.ctListToJson(listSetType.valueRange(), activeContext);
                tuple22 = listSetType.valueRange().isEmpty() || jip.json().toString().isEmpty() ? Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)), jip.activeContext()) : Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PropertyDef$.MODULE$.pDefToProperty((PropertyDef)CollectionType.keys$.valueRange$.MODULE$).iri()), jip.json())}))), jip.activeContext());
            } else if (collectionType2 instanceof SetType) {
                SetType setType = (SetType)collectionType2;
                JsonInProgress<Json, JsonObject> jip = this.ctListToJson(setType.valueRange(), activeContext);
                tuple22 = setType.valueRange().isEmpty() || jip.json().toString().isEmpty() ? Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)), jip.activeContext()) : Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PropertyDef$.MODULE$.pDefToProperty((PropertyDef)CollectionType.keys$.valueRange$.MODULE$).iri()), jip.json())}))), jip.activeContext());
            } else if (collectionType2 instanceof VectorType) {
                VectorType vectorType = (VectorType)collectionType2;
                JsonInProgress<Json, JsonObject> jip = this.ctListToJson(vectorType.valueRange(), activeContext);
                tuple22 = vectorType.valueRange().isEmpty() || jip.json().toString().isEmpty() ? Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)), jip.activeContext()) : Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PropertyDef$.MODULE$.pDefToProperty((PropertyDef)CollectionType.keys$.valueRange$.MODULE$).iri()), jip.json())}))), jip.activeContext());
            } else if (collectionType2 instanceof MapType) {
                MapType mapType = (MapType)collectionType2;
                JsonInProgress<Json, JsonObject> jip = this.ctListToJson(mapType.keyRange(), activeContext);
                JsonInProgress<Json, JsonObject> jip2 = this.ctListToJson(mapType.valueRange(), jip.activeContext());
                tuple22 = !(!mapType.keyRange().isEmpty() && !jip.json().toString().isEmpty() || !mapType.valueRange().isEmpty() && !jip2.json().toString().isEmpty()) ? Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)), jip2.activeContext()) : (mapType.keyRange().isEmpty() || jip.json().toString().isEmpty() ? Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PropertyDef$.MODULE$.pDefToProperty((PropertyDef)CollectionType.keys$.valueRange$.MODULE$).iri()), jip2.json())}))), jip2.activeContext()) : (mapType.valueRange().isEmpty() || jip2.json().toString().isEmpty() ? Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PropertyDef$.MODULE$.pDefToProperty((PropertyDef)MapType.keys$.keyRange$.MODULE$).iri()), jip.json())}))), jip2.activeContext()) : Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PropertyDef$.MODULE$.pDefToProperty((PropertyDef)MapType.keys$.keyRange$.MODULE$).iri()), jip.json()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PropertyDef$.MODULE$.pDefToProperty((PropertyDef)CollectionType.keys$.valueRange$.MODULE$).iri()), jip2.json())}))), jip2.activeContext())));
            } else {
                throw new MatchError((Object)collectionType2);
            }
            tuple2 = tuple22;
        } else {
            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)), activeContext);
        }
        Tuple2 tuple23 = tuple2;
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        Map oProperty = (Map)tuple23._1();
        ActiveContext newActiveContext = (ActiveContext)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)oProperty, (Object)newActiveContext);
        Tuple2 tuple25 = tuple24;
        Map oProperty2 = (Map)tuple25._1();
        ActiveContext newActiveContext2 = (ActiveContext)tuple25._2();
        return new JsonObjectInProgress(this.mapToJsonObject((Map)jsProperties.$plus$plus((GenTraversableOnce)oProperty2, Map$.MODULE$.canBuildFrom())), newActiveContext2);
    }

    public static /* synthetic */ JsonInProgress ctListToJson$(Encode $this, List l, ActiveContext activeContext) {
        return $this.ctListToJson(l, activeContext);
    }

    default public JsonInProgress<Json, JsonObject> ctListToJson(List<ClassType<?>> l, ActiveContext<Json, JsonObject> activeContext) {
        JsonInProgress<Json, JsonObject> jsonInProgress;
        if (l.lengthCompare(1) == 0 && ((IriResource)l.head()).iri().isEmpty()) {
            jsonInProgress = new JsonInProgress<Json, JsonObject>(this.textToJson(""), activeContext);
        } else {
            Tuple2 tuple2 = (Tuple2)l.foldLeft((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Nil$.MODULE$), activeContext), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2;
                Tuple2 tuple22 = new Tuple2(x0$1, x1$1);
                if (tuple22 == null) throw new MatchError((Object)tuple22);
                Tuple2 tuple23 = (Tuple2)tuple22._1();
                ClassType c = (ClassType)tuple22._2();
                if (tuple23 == null) throw new MatchError((Object)tuple22);
                List l = (List)tuple23._1();
                ActiveContext activeContext = (ActiveContext)tuple23._2();
                ClassType classType = c;
                if (classType instanceof Ontology) {
                    Ontology ontology = (Ontology)classType;
                    Tuple2 tuple24 = activeContext.compactIri((ClassType<?>)ontology);
                    if (tuple24 == null) throw new MatchError(tuple24);
                    String key = (String)tuple24._1();
                    ActiveContext activeContext2 = (ActiveContext)tuple24._2();
                    Tuple2 tuple25 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(l.$colon$plus(this.textToJson(key), List$.MODULE$.canBuildFrom())), (Object)activeContext2);
                    tuple2 = tuple25;
                    return tuple2;
                } else if (classType instanceof Property) {
                    Property property = (Property)classType;
                    Tuple2 tuple26 = activeContext.compactIri((ClassType<?>)property);
                    if (tuple26 == null) throw new MatchError(tuple26);
                    String key = (String)tuple26._1();
                    ActiveContext activeContext3 = (ActiveContext)tuple26._2();
                    Tuple2 tuple27 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(l.$colon$plus(this.textToJson(key), List$.MODULE$.canBuildFrom())), (Object)activeContext3);
                    tuple2 = tuple27;
                    return tuple2;
                } else {
                    Tuple2 tuple28;
                    if (!(classType instanceof DataType)) throw new MatchError((Object)classType);
                    DataType dataType = (DataType)classType;
                    DataType dataType2 = dataType;
                    if (dataType2 instanceof CollectionType) {
                        CollectionType collectionType = (CollectionType)dataType2;
                        JsonObjectInProgress jsonObjectInProgress = this.fromDataType((DataType<?>)collectionType, activeContext);
                        if (jsonObjectInProgress == null) throw new MatchError(jsonObjectInProgress);
                        JsonObjectInProgress jsonObjectInProgress2 = jsonObjectInProgress;
                        Tuple2 tuple29 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(l.$colon$plus(this.jsonObjectToJson(jsonObjectInProgress2.json()), List$.MODULE$.canBuildFrom())), jsonObjectInProgress2.activeContext());
                        tuple28 = tuple29;
                    } else {
                        Tuple2 tuple210 = activeContext.compactIri((ClassType<?>)dataType);
                        if (tuple210 == null) throw new MatchError(tuple210);
                        String key = (String)tuple210._1();
                        ActiveContext activeContext4 = (ActiveContext)tuple210._2();
                        Tuple2 tuple211 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(l.$colon$plus(this.textToJson(key), List$.MODULE$.canBuildFrom())), (Object)activeContext4);
                        tuple28 = tuple211;
                    }
                    tuple2 = tuple28;
                }
                return tuple2;
            });
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            List l2 = (List)tuple2._1();
            ActiveContext activeContext2 = (ActiveContext)tuple2._2();
            JsonInProgress jsonInProgress2 = new JsonInProgress(this.listToJson(l2), activeContext2);
            jsonInProgress = jsonInProgress2;
        }
        return jsonInProgress;
    }

    public static void $init$(Encode $this) {
    }

    public class WithIriString {
        private String compact;
        private final String iri;
        private final ActiveContext<Json, JsonObject> activeContext;
        private volatile boolean bitmap$0;
        public final /* synthetic */ Encode $outer;

        private String compact$lzycompute() {
            WithIriString withIriString = this;
            synchronized (withIriString) {
                if (!this.bitmap$0) {
                    this.compact = this.activeContext.compactIri(this.iri);
                    this.bitmap$0 = true;
                }
            }
            this.iri = null;
            this.activeContext = null;
            return this.compact;
        }

        public String compact() {
            return !this.bitmap$0 ? this.compact$lzycompute() : this.compact;
        }

        public /* synthetic */ Encode lspace$codec$Encode$WithIriString$$$outer() {
            return this.$outer;
        }

        public WithIriString(Encode<Json, JsonObject> $outer, String iri, ActiveContext<Json, JsonObject> activeContext) {
            this.iri = iri;
            this.activeContext = activeContext;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

