/*
 * Decompiled with CFR 0.152.
 */
package eu.kennytv.maintenance.velocity.util;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import eu.kennytv.maintenance.api.proxy.Server;
import eu.kennytv.maintenance.lib.kyori.adventure.text.Component;
import eu.kennytv.maintenance.velocity.util.ComponentUtil;

public final class VelocityServer
implements Server {
    private final RegisteredServer server;

    public VelocityServer(RegisteredServer server) {
        this.server = server;
    }

    @Override
    public String getName() {
        return this.server.getServerInfo().getName();
    }

    @Override
    public boolean hasPlayers() {
        return !this.server.getPlayersConnected().isEmpty();
    }

    @Override
    public void broadcast(Component component) {
        net.kyori.adventure.text.Component c = ComponentUtil.toVelocity(component);
        for (Player player : this.server.getPlayersConnected()) {
            player.sendMessage(c);
        }
    }

    @Override
    public boolean isRegisteredServer() {
        return true;
    }

    public RegisteredServer getServer() {
        return this.server;
    }
}

