/*
 * Decompiled with CFR 0.152.
 */
package eu.kennytv.maintenance.velocity.listener;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.ResultedEvent;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.LoginEvent;
import com.velocitypowered.api.event.connection.PostLoginEvent;
import com.velocitypowered.api.event.player.ServerPreConnectEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import eu.kennytv.maintenance.api.proxy.Server;
import eu.kennytv.maintenance.core.proxy.SettingsProxy;
import eu.kennytv.maintenance.core.proxy.listener.ProxyJoinListenerBase;
import eu.kennytv.maintenance.core.proxy.util.ServerConnectResult;
import eu.kennytv.maintenance.velocity.MaintenanceVelocityPlugin;
import eu.kennytv.maintenance.velocity.util.ComponentUtil;
import eu.kennytv.maintenance.velocity.util.VelocitySenderInfo;
import eu.kennytv.maintenance.velocity.util.VelocityServer;
import java.util.Optional;
import net.kyori.adventure.text.Component;

public final class ServerConnectListener
extends ProxyJoinListenerBase {
    private final MaintenanceVelocityPlugin plugin;

    public ServerConnectListener(MaintenanceVelocityPlugin plugin, SettingsProxy settings) {
        super(plugin, settings);
        this.plugin = plugin;
    }

    @Subscribe
    public void login(LoginEvent event) {
        if (!event.getResult().isAllowed()) {
            return;
        }
        VelocitySenderInfo sender = new VelocitySenderInfo((CommandSource)event.getPlayer());
        if (this.shouldKick(sender, false)) {
            Server waitingServer = this.shouldConnectToWaitingServer(sender);
            if (waitingServer != null) {
                return;
            }
            event.setResult(ResultedEvent.ComponentResult.denied((Component)ComponentUtil.toVelocity(this.settings.getKickMessage())));
            if (this.settings.isJoinNotifications()) {
                this.broadcastJoinNotification(event.getPlayer().getUsername());
            }
        }
    }

    @Subscribe
    public void postLogin(PostLoginEvent event) {
        this.updateCheck(new VelocitySenderInfo((CommandSource)event.getPlayer()));
    }

    @Subscribe(order=PostOrder.LAST)
    public void preConnect(ServerPreConnectEvent event) {
        if (!event.getResult().isAllowed()) {
            return;
        }
        Optional optionalTarget = event.getResult().getServer();
        if (!optionalTarget.isPresent()) {
            return;
        }
        Player player = event.getPlayer();
        boolean hasCurrentServer = player.getCurrentServer().isPresent();
        ServerConnectResult connectResult = this.serverConnect(new VelocitySenderInfo((CommandSource)player), new VelocityServer((RegisteredServer)optionalTarget.get()), hasCurrentServer);
        if (connectResult.isCancelled()) {
            event.setResult(ServerPreConnectEvent.ServerResult.denied());
            if (!hasCurrentServer) {
                player.disconnect(ComponentUtil.toVelocity(this.settings.getKickMessage()));
            }
        } else if (connectResult.getTarget() != null) {
            RegisteredServer newTarget = ((VelocityServer)connectResult.getTarget()).getServer();
            event.setResult(ServerPreConnectEvent.ServerResult.allowed((RegisteredServer)newTarget));
        }
    }

    @Override
    protected void broadcastJoinNotification(String name) {
        this.sendJoinMessage(this.plugin.getServer().getAllPlayers(), name);
    }

    @Override
    protected void broadcastJoinNotification(String name, Server server) {
        this.sendJoinMessage(((VelocityServer)server).getServer().getPlayersConnected(), name);
    }

    private void sendJoinMessage(Iterable<Player> players, String name) {
        Component message = ComponentUtil.toVelocity(this.settings.getMessage("joinNotification", "%PLAYER%", name));
        for (Player player : players) {
            if (!this.plugin.hasPermission((CommandSource)player, "joinnotification")) continue;
            player.sendMessage(message);
        }
    }
}

