/*
 * Decompiled with CFR 0.152.
 */
package eu.kennytv.maintenance.velocity.listener;

import com.velocitypowered.api.event.EventHandler;
import com.velocitypowered.api.event.proxy.ProxyPingEvent;
import com.velocitypowered.api.proxy.server.ServerPing;
import eu.kennytv.maintenance.core.proxy.SettingsProxy;
import eu.kennytv.maintenance.velocity.MaintenanceVelocityPlugin;
import eu.kennytv.maintenance.velocity.util.ComponentUtil;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public final class ProxyPingListener
implements EventHandler<ProxyPingEvent> {
    private static final UUID ZERO_UUID = new UUID(0L, 0L);
    private final MaintenanceVelocityPlugin plugin;
    private final SettingsProxy settings;

    public ProxyPingListener(MaintenanceVelocityPlugin plugin, SettingsProxy settings) {
        this.plugin = plugin;
        this.settings = settings;
    }

    public void execute(ProxyPingEvent event) {
        String host;
        Map forcedHosts = this.plugin.getServer().getConfiguration().getForcedHosts();
        boolean maintenanceEnabledOnHost = false;
        if (event.getConnection().getVirtualHost().isPresent() && forcedHosts.containsKey(host = ((InetSocketAddress)event.getConnection().getVirtualHost().get()).getHostName())) {
            List forcedHostTargets = (List)forcedHosts.get(host);
            Set<String> maintenanceServers = this.settings.getMaintenanceServers();
            for (String forcedHostTarget : forcedHostTargets) {
                if (!maintenanceServers.contains(forcedHostTarget)) continue;
                maintenanceEnabledOnHost = true;
                break;
            }
        }
        if (!this.settings.isMaintenance() && !maintenanceEnabledOnHost) {
            return;
        }
        ServerPing ping = event.getPing();
        ServerPing.Builder builder = ping.asBuilder();
        if (this.settings.hasCustomPlayerCountMessage()) {
            builder.version(new ServerPing.Version(1, this.settings.getLegacyParsedPlayerCountMessage()));
        }
        if (this.settings.hasCustomPlayerCountHoverMessage()) {
            String[] lines = this.settings.getLegacyParsedPlayerCountHoverLines();
            ServerPing.SamplePlayer[] samplePlayers = new ServerPing.SamplePlayer[lines.length];
            for (int i = 0; i < lines.length; ++i) {
                samplePlayers[i] = new ServerPing.SamplePlayer(lines[i], ZERO_UUID);
            }
            builder.samplePlayers(samplePlayers);
        }
        if (this.settings.isEnablePingMessages()) {
            builder.description(ComponentUtil.toVelocity(this.settings.getRandomPingMessage()));
        }
        if (this.settings.hasCustomIcon() && this.plugin.getFavicon() != null) {
            builder.favicon(this.plugin.getFavicon());
        }
        event.setPing(builder.build());
    }
}

