/*
 * Decompiled with CFR 0.152.
 */
package eu.kennytv.maintenance.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.event.EventHandler;
import com.velocitypowered.api.event.EventManager;
import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyPingEvent;
import com.velocitypowered.api.event.proxy.ProxyReloadEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Dependency;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.PluginManager;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.util.Favicon;
import eu.kennytv.maintenance.api.proxy.Server;
import eu.kennytv.maintenance.core.dump.PluginDump;
import eu.kennytv.maintenance.core.hook.ServerListPlusHook;
import eu.kennytv.maintenance.core.proxy.MaintenanceProxyPlugin;
import eu.kennytv.maintenance.core.proxy.SettingsProxy;
import eu.kennytv.maintenance.core.proxy.util.ProfileLookup;
import eu.kennytv.maintenance.core.proxy.util.ProxyOfflineSenderInfo;
import eu.kennytv.maintenance.core.util.SenderInfo;
import eu.kennytv.maintenance.core.util.ServerType;
import eu.kennytv.maintenance.core.util.Task;
import eu.kennytv.maintenance.lib.bstats.velocity.Metrics;
import eu.kennytv.maintenance.velocity.command.MaintenanceVelocityCommand;
import eu.kennytv.maintenance.velocity.listener.ProxyPingListener;
import eu.kennytv.maintenance.velocity.listener.ServerConnectListener;
import eu.kennytv.maintenance.velocity.util.ComponentUtil;
import eu.kennytv.maintenance.velocity.util.LoggerWrapper;
import eu.kennytv.maintenance.velocity.util.VelocitySenderInfo;
import eu.kennytv.maintenance.velocity.util.VelocityServer;
import eu.kennytv.maintenance.velocity.util.VelocityTask;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Plugin(id="maintenance", name="Maintenance", version="4.2.1", authors={"kennytv"}, description="Enable maintenance mode with a custom maintenance motd and icon.", url="https://hangar.papermc.io/kennytv/Maintenance", dependencies={@Dependency(id="serverlistplus", optional=true), @Dependency(id="luckperms", optional=true)})
public final class MaintenanceVelocityPlugin
extends MaintenanceProxyPlugin {
    private final ProxyServer server;
    private final java.util.logging.Logger logger;
    private final File dataFolder;
    private final Metrics.Factory metricsFactory;
    private Favicon favicon;

    @Inject
    public MaintenanceVelocityPlugin(ProxyServer server, Logger logger, @DataDirectory Path folder, Metrics.Factory metricsFactory) {
        super("4.2.1", ServerType.VELOCITY);
        this.server = server;
        this.logger = new LoggerWrapper(logger);
        this.dataFolder = folder.toFile();
        this.metricsFactory = metricsFactory;
    }

    @Subscribe
    public void onEnable(ProxyInitializeEvent event) {
        this.settingsProxy = new SettingsProxy(this);
        this.settings = this.settingsProxy;
        this.metricsFactory.make(this, 16502);
        this.sendEnableMessage();
        MaintenanceVelocityCommand command = new MaintenanceVelocityCommand(this, this.settingsProxy);
        this.commandManager = command;
        this.server.getCommandManager().register(this.server.getCommandManager().metaBuilder("maintenance").aliases(new String[]{"mt"}).build(), (Command)command);
        EventManager em = this.server.getEventManager();
        em.register((Object)this, ProxyPingEvent.class, PostOrder.LAST, (EventHandler)new ProxyPingListener(this, this.settingsProxy));
        em.register((Object)this, (Object)new ServerConnectListener(this, this.settingsProxy));
        this.continueLastEndtimer();
        PluginManager pluginManager = this.server.getPluginManager();
        pluginManager.getPlugin("serverlistplus").flatMap(PluginContainer::getInstance).ifPresent(serverListPlus -> {
            this.serverListPlusHook = new ServerListPlusHook(serverListPlus);
            if (this.settings.isEnablePingMessages()) {
                this.serverListPlusHook.setEnabled(!this.settingsProxy.isMaintenance());
            }
            this.logger.info("Enabled ServerListPlus integration!");
        });
    }

    @Subscribe
    public void proxyReload(ProxyReloadEvent event) {
        this.settingsProxy.reloadConfigs();
        this.logger.info("Reloaded config files!");
    }

    @Subscribe
    public void onDisable(ProxyShutdownEvent event) {
        this.disable();
    }

    @Override
    public void sendUpdateNotification(SenderInfo sender) {
        TextComponent component = (TextComponent)this.translate(this.getPrefix()).append((Component)this.translate("\u00a7cDownload it at: \u00a76https://hangar.papermc.io/kennytv/Maintenance"));
        TextComponent clickText = (TextComponent)((TextComponent)this.translate(" \u00a77\u00a7l\u00a7o(CLICK ME)").clickEvent(ClickEvent.openUrl((String)"https://hangar.papermc.io/kennytv/Maintenance"))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)this.translate("\u00a7aDownload the latest version")));
        ((VelocitySenderInfo)sender).sendMessage((TextComponent)component.append((Component)clickText));
    }

    public boolean isMaintenance(RegisteredServer serverInfo) {
        return this.settingsProxy.isMaintenance(serverInfo.getServerInfo().getName());
    }

    @Override
    protected void kickPlayersFromProxy() {
        for (Player p : this.server.getAllPlayers()) {
            if (this.hasPermission((CommandSource)p, "bypass") || this.settingsProxy.isWhitelisted(p.getUniqueId())) continue;
            p.disconnect(ComponentUtil.toVelocity(this.settingsProxy.getKickMessage()));
        }
    }

    @Override
    protected void kickPlayers(Server server, Server fallback) {
        RegisteredServer fallbackServer = fallback != null ? ((VelocityServer)fallback).getServer() : null;
        boolean checkForFallback = fallbackServer != null && !this.isMaintenance(fallback);
        for (Player player : ((VelocityServer)server).getServer().getPlayersConnected()) {
            if (!this.hasPermission((CommandSource)player, "bypass") && !this.settingsProxy.isWhitelisted(player.getUniqueId())) {
                if (checkForFallback) {
                    player.sendMessage(ComponentUtil.toVelocity(this.settingsProxy.getMessage("singleMaintenanceActivated", "%SERVER%", server.getName())));
                    player.createConnectionRequest(fallbackServer).connect().whenComplete((result, e) -> {
                        if (!result.isSuccessful()) {
                            player.disconnect(ComponentUtil.toVelocity(this.settingsProxy.getFullServerKickMessage(server.getName())));
                        }
                    });
                    continue;
                }
                player.disconnect(ComponentUtil.toVelocity(this.settingsProxy.getFullServerKickMessage(server.getName())));
                continue;
            }
            player.sendMessage(ComponentUtil.toVelocity(this.settingsProxy.getMessage("singleMaintenanceActivated", "%SERVER%", server.getName())));
        }
    }

    @Override
    protected void kickPlayersTo(Server server) {
        RegisteredServer waitingServer = ((VelocityServer)server).getServer();
        for (Player player : this.server.getAllPlayers()) {
            if (this.hasPermission((CommandSource)player, "bypass") || this.settingsProxy.isWhitelisted(player.getUniqueId()) || player.getCurrentServer().isPresent() && ((ServerConnection)player.getCurrentServer().get()).getServerInfo().getName().equals(waitingServer.getServerInfo().getName())) continue;
            if (!this.isMaintenance(waitingServer)) {
                player.createConnectionRequest(waitingServer).connect().whenComplete((result, e) -> {
                    if (result.isSuccessful()) {
                        player.sendMessage(ComponentUtil.toVelocity(this.settingsProxy.getMessage("sentToWaitingServer", "%SERVER%", server.getName())));
                    } else {
                        player.disconnect(ComponentUtil.toVelocity(this.settingsProxy.getKickMessage()));
                    }
                });
                continue;
            }
            player.disconnect(ComponentUtil.toVelocity(this.settingsProxy.getKickMessage()));
        }
    }

    @Override
    public Task startMaintenanceRunnable(Runnable runnable) {
        return new VelocityTask(this.server.getScheduler().buildTask((Object)this, runnable).repeat(1L, TimeUnit.SECONDS).schedule());
    }

    @Override
    @Nullable
    public Server getServer(String server) {
        Optional serverInfo = this.server.getServer(server);
        return serverInfo.map(VelocityServer::new).orElse(null);
    }

    @Override
    public Set<String> getServers() {
        return this.server.getAllServers().stream().map(server -> server.getServerInfo().getName()).collect(Collectors.toSet());
    }

    @Override
    public CompletableFuture<@Nullable SenderInfo> getOfflinePlayer(String name) {
        Optional player = this.server.getPlayer(name);
        if (player.isPresent()) {
            return CompletableFuture.completedFuture(new VelocitySenderInfo((CommandSource)player.get()));
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                ProfileLookup profile = this.doUUIDLookup(name);
                return new ProxyOfflineSenderInfo(profile.getUuid(), profile.getName());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public CompletableFuture<@Nullable SenderInfo> getOfflinePlayer(UUID uuid) {
        Optional player = this.server.getPlayer(uuid);
        return CompletableFuture.completedFuture(player.map(VelocitySenderInfo::new).orElse(null));
    }

    @Override
    @Nullable
    public String getServerNameOf(SenderInfo sender) {
        Optional player = this.server.getPlayer(sender.getUuid());
        if (!player.isPresent() || !((Player)player.get()).getCurrentServer().isPresent()) {
            return null;
        }
        return ((ServerConnection)((Player)player.get()).getCurrentServer().get()).getServerInfo().getName();
    }

    @Override
    public void async(Runnable runnable) {
        this.server.getScheduler().buildTask((Object)this, runnable).schedule();
    }

    @Override
    protected void executeConsoleCommand(String command) {
        this.server.getCommandManager().executeAsync((CommandSource)this.server.getConsoleCommandSource(), command);
    }

    @Override
    public void broadcast(eu.kennytv.maintenance.lib.kyori.adventure.text.Component component) {
        Component message = ComponentUtil.toVelocity(component);
        this.server.getConsoleCommandSource().sendMessage(message);
        this.server.sendMessage(message);
    }

    @Override
    public File getDataFolder() {
        return this.dataFolder;
    }

    @Override
    public File getPluginFile() {
        return ((Path)((PluginContainer)this.server.getPluginManager().getPlugin("maintenance").orElseThrow(() -> new IllegalArgumentException("Couldn't get Maintenance instance. Custom/broken build?"))).getDescription().getSource().orElseThrow(IllegalArgumentException::new)).toFile();
    }

    @Override
    protected int getOnlinePlayers() {
        return this.server.getPlayerCount();
    }

    @Override
    protected int getMaxPlayers() {
        return this.server.getConfiguration().getShowMaxPlayers();
    }

    @Override
    public java.util.logging.Logger getLogger() {
        return this.logger;
    }

    @Override
    public String getServerVersion() {
        return this.server.getVersion().getVersion();
    }

    @Override
    public List<PluginDump> getPlugins() {
        return this.server.getPluginManager().getPlugins().stream().map(plugin -> new PluginDump(plugin.getDescription().getId() + "/" + plugin.getDescription().getName().orElse("-"), plugin.getDescription().getVersion().orElse("-"), plugin.getDescription().getAuthors())).collect(Collectors.toList());
    }

    @Override
    protected void loadIcon(File file) throws IOException {
        this.favicon = Favicon.create((BufferedImage)ImageIO.read(file));
    }

    public boolean hasPermission(CommandSource sender, String permission) {
        return sender.hasPermission("maintenance." + permission) || sender.hasPermission("maintenance.admin");
    }

    public ProxyServer getServer() {
        return this.server;
    }

    public Favicon getFavicon() {
        return this.favicon;
    }

    @Deprecated
    public TextComponent translate(String s) {
        return LegacyComponentSerializer.legacySection().deserialize(s);
    }

    private static /* synthetic */ String lambda$onEnable$2(Player player) {
        return player.getCurrentServer().map(server -> server.getServerInfo().getName()).orElse(null);
    }
}

