/*
 * Decompiled with CFR 0.152.
 */
package eu.kennytv.maintenance.lib.mysql.cj.result;

import eu.kennytv.maintenance.lib.mysql.cj.Messages;
import eu.kennytv.maintenance.lib.mysql.cj.WarningListener;
import eu.kennytv.maintenance.lib.mysql.cj.conf.PropertySet;
import eu.kennytv.maintenance.lib.mysql.cj.exceptions.DataReadException;
import eu.kennytv.maintenance.lib.mysql.cj.protocol.InternalDate;
import eu.kennytv.maintenance.lib.mysql.cj.protocol.InternalTime;
import eu.kennytv.maintenance.lib.mysql.cj.protocol.InternalTimestamp;
import eu.kennytv.maintenance.lib.mysql.cj.result.AbstractDateTimeValueFactory;
import java.time.LocalTime;

public class LocalTimeValueFactory
extends AbstractDateTimeValueFactory<LocalTime> {
    private WarningListener warningListener;

    public LocalTimeValueFactory(PropertySet pset) {
        super(pset);
    }

    public LocalTimeValueFactory(PropertySet pset, WarningListener warningListener) {
        this(pset);
        this.warningListener = warningListener;
    }

    @Override
    LocalTime localCreateFromDate(InternalDate idate) {
        return LocalTime.of(0, 0);
    }

    @Override
    public LocalTime localCreateFromTime(InternalTime it) {
        if (it.getHours() < 0 || it.getHours() >= 24) {
            throw new DataReadException(Messages.getString("ResultSet.InvalidTimeValue", new Object[]{it.toString()}));
        }
        return LocalTime.of(it.getHours(), it.getMinutes(), it.getSeconds(), it.getNanos());
    }

    @Override
    public LocalTime localCreateFromTimestamp(InternalTimestamp its) {
        if (this.warningListener != null) {
            this.warningListener.warningEncountered(Messages.getString("ResultSet.PrecisionLostWarning", new Object[]{this.getTargetTypeName()}));
        }
        return (LocalTime)this.createFromTime(new InternalTime(its.getHours(), its.getMinutes(), its.getSeconds(), its.getNanos(), its.getScale()));
    }

    @Override
    public LocalTime localCreateFromDatetime(InternalTimestamp its) {
        if (this.warningListener != null) {
            this.warningListener.warningEncountered(Messages.getString("ResultSet.PrecisionLostWarning", new Object[]{this.getTargetTypeName()}));
        }
        return (LocalTime)this.createFromTime(new InternalTime(its.getHours(), its.getMinutes(), its.getSeconds(), its.getNanos(), its.getScale()));
    }

    @Override
    public String getTargetTypeName() {
        return LocalTime.class.getName();
    }
}

