/*
 * Decompiled with CFR 0.152.
 */
package eu.kennytv.maintenance.lib.mysql.cj.protocol.a;

import eu.kennytv.maintenance.lib.mysql.cj.conf.PropertyKey;
import eu.kennytv.maintenance.lib.mysql.cj.protocol.ColumnDefinition;
import eu.kennytv.maintenance.lib.mysql.cj.protocol.ProtocolEntityFactory;
import eu.kennytv.maintenance.lib.mysql.cj.protocol.ProtocolEntityReader;
import eu.kennytv.maintenance.lib.mysql.cj.protocol.Resultset;
import eu.kennytv.maintenance.lib.mysql.cj.protocol.ResultsetRow;
import eu.kennytv.maintenance.lib.mysql.cj.protocol.a.ColumnDefinitionFactory;
import eu.kennytv.maintenance.lib.mysql.cj.protocol.a.NativeConstants;
import eu.kennytv.maintenance.lib.mysql.cj.protocol.a.NativePacketPayload;
import eu.kennytv.maintenance.lib.mysql.cj.protocol.a.NativeProtocol;
import eu.kennytv.maintenance.lib.mysql.cj.protocol.a.TextRowFactory;
import eu.kennytv.maintenance.lib.mysql.cj.protocol.a.result.AbstractResultsetRows;
import eu.kennytv.maintenance.lib.mysql.cj.protocol.a.result.OkPacket;
import eu.kennytv.maintenance.lib.mysql.cj.protocol.a.result.ResultsetRowsStatic;
import eu.kennytv.maintenance.lib.mysql.cj.protocol.a.result.ResultsetRowsStreaming;
import java.io.IOException;
import java.util.ArrayList;

public class TextResultsetReader
implements ProtocolEntityReader<Resultset, NativePacketPayload> {
    protected NativeProtocol protocol;

    public TextResultsetReader(NativeProtocol prot) {
        this.protocol = prot;
    }

    @Override
    public Resultset read(int maxRows, boolean streamResults, NativePacketPayload resultPacket, ColumnDefinition metadata, ProtocolEntityFactory<Resultset, NativePacketPayload> resultSetFactory) throws IOException {
        Resultset rs = null;
        long columnCount = resultPacket.readInteger(NativeConstants.IntegerDataType.INT_LENENC);
        if (columnCount > 0L) {
            ColumnDefinition cdef = this.protocol.read(ColumnDefinition.class, new ColumnDefinitionFactory(columnCount, metadata));
            if (!this.protocol.getServerSession().isEOFDeprecated()) {
                this.protocol.skipPacket();
            }
            AbstractResultsetRows rows = null;
            if (!streamResults) {
                TextRowFactory trf = new TextRowFactory(this.protocol, cdef, resultSetFactory.getResultSetConcurrency(), false);
                ArrayList<ResultsetRow> rowList = new ArrayList<ResultsetRow>();
                ResultsetRow row = this.protocol.read(ResultsetRow.class, trf);
                while (row != null) {
                    if (maxRows == -1 || rowList.size() < maxRows) {
                        rowList.add(row);
                    }
                    row = this.protocol.read(ResultsetRow.class, trf);
                }
                rows = new ResultsetRowsStatic(rowList, cdef);
            } else {
                rows = new ResultsetRowsStreaming<Resultset>(this.protocol, cdef, false, resultSetFactory);
                this.protocol.setStreamingData(rows);
            }
            rs = resultSetFactory.createFromProtocolEntity(rows);
        } else {
            if (columnCount == -1L) {
                String charEncoding = this.protocol.getPropertySet().getStringProperty(PropertyKey.characterEncoding).getValue();
                String fileName = resultPacket.readString(NativeConstants.StringSelfDataType.STRING_TERM, this.protocol.getServerSession().getCharsetSettings().doesPlatformDbCharsetMatches() ? charEncoding : null);
                resultPacket = this.protocol.sendFileToServer(fileName);
            }
            OkPacket ok = (OkPacket)this.protocol.readServerStatusForResultSets(resultPacket, false);
            rs = resultSetFactory.createFromProtocolEntity(ok);
        }
        return rs;
    }
}

