/*
 * Decompiled with CFR 0.152.
 */
package eu.kennytv.maintenance.lib.mysql.cj.protocol.a;

import eu.kennytv.maintenance.lib.mysql.cj.conf.PropertyKey;
import eu.kennytv.maintenance.lib.mysql.cj.protocol.ColumnDefinition;
import eu.kennytv.maintenance.lib.mysql.cj.protocol.ProtocolEntityFactory;
import eu.kennytv.maintenance.lib.mysql.cj.protocol.ProtocolEntityReader;
import eu.kennytv.maintenance.lib.mysql.cj.protocol.Resultset;
import eu.kennytv.maintenance.lib.mysql.cj.protocol.ResultsetRow;
import eu.kennytv.maintenance.lib.mysql.cj.protocol.a.BinaryRowFactory;
import eu.kennytv.maintenance.lib.mysql.cj.protocol.a.MergingColumnDefinitionFactory;
import eu.kennytv.maintenance.lib.mysql.cj.protocol.a.NativeConstants;
import eu.kennytv.maintenance.lib.mysql.cj.protocol.a.NativePacketPayload;
import eu.kennytv.maintenance.lib.mysql.cj.protocol.a.NativeProtocol;
import eu.kennytv.maintenance.lib.mysql.cj.protocol.a.result.AbstractResultsetRows;
import eu.kennytv.maintenance.lib.mysql.cj.protocol.a.result.OkPacket;
import eu.kennytv.maintenance.lib.mysql.cj.protocol.a.result.ResultsetRowsCursor;
import eu.kennytv.maintenance.lib.mysql.cj.protocol.a.result.ResultsetRowsStatic;
import eu.kennytv.maintenance.lib.mysql.cj.protocol.a.result.ResultsetRowsStreaming;
import java.io.IOException;
import java.util.ArrayList;

public class BinaryResultsetReader
implements ProtocolEntityReader<Resultset, NativePacketPayload> {
    protected NativeProtocol protocol;

    public BinaryResultsetReader(NativeProtocol prot) {
        this.protocol = prot;
    }

    @Override
    public Resultset read(int maxRows, boolean streamResults, NativePacketPayload resultPacket, ColumnDefinition metadata, ProtocolEntityFactory<Resultset, NativePacketPayload> resultSetFactory) throws IOException {
        Resultset rs = null;
        long columnCount = resultPacket.readInteger(NativeConstants.IntegerDataType.INT_LENENC);
        if (columnCount > 0L) {
            boolean isCursorPossible;
            ColumnDefinition cdef = this.protocol.read(ColumnDefinition.class, new MergingColumnDefinitionFactory(columnCount, metadata));
            boolean bl = isCursorPossible = this.protocol.getPropertySet().getBooleanProperty(PropertyKey.useCursorFetch).getValue() != false && resultSetFactory.getResultSetType() == Resultset.Type.FORWARD_ONLY && resultSetFactory.getFetchSize() > 0;
            if (isCursorPossible || !this.protocol.getServerSession().isEOFDeprecated()) {
                NativePacketPayload rowPacket = this.protocol.probeMessage(this.protocol.getReusablePacket());
                this.protocol.checkErrorMessage(rowPacket);
                if (rowPacket.isResultSetOKPacket() || rowPacket.isEOFPacket()) {
                    rowPacket = this.protocol.readMessage(this.protocol.getReusablePacket());
                    this.protocol.readServerStatusForResultSets(rowPacket, true);
                } else {
                    isCursorPossible = false;
                }
            }
            AbstractResultsetRows rows = null;
            if (isCursorPossible && this.protocol.getServerSession().cursorExists()) {
                rows = new ResultsetRowsCursor(this.protocol, cdef);
            } else if (!streamResults) {
                BinaryRowFactory brf = new BinaryRowFactory(this.protocol, cdef, resultSetFactory.getResultSetConcurrency(), false);
                ArrayList<ResultsetRow> rowList = new ArrayList<ResultsetRow>();
                ResultsetRow row = this.protocol.read(ResultsetRow.class, brf);
                while (row != null) {
                    if (maxRows == -1 || rowList.size() < maxRows) {
                        rowList.add(row);
                    }
                    row = this.protocol.read(ResultsetRow.class, brf);
                }
                rows = new ResultsetRowsStatic(rowList, cdef);
            } else {
                rows = new ResultsetRowsStreaming<Resultset>(this.protocol, cdef, true, resultSetFactory);
                this.protocol.setStreamingData(rows);
            }
            rs = resultSetFactory.createFromProtocolEntity(rows);
        } else {
            if (columnCount == -1L) {
                String charEncoding = this.protocol.getPropertySet().getStringProperty(PropertyKey.characterEncoding).getValue();
                String fileName = resultPacket.readString(NativeConstants.StringSelfDataType.STRING_TERM, this.protocol.getServerSession().getCharsetSettings().doesPlatformDbCharsetMatches() ? null : charEncoding);
                resultPacket = this.protocol.sendFileToServer(fileName);
            }
            OkPacket ok = (OkPacket)this.protocol.readServerStatusForResultSets(resultPacket, false);
            rs = resultSetFactory.createFromProtocolEntity(ok);
        }
        return rs;
    }
}

