/*
 * Decompiled with CFR 0.152.
 */
package eu.kennytv.maintenance.lib.mysql.cj.jdbc;

import eu.kennytv.maintenance.lib.mysql.cj.CancelQueryTask;
import eu.kennytv.maintenance.lib.mysql.cj.Messages;
import eu.kennytv.maintenance.lib.mysql.cj.MysqlType;
import eu.kennytv.maintenance.lib.mysql.cj.NativeSession;
import eu.kennytv.maintenance.lib.mysql.cj.PingTarget;
import eu.kennytv.maintenance.lib.mysql.cj.Query;
import eu.kennytv.maintenance.lib.mysql.cj.QueryAttributesBindings;
import eu.kennytv.maintenance.lib.mysql.cj.QueryInfo;
import eu.kennytv.maintenance.lib.mysql.cj.QueryReturnType;
import eu.kennytv.maintenance.lib.mysql.cj.Session;
import eu.kennytv.maintenance.lib.mysql.cj.SimpleQuery;
import eu.kennytv.maintenance.lib.mysql.cj.TransactionEventHandler;
import eu.kennytv.maintenance.lib.mysql.cj.conf.HostInfo;
import eu.kennytv.maintenance.lib.mysql.cj.conf.PropertyDefinitions;
import eu.kennytv.maintenance.lib.mysql.cj.conf.PropertyKey;
import eu.kennytv.maintenance.lib.mysql.cj.conf.RuntimeProperty;
import eu.kennytv.maintenance.lib.mysql.cj.exceptions.AssertionFailedException;
import eu.kennytv.maintenance.lib.mysql.cj.exceptions.CJException;
import eu.kennytv.maintenance.lib.mysql.cj.exceptions.CJOperationNotSupportedException;
import eu.kennytv.maintenance.lib.mysql.cj.exceptions.CJTimeoutException;
import eu.kennytv.maintenance.lib.mysql.cj.exceptions.ExceptionFactory;
import eu.kennytv.maintenance.lib.mysql.cj.exceptions.ExceptionInterceptor;
import eu.kennytv.maintenance.lib.mysql.cj.exceptions.OperationCancelledException;
import eu.kennytv.maintenance.lib.mysql.cj.exceptions.StatementIsClosedException;
import eu.kennytv.maintenance.lib.mysql.cj.jdbc.EscapeProcessor;
import eu.kennytv.maintenance.lib.mysql.cj.jdbc.EscapeProcessorResult;
import eu.kennytv.maintenance.lib.mysql.cj.jdbc.JdbcConnection;
import eu.kennytv.maintenance.lib.mysql.cj.jdbc.JdbcPreparedStatement;
import eu.kennytv.maintenance.lib.mysql.cj.jdbc.JdbcPropertySet;
import eu.kennytv.maintenance.lib.mysql.cj.jdbc.JdbcStatement;
import eu.kennytv.maintenance.lib.mysql.cj.jdbc.exceptions.MySQLStatementCancelledException;
import eu.kennytv.maintenance.lib.mysql.cj.jdbc.exceptions.MySQLTimeoutException;
import eu.kennytv.maintenance.lib.mysql.cj.jdbc.exceptions.SQLError;
import eu.kennytv.maintenance.lib.mysql.cj.jdbc.exceptions.SQLExceptionsMapping;
import eu.kennytv.maintenance.lib.mysql.cj.jdbc.result.CachedResultSetMetaData;
import eu.kennytv.maintenance.lib.mysql.cj.jdbc.result.ResultSetFactory;
import eu.kennytv.maintenance.lib.mysql.cj.jdbc.result.ResultSetImpl;
import eu.kennytv.maintenance.lib.mysql.cj.jdbc.result.ResultSetInternalMethods;
import eu.kennytv.maintenance.lib.mysql.cj.protocol.Message;
import eu.kennytv.maintenance.lib.mysql.cj.protocol.ProtocolEntityFactory;
import eu.kennytv.maintenance.lib.mysql.cj.protocol.Resultset;
import eu.kennytv.maintenance.lib.mysql.cj.protocol.a.NativeMessageBuilder;
import eu.kennytv.maintenance.lib.mysql.cj.protocol.a.result.ByteArrayRow;
import eu.kennytv.maintenance.lib.mysql.cj.protocol.a.result.ResultsetRowsStatic;
import eu.kennytv.maintenance.lib.mysql.cj.result.DefaultColumnDefinition;
import eu.kennytv.maintenance.lib.mysql.cj.result.Field;
import eu.kennytv.maintenance.lib.mysql.cj.result.Row;
import eu.kennytv.maintenance.lib.mysql.cj.util.StringUtils;
import eu.kennytv.maintenance.lib.mysql.cj.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class StatementImpl
implements JdbcStatement {
    protected static final String PING_MARKER = "/* ping */";
    public static final byte USES_VARIABLES_FALSE = 0;
    public static final byte USES_VARIABLES_TRUE = 1;
    public static final byte USES_VARIABLES_UNKNOWN = -1;
    protected NativeMessageBuilder commandBuilder = null;
    protected String charEncoding = null;
    protected volatile JdbcConnection connection = null;
    protected boolean doEscapeProcessing = true;
    protected boolean isClosed = false;
    protected long lastInsertId = -1L;
    protected int maxFieldSize = (Integer)PropertyDefinitions.getPropertyDefinition(PropertyKey.maxAllowedPacket).getDefaultValue();
    public int maxRows = -1;
    protected Set<ResultSetInternalMethods> openResults = new HashSet<ResultSetInternalMethods>();
    protected boolean pedantic = false;
    protected boolean profileSQL = false;
    protected ResultSetInternalMethods results = null;
    protected ResultSetInternalMethods generatedKeysResults = null;
    protected int resultSetConcurrency = 0;
    protected long updateCount = -1L;
    protected boolean useUsageAdvisor = false;
    protected SQLWarning warningChain = null;
    protected boolean holdResultsOpenOverClose = false;
    protected ArrayList<Row> batchedGeneratedKeys = null;
    protected boolean retrieveGeneratedKeys = false;
    protected boolean continueBatchOnError = false;
    protected PingTarget pingTarget = null;
    protected ExceptionInterceptor exceptionInterceptor;
    protected boolean lastQueryIsOnDupKeyUpdate = false;
    private boolean isImplicitlyClosingResults = false;
    protected RuntimeProperty<Boolean> dontTrackOpenResources;
    protected RuntimeProperty<Boolean> dumpQueriesOnException;
    protected boolean logSlowQueries = false;
    protected RuntimeProperty<Boolean> rewriteBatchedStatements;
    protected RuntimeProperty<Integer> maxAllowedPacket;
    protected boolean dontCheckOnDuplicateKeyUpdateInSQL;
    protected ResultSetFactory resultSetFactory;
    protected Query query;
    protected NativeSession session = null;
    private Resultset.Type originalResultSetType = Resultset.Type.FORWARD_ONLY;
    private int originalFetchSize = 0;
    private boolean isPoolable = false;
    private boolean closeOnCompletion = false;

    public StatementImpl(JdbcConnection c, String db) throws SQLException {
        int maxRowsConn;
        int defaultFetchSize;
        if (c == null || c.isClosed()) {
            throw SQLError.createSQLException(Messages.getString("Statement.0"), "08003", null);
        }
        this.connection = c;
        this.session = (NativeSession)c.getSession();
        this.exceptionInterceptor = c.getExceptionInterceptor();
        this.commandBuilder = new NativeMessageBuilder(this.session.getServerSession().supportsQueryAttributes());
        try {
            this.initQuery();
        }
        catch (CJException e) {
            throw SQLExceptionsMapping.translateException(e, this.getExceptionInterceptor());
        }
        this.query.setCurrentDatabase(db);
        JdbcPropertySet pset = c.getPropertySet();
        this.dontTrackOpenResources = pset.getBooleanProperty(PropertyKey.dontTrackOpenResources);
        this.dumpQueriesOnException = pset.getBooleanProperty(PropertyKey.dumpQueriesOnException);
        this.continueBatchOnError = pset.getBooleanProperty(PropertyKey.continueBatchOnError).getValue();
        this.pedantic = pset.getBooleanProperty(PropertyKey.pedantic).getValue();
        this.rewriteBatchedStatements = pset.getBooleanProperty(PropertyKey.rewriteBatchedStatements);
        this.charEncoding = pset.getStringProperty(PropertyKey.characterEncoding).getValue();
        this.profileSQL = pset.getBooleanProperty(PropertyKey.profileSQL).getValue();
        this.useUsageAdvisor = pset.getBooleanProperty(PropertyKey.useUsageAdvisor).getValue();
        this.logSlowQueries = pset.getBooleanProperty(PropertyKey.logSlowQueries).getValue();
        this.maxAllowedPacket = pset.getIntegerProperty(PropertyKey.maxAllowedPacket);
        this.dontCheckOnDuplicateKeyUpdateInSQL = pset.getBooleanProperty(PropertyKey.dontCheckOnDuplicateKeyUpdateInSQL).getValue();
        this.doEscapeProcessing = pset.getBooleanProperty(PropertyKey.enableEscapeProcessing).getValue();
        this.maxFieldSize = this.maxAllowedPacket.getValue();
        if (!this.dontTrackOpenResources.getValue().booleanValue()) {
            c.registerStatement(this);
        }
        if ((defaultFetchSize = pset.getIntegerProperty(PropertyKey.defaultFetchSize).getValue().intValue()) != 0) {
            this.setFetchSize(defaultFetchSize);
        }
        if ((maxRowsConn = pset.getIntegerProperty(PropertyKey.maxRows).getValue().intValue()) != -1) {
            this.setMaxRows(maxRowsConn);
        }
        this.holdResultsOpenOverClose = pset.getBooleanProperty(PropertyKey.holdResultsOpenOverStatementClose).getValue();
        this.resultSetFactory = new ResultSetFactory(this.connection, this);
    }

    protected void initQuery() {
        this.query = new SimpleQuery(this.session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBatch(String sql) throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                if (sql != null) {
                    this.query.addBatch(sql);
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void addBatch(Object batch) {
        this.query.addBatch(batch);
    }

    @Override
    public List<Object> getBatchedArgs() {
        return this.query.getBatchedArgs();
    }

    @Override
    public void cancel() throws SQLException {
        try {
            if (!this.query.getStatementExecuting().get()) {
                return;
            }
            if (!this.isClosed && this.connection != null) {
                NativeSession newSession = null;
                try {
                    HostInfo hostInfo = this.session.getHostInfo();
                    String database = hostInfo.getDatabase();
                    String user = hostInfo.getUser();
                    String password = hostInfo.getPassword();
                    newSession = new NativeSession(this.session.getHostInfo(), this.session.getPropertySet());
                    newSession.connect(hostInfo, user, password, database, 30000, new TransactionEventHandler(){

                        @Override
                        public void transactionCompleted() {
                        }

                        @Override
                        public void transactionBegun() {
                        }
                    });
                    newSession.getProtocol().sendCommand(new NativeMessageBuilder(newSession.getServerSession().supportsQueryAttributes()).buildComQuery(newSession.getSharedSendPacket(), "KILL QUERY " + this.session.getThreadId()), false, 0);
                    this.setCancelStatus(Query.CancelStatus.CANCELED_BY_USER);
                }
                catch (IOException e) {
                    throw SQLExceptionsMapping.translateException(e, this.exceptionInterceptor);
                }
                finally {
                    if (newSession != null) {
                        newSession.forceClose();
                    }
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    protected JdbcConnection checkClosed() {
        JdbcConnection c = this.connection;
        if (c == null) {
            throw ExceptionFactory.createException(StatementIsClosedException.class, Messages.getString("Statement.AlreadyClosed"), this.getExceptionInterceptor());
        }
        return c;
    }

    protected boolean isResultSetProducingQuery(String sql) {
        QueryReturnType queryReturnType = QueryInfo.getQueryReturnType(sql, this.session.getServerSession().isNoBackslashEscapesSet());
        return queryReturnType == QueryReturnType.PRODUCES_RESULT_SET || queryReturnType == QueryReturnType.MAY_PRODUCE_RESULT_SET;
    }

    protected boolean isNonResultSetProducingQuery(String sql) {
        QueryReturnType queryReturnType = QueryInfo.getQueryReturnType(sql, this.session.getServerSession().isNoBackslashEscapesSet());
        return queryReturnType == QueryReturnType.DOES_NOT_PRODUCE_RESULT_SET || queryReturnType == QueryReturnType.MAY_PRODUCE_RESULT_SET;
    }

    protected void checkNullOrEmptyQuery(String sql) throws SQLException {
        if (sql == null) {
            throw SQLError.createSQLException(Messages.getString("Statement.59"), "S1009", this.getExceptionInterceptor());
        }
        if (sql.length() == 0) {
            throw SQLError.createSQLException(Messages.getString("Statement.61"), "S1009", this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearBatch() throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                this.query.clearBatchedArgs();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void clearBatchedArgs() {
        this.query.clearBatchedArgs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearWarnings() throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                this.setClearWarningsCalled(true);
                this.warningChain = null;
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this.realClose(true, true);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeAllOpenResults() throws SQLException {
        JdbcConnection locallyScopedConn = this.connection;
        if (locallyScopedConn == null) {
            return;
        }
        Object object = locallyScopedConn.getConnectionMutex();
        synchronized (object) {
            if (this.openResults != null) {
                for (ResultSetInternalMethods element : this.openResults) {
                    try {
                        element.realClose(false);
                    }
                    catch (SQLException sqlEx) {
                        AssertionFailedException.shouldNotHappen(sqlEx);
                    }
                }
                this.openResults.clear();
            }
        }
    }

    protected void implicitlyCloseAllOpenResults() throws SQLException {
        this.isImplicitlyClosingResults = true;
        try {
            if (!this.holdResultsOpenOverClose && !this.dontTrackOpenResources.getValue().booleanValue()) {
                if (this.results != null) {
                    this.results.realClose(false);
                }
                if (this.generatedKeysResults != null) {
                    this.generatedKeysResults.realClose(false);
                }
                this.closeAllOpenResults();
            }
        }
        finally {
            this.isImplicitlyClosingResults = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeOpenResultSet(ResultSetInternalMethods rs) {
        try {
            try {
                Object object = this.checkClosed().getConnectionMutex();
                synchronized (object) {
                    boolean hasMoreResults;
                    if (this.openResults != null) {
                        this.openResults.remove(rs);
                    }
                    boolean bl = hasMoreResults = rs.getNextResultset() != null;
                    if (this.results == rs && !hasMoreResults) {
                        this.results = null;
                    }
                    if (this.generatedKeysResults == rs) {
                        this.generatedKeysResults = null;
                    }
                    if (!this.isImplicitlyClosingResults && !hasMoreResults) {
                        this.checkAndPerformCloseOnCompletionAction();
                    }
                }
            }
            catch (StatementIsClosedException statementIsClosedException) {
                // empty catch block
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOpenResultSetCount() {
        try {
            try {
                Object object = this.checkClosed().getConnectionMutex();
                synchronized (object) {
                    if (this.openResults != null) {
                        return this.openResults.size();
                    }
                    return 0;
                }
            }
            catch (StatementIsClosedException e) {
                return 0;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndPerformCloseOnCompletionAction() {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                if (!(!this.isCloseOnCompletion() || this.dontTrackOpenResources.getValue().booleanValue() || this.getOpenResultSetCount() != 0 || this.results != null && this.results.hasRows() && !this.results.isClosed() || this.generatedKeysResults != null && this.generatedKeysResults.hasRows() && !this.generatedKeysResults.isClosed())) {
                    this.realClose(false, false);
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSetInternalMethods createResultSetUsingServerFetch(String sql) throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                PreparedStatement pStmt = this.connection.prepareStatement(sql, this.query.getResultType().getIntValue(), this.resultSetConcurrency);
                pStmt.setFetchSize(this.query.getResultFetchSize());
                if (this.getQueryTimeout() > 0) {
                    pStmt.setQueryTimeout(this.getQueryTimeout());
                }
                if (this.maxRows > -1) {
                    pStmt.setMaxRows(this.maxRows);
                }
                this.statementBegins();
                pStmt.execute();
                ResultSetInternalMethods rs = ((JdbcStatement)((Object)pStmt)).getResultSetInternal();
                rs.setStatementUsedForFetchingRows((JdbcPreparedStatement)pStmt);
                this.results = rs;
                return rs;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    protected boolean createStreamingResultSet() {
        return this.query.getResultType() == Resultset.Type.FORWARD_ONLY && this.resultSetConcurrency == 1007 && this.query.getResultFetchSize() == Integer.MIN_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableStreamingResults() throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                this.originalResultSetType = this.query.getResultType();
                this.originalFetchSize = this.query.getResultFetchSize();
                this.setFetchSize(Integer.MIN_VALUE);
                this.setResultSetType(Resultset.Type.FORWARD_ONLY);
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableStreamingResults() throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                if (this.query.getResultFetchSize() == Integer.MIN_VALUE && this.query.getResultType() == Resultset.Type.FORWARD_ONLY) {
                    this.setFetchSize(this.originalFetchSize);
                    this.setResultSetType(this.originalResultSetType);
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    protected void setupStreamingTimeout(JdbcConnection con) throws SQLException {
        int netTimeoutForStreamingResults = this.session.getPropertySet().getIntegerProperty(PropertyKey.netTimeoutForStreamingResults).getValue();
        if (this.createStreamingResultSet() && netTimeoutForStreamingResults > 0) {
            this.executeSimpleNonQuery(con, "SET net_write_timeout=" + netTimeoutForStreamingResults);
        }
    }

    @Override
    public CancelQueryTask startQueryTimer(Query stmtToCancel, int timeout) {
        return this.query.startQueryTimer(stmtToCancel, timeout);
    }

    @Override
    public void stopQueryTimer(CancelQueryTask timeoutTask, boolean rethrowCancelReason, boolean checkCancelTimeout) {
        this.query.stopQueryTimer(timeoutTask, rethrowCancelReason, checkCancelTimeout);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        try {
            return this.executeInternal(sql, false);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean executeInternal(String sql, boolean returnGeneratedKeys) throws SQLException {
        try {
            JdbcConnection locallyScopedConn = this.checkClosed();
            Object object = locallyScopedConn.getConnectionMutex();
            synchronized (object) {
                this.checkClosed();
                this.checkNullOrEmptyQuery(sql);
                this.resetCancelledState();
                this.implicitlyCloseAllOpenResults();
                if (sql.charAt(0) == '/' && sql.startsWith(PING_MARKER)) {
                    this.doPingInstead();
                    return true;
                }
                this.retrieveGeneratedKeys = returnGeneratedKeys;
                boolean bl = this.lastQueryIsOnDupKeyUpdate = returnGeneratedKeys && QueryInfo.firstCharOfStatementUc(sql, this.session.getServerSession().isNoBackslashEscapesSet()) == 'I' && this.containsOnDuplicateKeyInString(sql);
                if (!QueryInfo.isReadOnlySafeQuery(sql, this.session.getServerSession().isNoBackslashEscapesSet()) && locallyScopedConn.isReadOnly()) {
                    throw SQLError.createSQLException(Messages.getString("Statement.27") + Messages.getString("Statement.28"), "S1009", this.getExceptionInterceptor());
                }
                try {
                    this.setupStreamingTimeout(locallyScopedConn);
                    if (this.doEscapeProcessing) {
                        Object escapedSqlResult = EscapeProcessor.escapeSQL(sql, this.session.getServerSession().getSessionTimeZone(), this.session.getServerSession().getCapabilities().serverSupportsFracSecs(), this.session.getServerSession().isServerTruncatesFracSecs(), this.getExceptionInterceptor());
                        sql = escapedSqlResult instanceof String ? (String)escapedSqlResult : ((EscapeProcessorResult)escapedSqlResult).escapedSql;
                    }
                    CachedResultSetMetaData cachedMetaData = null;
                    ResultSetInternalMethods rs = null;
                    this.batchedGeneratedKeys = null;
                    if (this.useServerFetch()) {
                        rs = this.createResultSetUsingServerFetch(sql);
                    } else {
                        CancelQueryTask timeoutTask = null;
                        String oldDb = null;
                        try {
                            timeoutTask = this.startQueryTimer(this, this.getTimeoutInMillis());
                            if (!locallyScopedConn.getDatabase().equals(this.getCurrentDatabase())) {
                                oldDb = locallyScopedConn.getDatabase();
                                locallyScopedConn.setDatabase(this.getCurrentDatabase());
                            }
                            if (locallyScopedConn.getPropertySet().getBooleanProperty(PropertyKey.cacheResultSetMetadata).getValue().booleanValue()) {
                                cachedMetaData = locallyScopedConn.getCachedMetaData(sql);
                            }
                            locallyScopedConn.setSessionMaxRows(this.isResultSetProducingQuery(sql) ? this.maxRows : -1);
                            this.statementBegins();
                            rs = (ResultSetInternalMethods)((NativeSession)locallyScopedConn.getSession()).execSQL(this, sql, this.maxRows, null, this.createStreamingResultSet(), this.getResultSetFactory(), cachedMetaData, false);
                            if (timeoutTask != null) {
                                this.stopQueryTimer(timeoutTask, true, true);
                                timeoutTask = null;
                            }
                        }
                        catch (CJTimeoutException | OperationCancelledException e) {
                            try {
                                throw SQLExceptionsMapping.translateException(e, this.exceptionInterceptor);
                            }
                            catch (Throwable throwable) {
                                this.stopQueryTimer(timeoutTask, false, false);
                                if (oldDb != null) {
                                    locallyScopedConn.setDatabase(oldDb);
                                }
                                throw throwable;
                            }
                        }
                        this.stopQueryTimer(timeoutTask, false, false);
                        if (oldDb != null) {
                            locallyScopedConn.setDatabase(oldDb);
                        }
                    }
                    if (rs != null) {
                        this.lastInsertId = rs.getUpdateID();
                        this.results = rs;
                        rs.setFirstCharOfQuery(QueryInfo.firstCharOfStatementUc(sql, this.session.getServerSession().isNoBackslashEscapesSet()));
                        if (rs.hasRows()) {
                            if (cachedMetaData != null) {
                                locallyScopedConn.initializeResultsMetadataFromCache(sql, cachedMetaData, this.results);
                            } else if (this.session.getPropertySet().getBooleanProperty(PropertyKey.cacheResultSetMetadata).getValue().booleanValue()) {
                                locallyScopedConn.initializeResultsMetadataFromCache(sql, null, this.results);
                            }
                        }
                    }
                    boolean bl2 = rs != null && rs.hasRows();
                    return bl2;
                }
                finally {
                    this.query.getStatementExecuting().set(false);
                }
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void statementBegins() {
        this.query.statementBegins();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetCancelledState() {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                this.query.resetCancelledState();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean execute(String sql, int returnGeneratedKeys) throws SQLException {
        try {
            return this.executeInternal(sql, returnGeneratedKeys == 1);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean execute(String sql, int[] generatedKeyIndices) throws SQLException {
        try {
            return this.executeInternal(sql, generatedKeyIndices != null && generatedKeyIndices.length > 0);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean execute(String sql, String[] generatedKeyNames) throws SQLException {
        try {
            return this.executeInternal(sql, generatedKeyNames != null && generatedKeyNames.length > 0);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try {
            return Util.truncateAndConvertToInt(this.executeBatchInternal());
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    protected long[] executeBatchInternal() throws SQLException {
        locallyScopedConn = this.checkClosed();
        var2_2 = locallyScopedConn.getConnectionMutex();
        synchronized (var2_2) {
            block24: {
                if (locallyScopedConn.isReadOnly()) {
                    throw SQLError.createSQLException(Messages.getString("Statement.34") + Messages.getString("Statement.35"), "S1009", this.getExceptionInterceptor());
                }
                this.implicitlyCloseAllOpenResults();
                batchedArgs = this.query.getBatchedArgs();
                if (batchedArgs == null || batchedArgs.size() == 0) {
                    return new long[0];
                }
                individualStatementTimeout = this.getTimeoutInMillis();
                this.setTimeoutInMillis(0);
                timeoutTask = null;
                this.resetCancelledState();
                this.statementBegins();
                this.retrieveGeneratedKeys = true;
                updateCounts = null;
                if (batchedArgs == null) ** GOTO lbl66
                nbrCommands = batchedArgs.size();
                this.batchedGeneratedKeys = new ArrayList<E>(batchedArgs.size());
                multiQueriesEnabled = locallyScopedConn.getPropertySet().getBooleanProperty(PropertyKey.allowMultiQueries).getValue();
                if (!multiQueriesEnabled && (!this.rewriteBatchedStatements.getValue().booleanValue() || nbrCommands <= 4)) break block24;
                var9_10 = this.executeBatchUsingMultiQueries(multiQueriesEnabled, nbrCommands, individualStatementTimeout);
                this.query.getStatementExecuting().set(false);
                this.stopQueryTimer(timeoutTask, false, false);
                this.resetCancelledState();
                this.setTimeoutInMillis(individualStatementTimeout);
                this.clearBatch();
                return var9_10;
            }
            try {
                timeoutTask = this.startQueryTimer(this, individualStatementTimeout);
                updateCounts = new long[nbrCommands];
                for (i = 0; i < nbrCommands; ++i) {
                    updateCounts[i] = -3L;
                }
                sqlEx = null;
                commandIndex = 0;
                for (commandIndex = 0; commandIndex < nbrCommands; ++commandIndex) {
                    try {
                        sql = (String)batchedArgs.get(commandIndex);
                        updateCounts[commandIndex] = this.executeUpdateInternal(sql, true, true);
                        if (timeoutTask != null) {
                            this.checkCancelTimeout();
                        }
                        this.getBatchedGeneratedKeys(this.results.getFirstCharOfQuery() == 'I' && this.containsOnDuplicateKeyInString(sql) != false ? 1 : 0);
                        continue;
                    }
                    catch (SQLException ex) {
                        updateCounts[commandIndex] = -3L;
                        if (this.continueBatchOnError && !(ex instanceof MySQLTimeoutException) && !(ex instanceof MySQLStatementCancelledException) && !this.hasDeadlockOrTimeoutRolledBackTx(ex)) {
                            sqlEx = ex;
                            continue;
                        }
                        newUpdateCounts = new long[commandIndex];
                        if (this.hasDeadlockOrTimeoutRolledBackTx(ex)) {
                            for (i = 0; i < newUpdateCounts.length; ++i) {
                                newUpdateCounts[i] = -3L;
                            }
                        } else {
                            System.arraycopy(updateCounts, 0, newUpdateCounts, 0, commandIndex);
                        }
                        sqlEx = ex;
                        break;
                    }
                }
                if (sqlEx != null) {
                    throw SQLError.createBatchUpdateException(sqlEx, updateCounts, this.getExceptionInterceptor());
                }
lbl66:
                // 3 sources

                if (timeoutTask != null) {
                    this.stopQueryTimer(timeoutTask, true, true);
                    timeoutTask = null;
                }
                var7_8 = updateCounts != null ? updateCounts : new long[]{};
                this.query.getStatementExecuting().set(false);
                {
                    catch (Throwable var14_18) {
                        this.query.getStatementExecuting().set(false);
                        throw var14_18;
                    }
                }
                return var7_8;
            }
            finally {
                this.stopQueryTimer(timeoutTask, false, false);
                this.resetCancelledState();
                this.setTimeoutInMillis(individualStatementTimeout);
                this.clearBatch();
            }
        }
    }

    protected final boolean hasDeadlockOrTimeoutRolledBackTx(SQLException ex) {
        int vendorCode = ex.getErrorCode();
        switch (vendorCode) {
            case 1206: 
            case 1213: {
                return true;
            }
            case 1205: {
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] executeBatchUsingMultiQueries(boolean multiQueriesEnabled, int nbrCommands, int individualStatementTimeout) throws SQLException {
        try {
            JdbcConnection locallyScopedConn = this.checkClosed();
            Object object = locallyScopedConn.getConnectionMutex();
            synchronized (object) {
                long[] lArray;
                if (!multiQueriesEnabled) {
                    this.session.enableMultiQueries();
                }
                Statement batchStmt = null;
                CancelQueryTask timeoutTask = null;
                try {
                    long[] updateCounts = new long[nbrCommands];
                    for (int i = 0; i < nbrCommands; ++i) {
                        updateCounts[i] = -3L;
                    }
                    int commandIndex = 0;
                    StringBuilder queryBuf = new StringBuilder();
                    batchStmt = locallyScopedConn.createStatement();
                    JdbcStatement jdbcBatchedStmt = (JdbcStatement)batchStmt;
                    this.getQueryAttributesBindings().runThroughAll(a -> jdbcBatchedStmt.setAttribute(a.getName(), a.getValue()));
                    timeoutTask = this.startQueryTimer((StatementImpl)batchStmt, individualStatementTimeout);
                    int counter = 0;
                    String connectionEncoding = locallyScopedConn.getPropertySet().getStringProperty(PropertyKey.characterEncoding).getValue();
                    int numberOfBytesPerChar = StringUtils.startsWithIgnoreCase(connectionEncoding, "utf") ? 3 : (this.session.getServerSession().getCharsetSettings().isMultibyteCharset(connectionEncoding) ? 2 : 1);
                    int escapeAdjust = 1;
                    batchStmt.setEscapeProcessing(this.doEscapeProcessing);
                    if (this.doEscapeProcessing) {
                        escapeAdjust = 2;
                    }
                    SQLException sqlEx = null;
                    int argumentSetsInBatchSoFar = 0;
                    for (commandIndex = 0; commandIndex < nbrCommands; ++commandIndex) {
                        String nextQuery = (String)this.query.getBatchedArgs().get(commandIndex);
                        if (((queryBuf.length() + nextQuery.length()) * numberOfBytesPerChar + 1 + 4) * escapeAdjust + 32 > this.maxAllowedPacket.getValue()) {
                            try {
                                batchStmt.execute(queryBuf.toString(), 1);
                            }
                            catch (SQLException ex) {
                                sqlEx = this.handleExceptionForBatch(commandIndex, argumentSetsInBatchSoFar, updateCounts, ex);
                            }
                            counter = this.processMultiCountsAndKeys((StatementImpl)batchStmt, counter, updateCounts);
                            queryBuf = new StringBuilder();
                            argumentSetsInBatchSoFar = 0;
                        }
                        queryBuf.append(nextQuery);
                        queryBuf.append(";");
                        ++argumentSetsInBatchSoFar;
                    }
                    if (queryBuf.length() > 0) {
                        try {
                            batchStmt.execute(queryBuf.toString(), 1);
                        }
                        catch (SQLException ex) {
                            sqlEx = this.handleExceptionForBatch(commandIndex - 1, argumentSetsInBatchSoFar, updateCounts, ex);
                        }
                        counter = this.processMultiCountsAndKeys((StatementImpl)batchStmt, counter, updateCounts);
                    }
                    if (timeoutTask != null) {
                        this.stopQueryTimer(timeoutTask, true, true);
                        timeoutTask = null;
                    }
                    if (sqlEx != null) {
                        throw SQLError.createBatchUpdateException(sqlEx, updateCounts, this.getExceptionInterceptor());
                    }
                    lArray = updateCounts != null ? updateCounts : new long[]{};
                    this.stopQueryTimer(timeoutTask, false, false);
                    this.resetCancelledState();
                }
                catch (Throwable throwable) {
                    this.stopQueryTimer(timeoutTask, false, false);
                    this.resetCancelledState();
                    try {
                        if (batchStmt != null) {
                            batchStmt.close();
                        }
                    }
                    finally {
                        if (!multiQueriesEnabled) {
                            this.session.disableMultiQueries();
                        }
                    }
                    throw throwable;
                }
                try {
                    if (batchStmt != null) {
                        batchStmt.close();
                    }
                }
                finally {
                    if (!multiQueriesEnabled) {
                        this.session.disableMultiQueries();
                    }
                }
                return lArray;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int processMultiCountsAndKeys(StatementImpl batchedStatement, int updateCountCounter, long[] updateCounts) throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                long generatedKey;
                updateCounts[updateCountCounter++] = batchedStatement.getLargeUpdateCount();
                boolean doGenKeys = this.batchedGeneratedKeys != null;
                Object row = null;
                if (doGenKeys) {
                    generatedKey = batchedStatement.getLastInsertID();
                    row = new byte[1][];
                    row[0] = StringUtils.getBytes(Long.toString(generatedKey));
                    this.batchedGeneratedKeys.add(new ByteArrayRow((byte[][])row, this.getExceptionInterceptor()));
                }
                while (batchedStatement.getMoreResults() || batchedStatement.getLargeUpdateCount() != -1L) {
                    updateCounts[updateCountCounter++] = batchedStatement.getLargeUpdateCount();
                    if (!doGenKeys) continue;
                    generatedKey = batchedStatement.getLastInsertID();
                    row = new byte[1][];
                    row[0] = StringUtils.getBytes(Long.toString(generatedKey));
                    this.batchedGeneratedKeys.add(new ByteArrayRow((byte[][])row, this.getExceptionInterceptor()));
                }
                return updateCountCounter;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    protected SQLException handleExceptionForBatch(int endOfBatchIndex, int numValuesPerBatch, long[] updateCounts, SQLException ex) throws BatchUpdateException, SQLException {
        for (int j = endOfBatchIndex; j > endOfBatchIndex - numValuesPerBatch; --j) {
            updateCounts[j] = -3L;
        }
        if (this.continueBatchOnError && !(ex instanceof MySQLTimeoutException) && !(ex instanceof MySQLStatementCancelledException) && !this.hasDeadlockOrTimeoutRolledBackTx(ex)) {
            return ex;
        }
        long[] newUpdateCounts = new long[endOfBatchIndex];
        System.arraycopy(updateCounts, 0, newUpdateCounts, 0, endOfBatchIndex);
        throw SQLError.createBatchUpdateException(ex, newUpdateCounts, this.getExceptionInterceptor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                JdbcConnection locallyScopedConn = this.connection;
                this.retrieveGeneratedKeys = false;
                this.checkNullOrEmptyQuery(sql);
                this.resetCancelledState();
                this.implicitlyCloseAllOpenResults();
                if (sql.charAt(0) == '/' && sql.startsWith(PING_MARKER)) {
                    this.doPingInstead();
                    return this.results;
                }
                this.setupStreamingTimeout(locallyScopedConn);
                if (this.doEscapeProcessing) {
                    Object escapedSqlResult = EscapeProcessor.escapeSQL(sql, this.session.getServerSession().getSessionTimeZone(), this.session.getServerSession().getCapabilities().serverSupportsFracSecs(), this.session.getServerSession().isServerTruncatesFracSecs(), this.getExceptionInterceptor());
                    String string = sql = escapedSqlResult instanceof String ? (String)escapedSqlResult : ((EscapeProcessorResult)escapedSqlResult).escapedSql;
                }
                if (!this.isResultSetProducingQuery(sql)) {
                    throw SQLError.createSQLException(Messages.getString("Statement.57"), "S1009", this.getExceptionInterceptor());
                }
                CachedResultSetMetaData cachedMetaData = null;
                if (this.useServerFetch()) {
                    this.results = this.createResultSetUsingServerFetch(sql);
                    return this.results;
                }
                CancelQueryTask timeoutTask = null;
                String oldDb = null;
                try {
                    timeoutTask = this.startQueryTimer(this, this.getTimeoutInMillis());
                    if (!locallyScopedConn.getDatabase().equals(this.getCurrentDatabase())) {
                        oldDb = locallyScopedConn.getDatabase();
                        locallyScopedConn.setDatabase(this.getCurrentDatabase());
                    }
                    if (locallyScopedConn.getPropertySet().getBooleanProperty(PropertyKey.cacheResultSetMetadata).getValue().booleanValue()) {
                        cachedMetaData = locallyScopedConn.getCachedMetaData(sql);
                    }
                    locallyScopedConn.setSessionMaxRows(this.maxRows);
                    this.statementBegins();
                    this.results = (ResultSetInternalMethods)((NativeSession)locallyScopedConn.getSession()).execSQL(this, sql, this.maxRows, null, this.createStreamingResultSet(), this.getResultSetFactory(), cachedMetaData, false);
                    if (timeoutTask != null) {
                        this.stopQueryTimer(timeoutTask, true, true);
                        timeoutTask = null;
                    }
                }
                catch (CJTimeoutException | OperationCancelledException e) {
                    throw SQLExceptionsMapping.translateException(e, this.exceptionInterceptor);
                }
                finally {
                    this.query.getStatementExecuting().set(false);
                    this.stopQueryTimer(timeoutTask, false, false);
                    if (oldDb != null) {
                        locallyScopedConn.setDatabase(oldDb);
                    }
                }
                this.lastInsertId = this.results.getUpdateID();
                if (cachedMetaData != null) {
                    locallyScopedConn.initializeResultsMetadataFromCache(sql, cachedMetaData, this.results);
                } else if (this.connection.getPropertySet().getBooleanProperty(PropertyKey.cacheResultSetMetadata).getValue().booleanValue()) {
                    locallyScopedConn.initializeResultsMetadataFromCache(sql, null, this.results);
                }
                return this.results;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPingInstead() throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                ResultSetInternalMethods fakeSelectOneResultSet;
                if (this.pingTarget != null) {
                    try {
                        this.pingTarget.doPing();
                    }
                    catch (SQLException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw SQLError.createSQLException(e.getMessage(), "08S01", e, this.getExceptionInterceptor());
                    }
                } else {
                    this.connection.ping();
                }
                this.results = fakeSelectOneResultSet = this.generatePingResultSet();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultSetInternalMethods generatePingResultSet() throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                String encoding = this.session.getServerSession().getCharsetSettings().getMetadataEncoding();
                int collationIndex = this.session.getServerSession().getCharsetSettings().getMetadataCollationIndex();
                Field[] fields = new Field[]{new Field(null, "1", collationIndex, encoding, MysqlType.BIGINT, 1)};
                ArrayList<ByteArrayRow> rows = new ArrayList<ByteArrayRow>();
                byte[] colVal = new byte[]{49};
                rows.add(new ByteArrayRow(new byte[][]{colVal}, this.getExceptionInterceptor()));
                return this.resultSetFactory.createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(rows, new DefaultColumnDefinition(fields)));
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeSimpleNonQuery(JdbcConnection c, String nonQuery) throws SQLException {
        try {
            Object object = c.getConnectionMutex();
            synchronized (object) {
                ((ResultSetImpl)((NativeSession)c.getSession()).execSQL(this, nonQuery, -1, null, false, this.getResultSetFactory(), null, false)).close();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        try {
            return Util.truncateAndConvertToInt(this.executeLargeUpdate(sql));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long executeUpdateInternal(String sql, boolean isBatch, boolean returnGeneratedKeys) throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                String oldDb;
                CancelQueryTask timeoutTask;
                ResultSetInternalMethods rs;
                char firstStatementChar;
                JdbcConnection locallyScopedConn;
                block17: {
                    locallyScopedConn = this.connection;
                    this.checkNullOrEmptyQuery(sql);
                    this.resetCancelledState();
                    firstStatementChar = QueryInfo.firstCharOfStatementUc(sql, this.session.getServerSession().isNoBackslashEscapesSet());
                    if (!this.isNonResultSetProducingQuery(sql)) {
                        throw SQLError.createSQLException(Messages.getString("Statement.46"), "01S03", this.getExceptionInterceptor());
                    }
                    this.retrieveGeneratedKeys = returnGeneratedKeys;
                    this.lastQueryIsOnDupKeyUpdate = returnGeneratedKeys && firstStatementChar == 'I' && this.containsOnDuplicateKeyInString(sql);
                    rs = null;
                    if (this.doEscapeProcessing) {
                        Object escapedSqlResult = EscapeProcessor.escapeSQL(sql, this.session.getServerSession().getSessionTimeZone(), this.session.getServerSession().getCapabilities().serverSupportsFracSecs(), this.session.getServerSession().isServerTruncatesFracSecs(), this.getExceptionInterceptor());
                        String string = sql = escapedSqlResult instanceof String ? (String)escapedSqlResult : ((EscapeProcessorResult)escapedSqlResult).escapedSql;
                    }
                    if (locallyScopedConn.isReadOnly(false)) {
                        throw SQLError.createSQLException(Messages.getString("Statement.42") + Messages.getString("Statement.43"), "S1009", this.getExceptionInterceptor());
                    }
                    this.implicitlyCloseAllOpenResults();
                    timeoutTask = null;
                    oldDb = null;
                    try {
                        timeoutTask = this.startQueryTimer(this, this.getTimeoutInMillis());
                        if (!locallyScopedConn.getDatabase().equals(this.getCurrentDatabase())) {
                            oldDb = locallyScopedConn.getDatabase();
                            locallyScopedConn.setDatabase(this.getCurrentDatabase());
                        }
                        locallyScopedConn.setSessionMaxRows(-1);
                        this.statementBegins();
                        rs = (ResultSetInternalMethods)((NativeSession)locallyScopedConn.getSession()).execSQL(this, sql, -1, null, false, this.getResultSetFactory(), null, isBatch);
                        if (timeoutTask == null) break block17;
                        this.stopQueryTimer(timeoutTask, true, true);
                        timeoutTask = null;
                    }
                    catch (CJTimeoutException | OperationCancelledException e) {
                        try {
                            throw SQLExceptionsMapping.translateException(e, this.exceptionInterceptor);
                        }
                        catch (Throwable throwable) {
                            this.stopQueryTimer(timeoutTask, false, false);
                            if (oldDb != null) {
                                locallyScopedConn.setDatabase(oldDb);
                            }
                            if (!isBatch) {
                                this.query.getStatementExecuting().set(false);
                            }
                            throw throwable;
                        }
                    }
                }
                this.stopQueryTimer(timeoutTask, false, false);
                if (oldDb != null) {
                    locallyScopedConn.setDatabase(oldDb);
                }
                if (!isBatch) {
                    this.query.getStatementExecuting().set(false);
                }
                this.results = rs;
                rs.setFirstCharOfQuery(firstStatementChar);
                this.updateCount = rs.getUpdateCount();
                this.lastInsertId = rs.getUpdateID();
                return this.updateCount;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            return Util.truncateAndConvertToInt(this.executeLargeUpdate(sql, autoGeneratedKeys));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            return Util.truncateAndConvertToInt(this.executeLargeUpdate(sql, columnIndexes));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            return Util.truncateAndConvertToInt(this.executeLargeUpdate(sql, columnNames));
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                return this.connection;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            return 1000;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFetchSize() throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                return this.query.getResultFetchSize();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                if (!this.retrieveGeneratedKeys) {
                    throw SQLError.createSQLException(Messages.getString("Statement.GeneratedKeysNotRequested"), "S1009", this.getExceptionInterceptor());
                }
                if (this.batchedGeneratedKeys == null) {
                    if (this.lastQueryIsOnDupKeyUpdate) {
                        this.generatedKeysResults = this.getGeneratedKeysInternal(1L);
                        return this.generatedKeysResults;
                    }
                    this.generatedKeysResults = this.getGeneratedKeysInternal();
                    return this.generatedKeysResults;
                }
                String encoding = this.session.getServerSession().getCharsetSettings().getMetadataEncoding();
                int collationIndex = this.session.getServerSession().getCharsetSettings().getMetadataCollationIndex();
                Field[] fields = new Field[]{new Field("", "GENERATED_KEY", collationIndex, encoding, MysqlType.BIGINT_UNSIGNED, 20)};
                this.generatedKeysResults = this.resultSetFactory.createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(this.batchedGeneratedKeys, new DefaultColumnDefinition(fields)));
                return this.generatedKeysResults;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    protected ResultSetInternalMethods getGeneratedKeysInternal() throws SQLException {
        long numKeys = this.getLargeUpdateCount();
        return this.getGeneratedKeysInternal(numKeys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultSetInternalMethods getGeneratedKeysInternal(long numKeys) throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                String encoding = this.session.getServerSession().getCharsetSettings().getMetadataEncoding();
                int collationIndex = this.session.getServerSession().getCharsetSettings().getMetadataCollationIndex();
                Field[] fields = new Field[]{new Field("", "GENERATED_KEY", collationIndex, encoding, MysqlType.BIGINT_UNSIGNED, 20)};
                ArrayList<ByteArrayRow> rowSet = new ArrayList<ByteArrayRow>();
                long beginAt = this.getLastInsertID();
                if (this.results != null) {
                    String serverInfo = this.results.getServerInfo();
                    if (numKeys > 0L && this.results.getFirstCharOfQuery() == 'R' && serverInfo != null && serverInfo.length() > 0) {
                        numKeys = this.getRecordCountFromInfo(serverInfo);
                    }
                    if (beginAt != 0L && numKeys > 0L) {
                        int i = 0;
                        while ((long)i < numKeys) {
                            byte[][] row = new byte[1][];
                            if (beginAt > 0L) {
                                row[0] = StringUtils.getBytes(Long.toString(beginAt));
                            } else {
                                byte[] asBytes = new byte[8];
                                asBytes[7] = (byte)(beginAt & 0xFFL);
                                asBytes[6] = (byte)(beginAt >>> 8);
                                asBytes[5] = (byte)(beginAt >>> 16);
                                asBytes[4] = (byte)(beginAt >>> 24);
                                asBytes[3] = (byte)(beginAt >>> 32);
                                asBytes[2] = (byte)(beginAt >>> 40);
                                asBytes[1] = (byte)(beginAt >>> 48);
                                asBytes[0] = (byte)(beginAt >>> 56);
                                BigInteger val = new BigInteger(1, asBytes);
                                row[0] = val.toString().getBytes();
                            }
                            rowSet.add(new ByteArrayRow(row, this.getExceptionInterceptor()));
                            beginAt += (long)this.connection.getAutoIncrementIncrement();
                            ++i;
                        }
                    }
                }
                ResultSetImpl gkRs = this.resultSetFactory.createFromResultsetRows(1007, 1004, new ResultsetRowsStatic(rowSet, new DefaultColumnDefinition(fields)));
                return gkRs;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastInsertID() {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                return this.lastInsertId;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLongUpdateCount() {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                if (this.results == null) {
                    return -1L;
                }
                if (this.results.hasRows()) {
                    return -1L;
                }
                return this.updateCount;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxFieldSize() throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                return this.maxFieldSize;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxRows() throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                if (this.maxRows <= 0) {
                    return 0;
                }
                return this.maxRows;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        try {
            return this.getMoreResults(1);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMoreResults(int current) throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                boolean moreResults;
                if (this.results == null) {
                    return false;
                }
                boolean streamingMode = this.createStreamingResultSet();
                if (streamingMode && this.results.hasRows()) {
                    while (this.results.next()) {
                    }
                }
                ResultSetInternalMethods nextResultSet = (ResultSetInternalMethods)this.results.getNextResultset();
                switch (current) {
                    case 1: {
                        if (this.results == null) break;
                        if (!streamingMode && !this.dontTrackOpenResources.getValue().booleanValue()) {
                            this.results.realClose(false);
                        }
                        this.results.clearNextResultset();
                        break;
                    }
                    case 3: {
                        if (this.results != null) {
                            if (!streamingMode && !this.dontTrackOpenResources.getValue().booleanValue()) {
                                this.results.realClose(false);
                            }
                            this.results.clearNextResultset();
                        }
                        this.closeAllOpenResults();
                        break;
                    }
                    case 2: {
                        if (!this.dontTrackOpenResources.getValue().booleanValue()) {
                            this.openResults.add(this.results);
                        }
                        this.results.clearNextResultset();
                        break;
                    }
                    default: {
                        throw SQLError.createSQLException(Messages.getString("Statement.19"), "S1009", this.getExceptionInterceptor());
                    }
                }
                this.results = nextResultSet;
                if (this.results == null) {
                    this.updateCount = -1L;
                    this.lastInsertId = -1L;
                } else if (this.results.hasRows()) {
                    this.updateCount = -1L;
                    this.lastInsertId = -1L;
                } else {
                    this.updateCount = this.results.getUpdateCount();
                    this.lastInsertId = this.results.getUpdateID();
                }
                boolean bl = moreResults = this.results != null && this.results.hasRows();
                if (!moreResults) {
                    this.checkAndPerformCloseOnCompletionAction();
                }
                return moreResults;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getQueryTimeout() throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                return this.getTimeoutInMillis() / 1000;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    private long getRecordCountFromInfo(String serverInfo) {
        int i;
        StringBuilder recordsBuf = new StringBuilder();
        long recordsCount = 0L;
        long duplicatesCount = 0L;
        char c = '\u0000';
        int length = serverInfo.length();
        for (i = 0; i < length && !Character.isDigit(c = serverInfo.charAt(i)); ++i) {
        }
        recordsBuf.append(c);
        ++i;
        while (i < length && Character.isDigit(c = serverInfo.charAt(i))) {
            recordsBuf.append(c);
            ++i;
        }
        recordsCount = Long.parseLong(recordsBuf.toString());
        StringBuilder duplicatesBuf = new StringBuilder();
        while (i < length && !Character.isDigit(c = serverInfo.charAt(i))) {
            ++i;
        }
        duplicatesBuf.append(c);
        ++i;
        while (i < length && Character.isDigit(c = serverInfo.charAt(i))) {
            duplicatesBuf.append(c);
            ++i;
        }
        duplicatesCount = Long.parseLong(duplicatesBuf.toString());
        return recordsCount - duplicatesCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getResultSet() throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                return this.results != null && this.results.hasRows() ? this.results : null;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getResultSetConcurrency() throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                return this.resultSetConcurrency;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            return 1;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSetInternalMethods getResultSetInternal() {
        try {
            try {
                Object object = this.checkClosed().getConnectionMutex();
                synchronized (object) {
                    return this.results;
                }
            }
            catch (StatementIsClosedException e) {
                return this.results;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getResultSetType() throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                return this.query.getResultType().getIntValue();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        try {
            return Util.truncateAndConvertToInt(this.getLargeUpdateCount());
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                if (this.isClearWarningsCalled()) {
                    return null;
                }
                SQLWarning pendingWarningsFromServer = this.session.getProtocol().convertShowWarningsToSQLWarnings(false);
                if (this.warningChain != null) {
                    this.warningChain.setNextWarning(pendingWarningsFromServer);
                } else {
                    this.warningChain = pendingWarningsFromServer;
                }
                return this.warningChain;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    protected void realClose(boolean calledExplicitly, boolean closeOpenResults) throws SQLException {
        JdbcConnection locallyScopedConn = this.connection;
        if (locallyScopedConn == null || this.isClosed) {
            return;
        }
        if (!this.dontTrackOpenResources.getValue().booleanValue()) {
            locallyScopedConn.unregisterStatement(this);
        }
        if (this.useUsageAdvisor && !calledExplicitly) {
            this.session.getProfilerEventHandler().processEvent((byte)0, this.session, this, null, 0L, new Throwable(), Messages.getString("Statement.63"));
        }
        if (closeOpenResults) {
            boolean bl = closeOpenResults = !this.holdResultsOpenOverClose && this.dontTrackOpenResources.getValue() == false;
        }
        if (closeOpenResults) {
            if (this.results != null) {
                try {
                    this.results.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.generatedKeysResults != null) {
                try {
                    this.generatedKeysResults.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.closeAllOpenResults();
        }
        this.clearAttributes();
        this.isClosed = true;
        this.closeQuery();
        this.results = null;
        this.generatedKeysResults = null;
        this.connection = null;
        this.session = null;
        this.warningChain = null;
        this.openResults = null;
        this.batchedGeneratedKeys = null;
        this.pingTarget = null;
        this.resultSetFactory = null;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        try {
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                this.doEscapeProcessing = enable;
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        try {
            switch (direction) {
                case 1000: 
                case 1001: 
                case 1002: {
                    break;
                }
                default: {
                    throw SQLError.createSQLException(Messages.getString("Statement.5"), "S1009", this.getExceptionInterceptor());
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFetchSize(int rows) throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                if (rows < 0 && rows != Integer.MIN_VALUE || this.maxRows > 0 && rows > this.getMaxRows()) {
                    throw SQLError.createSQLException(Messages.getString("Statement.7"), "S1009", this.getExceptionInterceptor());
                }
                this.query.setResultFetchSize(rows);
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHoldResultsOpenOverClose(boolean holdResultsOpenOverClose) {
        try {
            try {
                Object object = this.checkClosed().getConnectionMutex();
                synchronized (object) {
                    this.holdResultsOpenOverClose = holdResultsOpenOverClose;
                }
            }
            catch (StatementIsClosedException statementIsClosedException) {
                // empty catch block
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                if (max < 0) {
                    throw SQLError.createSQLException(Messages.getString("Statement.11"), "S1009", this.getExceptionInterceptor());
                }
                int maxBuf = this.maxAllowedPacket.getValue();
                if (max > maxBuf) {
                    throw SQLError.createSQLException(Messages.getString("Statement.13", new Object[]{(long)maxBuf}), "S1009", this.getExceptionInterceptor());
                }
                this.maxFieldSize = max;
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        try {
            this.setLargeMaxRows(max);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                if (seconds < 0) {
                    throw SQLError.createSQLException(Messages.getString("Statement.21"), "S1009", this.getExceptionInterceptor());
                }
                this.setTimeoutInMillis(seconds * 1000);
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setResultSetConcurrency(int concurrencyFlag) throws SQLException {
        try {
            try {
                Object object = this.checkClosed().getConnectionMutex();
                synchronized (object) {
                    this.resultSetConcurrency = concurrencyFlag;
                    this.resultSetFactory = new ResultSetFactory(this.connection, this);
                }
            }
            catch (StatementIsClosedException statementIsClosedException) {
                // empty catch block
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setResultSetType(Resultset.Type typeFlag) throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                this.query.setResultType(typeFlag);
                this.resultSetFactory = new ResultSetFactory(this.connection, this);
            }
        }
        catch (StatementIsClosedException statementIsClosedException) {
            // empty catch block
        }
    }

    void setResultSetType(int typeFlag) throws SQLException {
        this.query.setResultType(Resultset.Type.fromValue(typeFlag, Resultset.Type.FORWARD_ONLY));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getBatchedGeneratedKeys(Statement batchedStatement) throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                if (this.retrieveGeneratedKeys) {
                    try (ResultSet rs = null;){
                        rs = batchedStatement.getGeneratedKeys();
                        while (rs.next()) {
                            this.batchedGeneratedKeys.add(new ByteArrayRow(new byte[][]{rs.getBytes(1)}, this.getExceptionInterceptor()));
                        }
                    }
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getBatchedGeneratedKeys(int maxKeys) throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                if (this.retrieveGeneratedKeys) {
                    ResultSetInternalMethods rs = null;
                    try {
                        ResultSetInternalMethods resultSetInternalMethods = rs = maxKeys == 0 ? this.getGeneratedKeysInternal() : this.getGeneratedKeysInternal(maxKeys);
                        while (rs.next()) {
                            this.batchedGeneratedKeys.add(new ByteArrayRow(new byte[][]{rs.getBytes(1)}, this.getExceptionInterceptor()));
                        }
                    }
                    finally {
                        this.isImplicitlyClosingResults = true;
                        try {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                        finally {
                            this.isImplicitlyClosingResults = false;
                        }
                    }
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean useServerFetch() throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                return this.session.getPropertySet().getBooleanProperty(PropertyKey.useCursorFetch).getValue() != false && this.query.getResultFetchSize() > 0 && this.query.getResultType() == Resultset.Type.FORWARD_ONLY;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() throws SQLException {
        try {
            JdbcConnection locallyScopedConn = this.connection;
            if (locallyScopedConn == null) {
                return true;
            }
            Object object = locallyScopedConn.getConnectionMutex();
            synchronized (object) {
                return this.isClosed;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        try {
            this.checkClosed();
            return this.isPoolable;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        try {
            this.checkClosed();
            this.isPoolable = poolable;
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        try {
            this.checkClosed();
            return iface.isInstance(this);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            try {
                return iface.cast(this);
            }
            catch (ClassCastException cce) {
                throw SQLError.createSQLException(Messages.getString("Common.UnableToUnwrap", new Object[]{iface.toString()}), "S1009", this.getExceptionInterceptor());
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public InputStream getLocalInfileInputStream() {
        return this.session.getLocalInfileInputStream();
    }

    @Override
    public void setLocalInfileInputStream(InputStream stream) {
        this.session.setLocalInfileInputStream(stream);
    }

    @Override
    public void setPingTarget(PingTarget pingTarget) {
        this.pingTarget = pingTarget;
    }

    @Override
    public ExceptionInterceptor getExceptionInterceptor() {
        return this.exceptionInterceptor;
    }

    protected boolean containsOnDuplicateKeyInString(String sql) {
        return (!this.dontCheckOnDuplicateKeyUpdateInSQL || this.rewriteBatchedStatements.getValue() != false) && QueryInfo.containsOnDuplicateKeyUpdateClause(sql, this.session.getServerSession().isNoBackslashEscapesSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeOnCompletion() throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                this.closeOnCompletion = true;
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                return this.closeOnCompletion;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        try {
            return this.executeBatchInternal();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        try {
            return this.executeUpdateInternal(sql, false, false);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            return this.executeUpdateInternal(sql, false, autoGeneratedKeys == 1);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            return this.executeUpdateInternal(sql, false, columnIndexes != null && columnIndexes.length > 0);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            return this.executeUpdateInternal(sql, false, columnNames != null && columnNames.length > 0);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        try {
            return this.getMaxRows();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLargeUpdateCount() throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                if (this.results == null) {
                    return -1L;
                }
                if (this.results.hasRows()) {
                    return -1L;
                }
                return this.results.getUpdateCount();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        try {
            Object object = this.checkClosed().getConnectionMutex();
            synchronized (object) {
                if (max > 50000000L || max < 0L) {
                    throw SQLError.createSQLException(Messages.getString("Statement.15") + max + " > " + 50000000 + ".", "S1009", this.getExceptionInterceptor());
                }
                if (max == 0L) {
                    max = -1L;
                }
                this.maxRows = (int)max;
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public String getCurrentDatabase() {
        return this.query.getCurrentDatabase();
    }

    public long getServerStatementId() {
        throw ExceptionFactory.createException(CJOperationNotSupportedException.class, Messages.getString("Statement.65"));
    }

    @Override
    public <T extends Resultset, M extends Message> ProtocolEntityFactory<T, M> getResultSetFactory() {
        return this.resultSetFactory;
    }

    @Override
    public int getId() {
        return this.query.getId();
    }

    @Override
    public void setCancelStatus(Query.CancelStatus cs) {
        this.query.setCancelStatus(cs);
    }

    @Override
    public void checkCancelTimeout() {
        try {
            this.query.checkCancelTimeout();
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public Object getCancelTimeoutMutex() {
        return this.query.getCancelTimeoutMutex();
    }

    @Override
    public void closeQuery() {
        if (this.query != null) {
            this.query.closeQuery();
        }
    }

    @Override
    public int getResultFetchSize() {
        return this.query.getResultFetchSize();
    }

    @Override
    public void setResultFetchSize(int fetchSize) {
        this.query.setResultFetchSize(fetchSize);
    }

    @Override
    public Resultset.Type getResultType() {
        return this.query.getResultType();
    }

    @Override
    public void setResultType(Resultset.Type resultSetType) {
        this.query.setResultType(resultSetType);
    }

    @Override
    public int getTimeoutInMillis() {
        return this.query.getTimeoutInMillis();
    }

    @Override
    public void setTimeoutInMillis(int timeoutInMillis) {
        this.query.setTimeoutInMillis(timeoutInMillis);
    }

    @Override
    public long getExecuteTime() {
        return this.query.getExecuteTime();
    }

    @Override
    public void setExecuteTime(long executeTime) {
        this.query.setExecuteTime(executeTime);
    }

    @Override
    public AtomicBoolean getStatementExecuting() {
        return this.query.getStatementExecuting();
    }

    @Override
    public void setCurrentDatabase(String currentDb) {
        this.query.setCurrentDatabase(currentDb);
    }

    @Override
    public boolean isClearWarningsCalled() {
        return this.query.isClearWarningsCalled();
    }

    @Override
    public void setClearWarningsCalled(boolean clearWarningsCalled) {
        this.query.setClearWarningsCalled(clearWarningsCalled);
    }

    @Override
    public Query getQuery() {
        return this.query;
    }

    @Override
    public QueryAttributesBindings getQueryAttributesBindings() {
        return this.query.getQueryAttributesBindings();
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.getQueryAttributesBindings().setAttribute(name, value);
    }

    @Override
    public void clearAttributes() {
        QueryAttributesBindings qab = this.getQueryAttributesBindings();
        if (qab != null) {
            qab.clearAttributes();
        }
    }
}

