/*
 * Decompiled with CFR 0.152.
 */
package eu.kennytv.maintenance.lib.mysql.cj.jdbc;

import eu.kennytv.maintenance.lib.mysql.cj.MysqlConnection;
import eu.kennytv.maintenance.lib.mysql.cj.ServerVersion;
import eu.kennytv.maintenance.lib.mysql.cj.TransactionEventHandler;
import eu.kennytv.maintenance.lib.mysql.cj.interceptors.QueryInterceptor;
import eu.kennytv.maintenance.lib.mysql.cj.jdbc.ClientInfoProvider;
import eu.kennytv.maintenance.lib.mysql.cj.jdbc.JdbcPreparedStatement;
import eu.kennytv.maintenance.lib.mysql.cj.jdbc.JdbcPropertySet;
import eu.kennytv.maintenance.lib.mysql.cj.jdbc.JdbcStatement;
import eu.kennytv.maintenance.lib.mysql.cj.jdbc.result.CachedResultSetMetaData;
import eu.kennytv.maintenance.lib.mysql.cj.jdbc.result.ResultSetInternalMethods;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

public interface JdbcConnection
extends Connection,
MysqlConnection,
TransactionEventHandler {
    @Override
    public JdbcPropertySet getPropertySet();

    public void changeUser(String var1, String var2) throws SQLException;

    @Deprecated
    public void clearHasTriedMaster();

    public PreparedStatement clientPrepareStatement(String var1) throws SQLException;

    public PreparedStatement clientPrepareStatement(String var1, int var2) throws SQLException;

    public PreparedStatement clientPrepareStatement(String var1, int var2, int var3) throws SQLException;

    public PreparedStatement clientPrepareStatement(String var1, int[] var2) throws SQLException;

    public PreparedStatement clientPrepareStatement(String var1, int var2, int var3, int var4) throws SQLException;

    public PreparedStatement clientPrepareStatement(String var1, String[] var2) throws SQLException;

    public int getActiveStatementCount();

    public long getIdleFor();

    public String getStatementComment();

    @Deprecated
    public boolean hasTriedMaster();

    public boolean isInGlobalTx();

    public void setInGlobalTx(boolean var1);

    public boolean isSourceConnection();

    @Deprecated
    default public boolean isMasterConnection() {
        return this.isSourceConnection();
    }

    public boolean isSameResource(JdbcConnection var1);

    public boolean lowerCaseTableNames();

    public void ping() throws SQLException;

    public void resetServerState() throws SQLException;

    public PreparedStatement serverPrepareStatement(String var1) throws SQLException;

    public PreparedStatement serverPrepareStatement(String var1, int var2) throws SQLException;

    public PreparedStatement serverPrepareStatement(String var1, int var2, int var3) throws SQLException;

    public PreparedStatement serverPrepareStatement(String var1, int var2, int var3, int var4) throws SQLException;

    public PreparedStatement serverPrepareStatement(String var1, int[] var2) throws SQLException;

    public PreparedStatement serverPrepareStatement(String var1, String[] var2) throws SQLException;

    public void setFailedOver(boolean var1);

    public void setStatementComment(String var1);

    public void shutdownServer() throws SQLException;

    public int getAutoIncrementIncrement();

    public boolean hasSameProperties(JdbcConnection var1);

    public String getHost();

    public String getHostPortPair();

    public void setProxy(JdbcConnection var1);

    public boolean isServerLocal() throws SQLException;

    public int getSessionMaxRows();

    public void setSessionMaxRows(int var1) throws SQLException;

    public void abortInternal() throws SQLException;

    public boolean isProxySet();

    public CachedResultSetMetaData getCachedMetaData(String var1);

    public String getCharacterSetMetadata();

    public Statement getMetadataSafeStatement() throws SQLException;

    public ServerVersion getServerVersion();

    public List<QueryInterceptor> getQueryInterceptorsInstances();

    public void initializeResultsMetadataFromCache(String var1, CachedResultSetMetaData var2, ResultSetInternalMethods var3) throws SQLException;

    public void initializeSafeQueryInterceptors() throws SQLException;

    public boolean isReadOnly(boolean var1) throws SQLException;

    public void pingInternal(boolean var1, int var2) throws SQLException;

    public void realClose(boolean var1, boolean var2, boolean var3, Throwable var4) throws SQLException;

    public void recachePreparedStatement(JdbcPreparedStatement var1) throws SQLException;

    public void decachePreparedStatement(JdbcPreparedStatement var1) throws SQLException;

    public void registerStatement(JdbcStatement var1);

    public void setReadOnlyInternal(boolean var1) throws SQLException;

    public boolean storesLowerCaseTableName();

    public void throwConnectionClosedException() throws SQLException;

    public void unregisterStatement(JdbcStatement var1);

    public void unSafeQueryInterceptors() throws SQLException;

    public JdbcConnection getMultiHostSafeProxy();

    public JdbcConnection getMultiHostParentProxy();

    public JdbcConnection getActiveMySQLConnection();

    public ClientInfoProvider getClientInfoProviderImpl() throws SQLException;

    public void setDatabase(String var1) throws SQLException;

    public String getDatabase() throws SQLException;
}

