/*
 * Decompiled with CFR 0.152.
 */
package eu.kennytv.maintenance.lib.mysql.cj.conf;

import eu.kennytv.maintenance.lib.mysql.cj.conf.AbstractRuntimeProperty;
import eu.kennytv.maintenance.lib.mysql.cj.conf.PropertyDefinition;
import eu.kennytv.maintenance.lib.mysql.cj.exceptions.ExceptionFactory;
import eu.kennytv.maintenance.lib.mysql.cj.exceptions.ExceptionInterceptor;
import eu.kennytv.maintenance.lib.mysql.cj.exceptions.WrongArgumentException;

public class IntegerProperty
extends AbstractRuntimeProperty<Integer> {
    private static final long serialVersionUID = 9208223182595760858L;

    public IntegerProperty(PropertyDefinition<Integer> propertyDefinition) {
        super(propertyDefinition);
    }

    @Override
    protected void checkRange(Integer val, String valueAsString, ExceptionInterceptor exceptionInterceptor) {
        if (val < this.getPropertyDefinition().getLowerBound() || val > this.getPropertyDefinition().getUpperBound()) {
            throw ExceptionFactory.createException(WrongArgumentException.class, "The connection property '" + this.getPropertyDefinition().getName() + "' only accepts integer values in the range of " + this.getPropertyDefinition().getLowerBound() + " - " + this.getPropertyDefinition().getUpperBound() + ", the value '" + (valueAsString == null ? Integer.valueOf(val) : valueAsString) + "' exceeds this range.", exceptionInterceptor);
        }
    }
}

