/*
 * Decompiled with CFR 0.152.
 */
package eu.kennytv.maintenance.core.proxy.command.subcommand;

import eu.kennytv.maintenance.api.proxy.Server;
import eu.kennytv.maintenance.core.proxy.MaintenanceProxyPlugin;
import eu.kennytv.maintenance.core.proxy.command.ProxyCommandInfo;
import eu.kennytv.maintenance.core.runnable.MaintenanceRunnableBase;
import eu.kennytv.maintenance.core.util.SenderInfo;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class SingleEndtimerCommand
extends ProxyCommandInfo {
    public SingleEndtimerCommand(MaintenanceProxyPlugin plugin) {
        super(plugin, null);
    }

    @Override
    public boolean hasPermission(SenderInfo sender) {
        return sender.hasMaintenancePermission("timer") || sender.hasPermission("maintenance.singleserver.timer");
    }

    @Override
    public void execute(SenderInfo sender, String[] args) {
        if (args.length == 2) {
            if (this.checkPermission(sender, "timer")) {
                return;
            }
            if (this.plugin.getCommandManager().checkTimerArgs(sender, args[1])) {
                sender.send(this.getHelpMessage());
                return;
            }
            if (!this.plugin.isMaintenance()) {
                sender.send(this.getMessage("alreadyDisabled", new String[0]));
                return;
            }
            this.plugin.startMaintenanceRunnable(Integer.parseInt(args[1]), TimeUnit.MINUTES, false);
            sender.send(this.getMessage("endtimerStarted", "%TIME%", this.plugin.getRunnable().getTime()));
        } else if (args.length == 3) {
            if (this.checkPermission(sender, "singleserver.timer")) {
                return;
            }
            if (this.plugin.getCommandManager().checkTimerArgs(sender, args[2], false)) {
                sender.send(this.getHelpMessage());
                return;
            }
            Server server = this.plugin.getCommandManager().checkSingleTimerServerArg(sender, args[1]);
            if (server == null) {
                return;
            }
            if (!this.plugin.isMaintenance(server)) {
                sender.send(this.getMessage("singleServerAlreadyDisabled", "%SERVER%", server.getName()));
                return;
            }
            MaintenanceRunnableBase runnable = this.plugin.startSingleMaintenanceRunnable(server, Integer.parseInt(args[2]), TimeUnit.MINUTES, false);
            sender.send(this.getMessage("singleEndtimerStarted", "%TIME%", runnable.getTime(), "%SERVER%", server.getName()));
        } else {
            sender.send(this.getHelpMessage());
        }
    }

    @Override
    public List<String> getTabCompletion(SenderInfo sender, String[] args) {
        return args.length == 2 && sender.hasMaintenancePermission("singleserver.timer") ? this.plugin.getCommandManager().getMaintenanceServersCompletion(args[1].toLowerCase()) : Collections.emptyList();
    }
}

