/*
 * Decompiled with CFR 0.152.
 */
package eu.kennytv.maintenance.core.command.subcommand;

import eu.kennytv.maintenance.core.MaintenancePlugin;
import eu.kennytv.maintenance.core.command.CommandInfo;
import eu.kennytv.maintenance.core.util.SenderInfo;
import java.util.concurrent.TimeUnit;

public final class ScheduleTimerCommand
extends CommandInfo {
    public ScheduleTimerCommand(MaintenancePlugin plugin) {
        super(plugin, "timer");
    }

    @Override
    public void execute(SenderInfo sender, String[] args) {
        if (this.checkArgs(sender, args, 3)) {
            return;
        }
        if (this.plugin.getCommandManager().checkTimerArgs(sender, args[1]) || this.plugin.getCommandManager().checkTimerArgs(sender, args[2], false)) {
            sender.send(this.getHelpMessage());
            return;
        }
        if (this.plugin.isMaintenance()) {
            sender.send(this.getMessage("alreadyEnabled", new String[0]));
            return;
        }
        int duration = Integer.parseInt(args[2]);
        this.plugin.scheduleMaintenanceRunnable(Integer.parseInt(args[1]), duration, TimeUnit.MINUTES);
        sender.send(this.getMessage("scheduletimerStarted", "%TIME%", this.plugin.getRunnable().getTime(), "%DURATION%", this.plugin.getFormattedTime(duration * 60)));
    }
}

